/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.utils;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.streams.delegates.StreamListener;
import org.gcube.data.streams.generators.Processor;
import org.gcube.data.trees.data.Node;

public class TMStreamLogger<N extends Node>
extends Processor<N>
implements StreamListener {
    private static GCUBELog logger = new GCUBELog(TMStreamLogger.class);
    static long count = 0L;
    static long starttime = 0L;
    static long size = 0L;
    private static String rformat = "processed %1d elements of avg size %2dKb in %3d ms (%4d/sec)";

    public void onStart() {
        logger.info((Object)"started processing");
        starttime = System.currentTimeMillis();
    }

    public void process(N node) {
        ++count;
        size += node.size();
    }

    public void onEnd() {
        String report;
        if (starttime == 0L) {
            report = "processed 0 elements";
        } else {
            long time = System.currentTimeMillis() - starttime;
            long ratio = Math.round((double)count / (double)time * 1000.0);
            long avgSize = Math.round((double)size / (double)count / 1000.0);
            report = String.format(rformat, count, avgSize, time, ratio);
        }
        logger.info((Object)report);
    }

    public void onClose() {
    }
}

