/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.proxies;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.Callback;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.tm.stubs.SourceBinding;
import org.gcube.data.tm.stubs.SourceBindings;
import org.gcube.data.tm.stubs.TBinderPortType;
import org.gcube.data.tml.proxies.AsyncTBinder;
import org.gcube.data.tml.proxies.BindParams;
import org.gcube.data.tml.proxies.Binding;
import org.gcube.data.tml.proxies.TBinder;
import org.gcube.data.tml.utils.Utils;

public class DefaultTBinder
implements TBinder,
AsyncTBinder {
    private final AsyncProxyDelegate<TBinderPortType> delegate;

    public DefaultTBinder(ProxyDelegate<TBinderPortType> delegate) {
        this.delegate = new AsyncProxyDelegate(delegate);
    }

    @Override
    public List<Binding> bind(BindParams parameters) {
        Utils.notNull(parameters);
        try {
            return (List)this.delegate.make(this.bindCall(parameters));
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Future<List<Binding>> bindAsync(BindParams parameters) {
        Utils.notNull(parameters);
        return this.delegate.makeAsync(this.bindCall(parameters));
    }

    @Override
    public Future<?> bindAsync(BindParams parameters, Callback<List<Binding>> callback) throws RejectedExecutionException {
        Utils.notNull(parameters, callback);
        return this.delegate.makeAsync(this.bindCall(parameters), callback);
    }

    private Call<TBinderPortType, List<Binding>> bindCall(final BindParams parameters) {
        return new Call<TBinderPortType, List<Binding>>(){

            public List<Binding> call(TBinderPortType endpoint) throws Exception {
                SourceBindings output = endpoint.bind(parameters.toStub());
                ArrayList<Binding> bindings = new ArrayList<Binding>();
                if (output != null && output.getBindings() != null) {
                    for (SourceBinding binding : output.getBindings()) {
                        bindings.add(new Binding(binding));
                    }
                }
                return bindings;
            }
        };
    }
}

