/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.proxies;

import java.net.URI;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.exceptions.ServiceException;
import org.gcube.data.streams.Stream;
import org.gcube.data.tm.stubs.TWriterPortType;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.proxies.TWriter;
import org.gcube.data.tml.utils.Utils;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.streams.TreeStreams;

public class DefaultTWriter
implements TWriter {
    private final ProxyDelegate<TWriterPortType> delegate;

    public DefaultTWriter(ProxyDelegate<TWriterPortType> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Tree add(final Tree tree) throws InvalidTreeException {
        Utils.notNull(tree);
        Call<TWriterPortType, Tree> call = new Call<TWriterPortType, Tree>(){

            public Tree call(TWriterPortType endpoint) throws Exception {
                return Utils.toTree(endpoint.add(Utils.toHolder(tree)));
            }
        };
        try {
            Tree e = (Tree)this.delegate.make((Call)call);
            if (e == null) {
                throw new ServiceException("unexpected null response");
            }
            return e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(InvalidTreeException.class);
        }
    }

    @Override
    public Stream<Tree> add(Stream<Tree> trees) {
        URI locator = TreeStreams.publishTreesIn(trees).withDefaults();
        return this.add(locator);
    }

    @Override
    public Stream<Tree> add(final URI locator) {
        Utils.notNull(new Object[]{"resultset locator", locator});
        Call<TWriterPortType, String> call = new Call<TWriterPortType, String>(){

            public String call(TWriterPortType endpoint) throws Exception {
                return endpoint.addRS(locator.toString());
            }
        };
        try {
            String outcomeLocator = (String)this.delegate.make((Call)call);
            if (outcomeLocator == null) {
                throw new ServiceException("unexpected null response");
            }
            return TreeStreams.treesIn((URI)URI.create(outcomeLocator));
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Tree update(final Tree delta) throws InvalidTreeException, UnknownTreeException {
        Utils.notNull(new Object[]{"delta tree", delta});
        Call<TWriterPortType, Tree> call = new Call<TWriterPortType, Tree>(){

            public Tree call(TWriterPortType endpoint) throws Exception {
                return Utils.toTree(endpoint.update(Utils.toHolder(delta)));
            }
        };
        try {
            Tree e = (Tree)this.delegate.make((Call)call);
            if (e == null) {
                throw new ServiceException("unexpected null response");
            }
            return e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(UnknownTreeException.class, InvalidTreeException.class);
        }
    }

    @Override
    public Stream<Tree> update(Stream<Tree> deltas) {
        URI locator = TreeStreams.publishTreesIn(deltas).withDefaults();
        return this.update(locator);
    }

    @Override
    public Stream<Tree> update(final URI locator) {
        Utils.notNull(new Object[]{"resultset locator", locator});
        Call<TWriterPortType, String> call = new Call<TWriterPortType, String>(){

            public String call(TWriterPortType endpoint) throws Exception {
                return endpoint.updateRS(locator.toString());
            }
        };
        try {
            String outcomeLocator = (String)this.delegate.make((Call)call);
            if (outcomeLocator == null) {
                throw new ServiceException("unexpected null response");
            }
            return TreeStreams.treesIn((URI)URI.create(outcomeLocator));
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

