/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.clients.queries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.common.clients.gcore.StatefulQuery;
import org.gcube.data.tml.clients.providers.AbstractProvider;
import org.gcube.data.tml.clients.queries.QueryBuilder;

public class SourceQueryBuilder {
    private static final String RPCondition = "$result/descendant::*[local-name()='%1$s'] eq '%2$s'";
    private static final String QNameRPCondition = "some $type in $result/descendant::*[local-name()='Type'] satisfies (resolve-QName($type,$type) eq QName('%1$s','%2$s'))";
    private static final String sourcePropertyCondition = "some $prop in $result/descendant::*[local-name()='Property'] satisfies (%1$s)";
    private static final String propertyCondition = "$prop/child::*[local-name()='%1$s'] eq '%2$s'";
    private AbstractProvider<?> provider;
    private String sourceId;
    private String name;
    private String plugin;
    private Map<String, String> properties = new HashMap<String, String>();
    private List<QName> types = new ArrayList<QName>();

    protected SourceQueryBuilder(AbstractProvider<?> provider) {
        this.provider = provider;
    }

    public SourceQueryBuilder withId(String id) {
        this.sourceId = id;
        return this;
    }

    public SourceQueryBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public SourceQueryBuilder withType(QName type) {
        this.types.add(type);
        return this;
    }

    public SourceQueryBuilder withPlugin(String name) {
        this.plugin = name;
        return this;
    }

    public SourceQueryBuilder withProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public StatefulQuery build() {
        StatefulQuery query = new StatefulQuery(this.provider);
        String condition = this.toString();
        if (!condition.isEmpty()) {
            query.query().addGenericCondition(condition);
        }
        return query;
    }

    public String toString() {
        ArrayList<String> conditions = new ArrayList<String>();
        if (this.sourceId != null) {
            conditions.add(String.format(RPCondition, "SourceId", this.sourceId));
        }
        if (this.name != null) {
            conditions.add(String.format(RPCondition, "Name", this.name));
        }
        if (!this.types.isEmpty()) {
            for (QName type : this.types) {
                conditions.add(String.format(QNameRPCondition, "Type", type.getNamespaceURI(), type.getLocalPart()));
            }
        }
        if (this.plugin != null) {
            conditions.add(String.format(RPCondition, "Plugin", this.plugin));
        }
        if (!this.properties.isEmpty()) {
            ArrayList<String> propConditions = new ArrayList<String>();
            for (Map.Entry<String, String> prop : this.properties.entrySet()) {
                propConditions.add(String.format(propertyCondition, prop.getKey(), prop.getValue()));
            }
            conditions.add(String.format(sourcePropertyCondition, QueryBuilder.concatenate(propConditions)));
        }
        return conditions.isEmpty() ? "" : QueryBuilder.concatenate(conditions);
    }
}

