package org.gcube.data.tml.exceptions;

import org.gcube.common.clients.Unrecoverable;

/**
 * Raised with requests to service operations that are not supported.
 * 
 * @author Fabio Simeoni
 *
 */
@Unrecoverable
public class UnsupportedOperationException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	/**
	 * Creates an instance.
	 */
	public UnsupportedOperationException() {}
	
	/**
	 * Creates an instance with a message.
	 * @param msg the message
	 */
	public UnsupportedOperationException(String msg) {
		super(msg);
	}
}
