package org.gcube.data.tml.clients;

import java.util.List;

import org.apache.commons.discovery.DiscoveryException;
import org.gcube.data.tm.stubs.SourceBinding;
import org.gcube.data.tml.exceptions.InvalidRequestException;

/**
 * High-level interface to T-Binder services.
 * <p>
 * T-Binder services host plugins that can bind given data sources to T-Reader and T-Writer services, i.e.
 * services that give access to the bound sources under a tree-based model. 
 * T-Binder clients pass {@link BindingParameters} to target service plugins.
 * 
 * 
 * <p>
 * Clients may target T-Binder services at known endpoints (<em>direct mode</em>). Alternatively, they may
 * discover T-Binder services that host given plugins (<em>discovery mode</em>). In discovery mode, clients attempt 
 * to interact with all the services until they succeed with one. They then cache the endpoint 
 * of this service and use it first for subsequent interactions.
 * 
 *  
 * @author Fabio Simeoni
 * @see TReaderClient
 * @see TWriterClient
 *
 */
public interface TBinderClient {

	/**
	 * Binds one ore more data sources to T-Reader and/or T-Writer services.
	 * @param parameters the binding parameters
	 * @return the bindings
	 * @throws IllegalArgumentException if the parameters are <code>null</code>
	 * @throws DiscoveryException if, in discovery mode, there is no service with the target plugin
	 * @throws InvalidRequestException if the parameters are invalid for the service
	 * @throws Exception if the operation fails for any other error
	 */
	public abstract List<SourceBinding> bind(final BindingParameters parameters) throws IllegalArgumentException,DiscoveryException,InvalidRequestException, Exception;

	/**
	 * Binds asynchronously to T-Reader and/or T-Writer services.
	 * @param parameters the binding parameters
	 * @param consumer a consumer for the asynchronous delivery of responses
	 *  @throws IllegalArgumentException if the parameters or the consumer are <code>null</code>
	 * @throws DiscoveryException if, in discovery mode, there is no service with the target plugin
	 * @throws Exception if the operation fails for any other error
	 */
	public abstract void bindAsync(final BindingParameters parameters,final BinderConsumer consumer) throws IllegalArgumentException,DiscoveryException,Exception;

}