/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tmf.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.Calendar;
import org.gcube.data.tmf.api.Environment;
import org.gcube.data.tmf.api.Source;
import org.gcube.data.tmf.api.SourceEvent;
import org.gcube.data.tmf.api.SourceLifecycle;
import org.gcube.data.tmf.api.SourceNotifier;
import org.gcube.data.tmf.api.SourceReader;
import org.gcube.data.tmf.api.SourceWriter;
import org.gcube.data.tmf.api.exceptions.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSource
implements Source {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AbstractSource.class);
    private final String identifier;
    private String name;
    private String description;
    private boolean isUser = true;
    private Long cardinality;
    private Calendar creationTime;
    private Calendar lastUpdate;
    private SourceLifecycle lifecycle;
    private SourceReader reader;
    private SourceWriter writer;
    private Environment environment;
    private transient Thread shutdownhook;
    private SourceNotifier notifier;

    public AbstractSource(String id) throws InvalidRequestException {
        if (id == null) {
            throw new InvalidRequestException("source identifier is null");
        }
        this.identifier = id;
    }

    @Override
    public String id() {
        return this.identifier;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String description() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Calendar creationTime() {
        return this.creationTime;
    }

    public Calendar setCreationTime(Calendar time) {
        this.creationTime = time;
        return this.creationTime;
    }

    public void setUser(boolean isUser) {
        this.isUser = isUser;
    }

    @Override
    public boolean isUser() {
        return this.isUser;
    }

    @Override
    public synchronized Long cardinality() {
        return this.cardinality;
    }

    public synchronized void setCardinality(Long cardinality) {
        if (this.cardinality != cardinality) {
            this.cardinality = cardinality;
        }
    }

    @Override
    public synchronized Calendar lastUpdate() {
        return this.lastUpdate;
    }

    public synchronized void setLastUpdate(Calendar time) {
        if (this.lastUpdate != null && !time.equals(this.lastUpdate)) {
            this.notifier.notify(SourceEvent.CHANGE);
        }
        this.lastUpdate = time;
    }

    @Override
    public SourceLifecycle lifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(SourceLifecycle lifecycle) {
        this.lifecycle = lifecycle;
        this.installShutDownHook();
    }

    @Override
    public SourceReader reader() {
        return this.reader;
    }

    public void setReader(SourceReader reader) {
        log.trace("setting reader to {} on {}", (Object)reader, (Object)this);
        this.reader = reader;
    }

    public void setWriter(SourceWriter writer) {
        log.trace("setting writer to {} on {}", (Object)writer, (Object)this);
        this.writer = writer;
    }

    @Override
    public SourceWriter writer() {
        return this.writer;
    }

    @Override
    public void setNotifier(SourceNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public SourceNotifier notifier() {
        return this.notifier;
    }

    @Override
    public Environment environment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.environment = env;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.lifecycle() == null) {
            throw new IOException("invalid serialisation, missing source lifecycle");
        }
        this.installShutDownHook();
    }

    private void installShutDownHook() {
        log.trace("installing shutdown hook for " + this.id());
        this.shutdownhook = new Thread(new ShutdownHook());
        Runtime.getRuntime().addShutdownHook(this.shutdownhook);
    }

    public String toString() {
        return "[identifier=" + this.identifier + ",name=" + this.name + ", description=" + this.description + ", types=" + this.types() + ", creationTime=" + (this.creationTime == null ? this.creationTime : DateFormat.getInstance().format(this.creationTime.getTime())) + ", isUser=" + this.isUser + ", cardinality=" + this.cardinality + ", lastUpdate=" + (this.lastUpdate == null ? this.lastUpdate : DateFormat.getInstance().format(this.lastUpdate.getTime())) + ", lifecycle=" + this.lifecycle + ", reader=" + this.reader + ", writer=" + this.writer + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.cardinality ^ this.cardinality >>> 32);
        result = 31 * result + (this.creationTime == null ? 0 : this.creationTime.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.isUser ? 1231 : 1237);
        result = 31 * result + (this.lastUpdate == null ? 0 : this.lastUpdate.hashCode());
        result = 31 * result + (this.lifecycle == null ? 0 : this.lifecycle.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.reader == null ? 0 : this.reader.hashCode());
        result = 31 * result + (this.writer == null ? 0 : this.writer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractSource)) {
            return false;
        }
        AbstractSource other = (AbstractSource)obj;
        if (this.cardinality != other.cardinality) {
            return false;
        }
        if (this.creationTime == null ? other.creationTime != null : !this.creationTime.equals(other.creationTime)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        if (this.isUser != other.isUser) {
            return false;
        }
        if (this.lastUpdate == null ? other.lastUpdate != null : !this.lastUpdate.equals(other.lastUpdate)) {
            return false;
        }
        if (this.lifecycle == null ? other.lifecycle != null : !this.lifecycle.equals(other.lifecycle)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.reader == null ? other.reader != null : !this.reader.equals(other.reader)) {
            return false;
        }
        return !(this.writer == null ? other.writer != null : !this.writer.equals(other.writer));
    }

    class ShutdownHook
    implements Runnable {
        ShutdownHook() {
        }

        @Override
        public void run() {
            AbstractSource.this.lifecycle().stop();
        }
    }
}

