/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tmf.impl;

import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.exceptions.StreamSkipException;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tmf.api.SourceWriter;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.exceptions.UnsupportedOperationException;
import org.gcube.data.tml.outcomes.AddTreeOutcome;
import org.gcube.data.tml.outcomes.UpdateTreeFailure;
import org.gcube.data.trees.data.Tree;

public abstract class AbstractWriter
implements SourceWriter {
    private static final long serialVersionUID = 1L;

    @Override
    public Stream<AddTreeOutcome> add(Stream<Tree> stream) throws UnsupportedOperationException, Exception {
        Generator<Tree, AddTreeOutcome> addOne = new Generator<Tree, AddTreeOutcome>(){

            public AddTreeOutcome yield(Tree element) {
                AddTreeOutcome outcome;
                try {
                    Tree tree = AbstractWriter.this.add(element);
                    outcome = new AddTreeOutcome(tree);
                }
                catch (InvalidTreeException e) {
                    outcome = new AddTreeOutcome((Exception)((Object)e));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return outcome;
            }
        };
        return Streams.pipe(stream).through((Generator)addOne);
    }

    @Override
    public Stream<UpdateTreeFailure> update(Stream<Tree> deltaStream) throws UnsupportedOperationException, Exception {
        Generator<Tree, UpdateTreeFailure> updateOne = new Generator<Tree, UpdateTreeFailure>(){

            public UpdateTreeFailure yield(Tree delta) {
                try {
                    AbstractWriter.this.update(delta);
                }
                catch (UnknownTreeException e) {
                    return new UpdateTreeFailure(delta.id(), (Exception)((Object)e));
                }
                catch (InvalidTreeException e) {
                    return new UpdateTreeFailure(delta.id(), (Exception)((Object)e));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                throw new StreamSkipException();
            }
        };
        return Streams.pipe(deltaStream).through((Generator)updateOne);
    }
}

