/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tmf.impl;

import java.util.Arrays;
import java.util.List;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.exceptions.StreamContingencyException;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tm.stubs.Path;
import org.gcube.data.tmf.api.SourceReader;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownPathException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.exceptions.UnsupportedOperationException;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;

public abstract class AbstractReader
implements SourceReader {
    private static final long serialVersionUID = 1L;

    @Override
    public Stream<Tree> get(Stream<String> stream, final Pattern pattern) throws UnsupportedOperationException, UnknownTreeException, InvalidTreeException, Exception {
        Generator<String, Tree> getOne = new Generator<String, Tree>(){

            public Tree yield(String id) {
                try {
                    return AbstractReader.this.get(id, pattern);
                }
                catch (UnknownTreeException e) {
                    throw new StreamContingencyException((Throwable)e);
                }
                catch (InvalidTreeException e) {
                    throw new StreamContingencyException((Throwable)e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return Streams.pipe(stream).through((Generator)getOne);
    }

    @Override
    public Node getNode(String ... path) throws UnsupportedOperationException, UnknownPathException, Exception {
        Tree tree = null;
        List<String> ids = Arrays.asList(path);
        try {
            tree = this.get(path[0], Patterns.hasPath((String[])path));
        }
        catch (Exception e) {
            throw new UnknownPathException("could not resolve path " + ids, (Throwable)e);
        }
        List<String> descendantsIDs = ids.subList(1, ids.size());
        return tree.descendant(descendantsIDs.toArray(new String[0]));
    }

    @Override
    public Stream<Node> getNodes(Stream<Path> stream) throws UnsupportedOperationException, Exception {
        Generator<Path, Node> getOne = new Generator<Path, Node>(){

            public Node yield(Path element) {
                try {
                    return AbstractReader.this.getNode(element.getId());
                }
                catch (UnknownPathException e) {
                    throw new StreamContingencyException((Throwable)e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return Streams.pipe(stream).through((Generator)getOne);
    }
}

