/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.test;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.exceptions.StreamSkipSignal;
import org.gcube.data.streams.test.StreamProvider;

public class Utils {
    public static List<Object> elementsOf(Stream<?> stream) {
        ArrayList<Object> outcomes = new ArrayList<Object>();
        while (stream.hasNext()) {
            try {
                Object e = stream.next();
                outcomes.add(e);
            }
            catch (StreamSkipSignal skip) {
            }
            catch (RuntimeException ex) {
                outcomes.add(ex);
            }
        }
        stream.close();
        return outcomes;
    }

    public static void validateWith(StreamProvider provider) {
        Utils.isAddressableAndClosable(provider.get());
        Utils.canBeIteratedOver(provider.get());
        Utils.respectsCloseSemantics(provider.get());
    }

    private static void isAddressableAndClosable(Stream<?> stream) {
        if (stream.locator() == null) {
            throw new AssertionError((Object)"locator is null");
        }
        if (stream.isClosed()) {
            throw new AssertionError((Object)"stream is already closed");
        }
        stream.close();
        if (!stream.isClosed()) {
            throw new AssertionError((Object)"stream has not been closed");
        }
    }

    private static void respectsCloseSemantics(Stream<?> stream) {
        if (stream.isClosed()) {
            throw new AssertionError((Object)"stream is already closed");
        }
        stream.close();
        if (!stream.isClosed()) {
            throw new AssertionError((Object)"stream has been closed but does not reveal it");
        }
        if (stream.hasNext()) {
            throw new AssertionError((Object)"stream indicates that it has elements after being closed");
        }
        try {
            stream.next();
            throw new AssertionError((Object)"stream returns elements after being closed");
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    private static void canBeIteratedOver(Stream<?> stream) {
        try {
            if (stream.next() == null) {
                throw new AssertionError((Object)"next() returns null");
            }
        }
        catch (NoSuchElementException e) {
            if (stream.hasNext()) {
                throw new AssertionError((Object)"stream has no elements but hasNext() returns true");
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        while (stream.hasNext()) {
            try {
                stream.next();
            }
            catch (RuntimeException runtimeException) {}
        }
        if (stream.hasNext()) {
            throw new AssertionError((Object)"hasNext() is not idempotent");
        }
        try {
            stream.next();
            throw new AssertionError((Object)"stream can be read past its end");
        }
        catch (NoSuchElementException noSuchElementException) {
            stream.close();
            return;
        }
    }
}

