/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.test;

import java.util.Iterator;
import java.util.List;
import org.gcube.data.streams.exceptions.StreamSkipSignal;

public class FallibleIterator<E>
implements Iterator<E> {
    final List<? extends Object> elements;
    final Class<E> clazz;
    int index;

    public FallibleIterator(Class<E> clazz, List<? extends Object> elements) throws IllegalArgumentException {
        this.clazz = clazz;
        for (Object object : elements) {
            try {
                if (object instanceof RuntimeException) continue;
                clazz.cast(object);
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("invalid stream element: " + object + " is neither a " + clazz.getSimpleName() + " nor a RuntimeException");
            }
        }
        this.elements = elements;
    }

    @Override
    public boolean hasNext() {
        if (this.index < this.elements.size()) {
            if (this.elements.get(this.index) instanceof StreamSkipSignal) {
                ++this.index;
                return this.hasNext();
            }
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        Object o = this.elements.get(this.index);
        ++this.index;
        if (o instanceof RuntimeException) {
            throw (RuntimeException)o;
        }
        return this.clazz.cast(o);
    }

    @Override
    public void remove() {
    }
}

