package org.gcube.data.streams;

import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;

import java.net.InetAddress;
import java.util.ArrayList;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Library utils.
 * 
 * @author Fabio Simeoni
 *
 */
public class Utils {

	private static Logger log = LoggerFactory.getLogger(Utils.class);
	
	/**
	 * Initialises gRS2 library.
	 */
	public static synchronized void initialiseRS() {
		
		if (TCPConnectionManager.IsInitialized())
			return;
		
		log.info("gRS2 is not initialised: using defaults");
		
		try {
			TCPConnectionManager.Init(new TCPConnectionManagerConfig(InetAddress.getLocalHost().getHostName(),new ArrayList<PortRange>(),true));
			TCPConnectionManager.RegisterEntry(new TCPConnectionHandler());
		}
		catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
		
}
