/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.delegates;

import java.net.URI;
import org.gcube.data.streams.LookAheadStream;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.generators.Generator;

public class PipedStream<E1, E2>
extends LookAheadStream<E2> {
    private final Stream<E1> stream;
    private final Generator<E1, E2> generator;

    public PipedStream(Stream<E1> stream, Generator<E1, E2> generator) throws IllegalArgumentException {
        if (stream == null) {
            throw new IllegalArgumentException("invalid null stream");
        }
        if (generator == null) {
            throw new IllegalArgumentException("invalid null generator");
        }
        this.stream = stream;
        this.generator = generator;
    }

    @Override
    protected E2 delegateNext() {
        return this.generator.yield(this.stream.next());
    }

    @Override
    protected boolean delegateHasNext() {
        return this.stream.hasNext();
    }

    @Override
    public void close() {
        this.stream.close();
    }

    @Override
    public URI locator() throws IllegalStateException {
        return this.stream.locator();
    }

    @Override
    public void remove() {
        this.stream.remove();
    }
}

