/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.adapters;

import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.adapters.IteratorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IteratorStream<E>
implements Stream<E> {
    private static Logger log = LoggerFactory.getLogger(IteratorStream.class);
    private final Iterator<E> iterator;
    private boolean closed;
    private final IteratorAdapter<E> adapter;

    public IteratorStream(IteratorAdapter<E> adapter) {
        this.iterator = adapter.iterator();
        this.adapter = adapter;
    }

    public IteratorStream(Iterator<E> iterator) {
        this(new IteratorAdapter<E>(iterator));
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    @Override
    public E next() {
        if (this.closed) {
            throw new NoSuchElementException();
        }
        return this.iterator.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.adapter.close();
        }
        catch (Exception e) {
            log.error("could not close iterator " + this.locator(), (Throwable)e);
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public URI locator() {
        return this.adapter.locator();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

