/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.storage.backend.impl;

import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gcube.data.access.storagehub.storage.backend.impl.S3Backend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ObjectInputStreamWrapper
extends InputStream {
    private static final Logger log = LoggerFactory.getLogger(S3ObjectInputStreamWrapper.class);
    private final S3Object s3Object;
    private final S3ObjectInputStream objectContent;
    private boolean closed = false;

    public S3ObjectInputStreamWrapper(S3Object s3Object) {
        this.s3Object = s3Object;
        this.objectContent = s3Object.getObjectContent();
    }

    @Override
    public int read() throws IOException {
        return this.objectContent.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.objectContent.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.objectContent.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.objectContent.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.objectContent.available();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                if (this.objectContent != null) {
                    try {
                        this.objectContent.abort();
                        log.debug("S3ObjectInputStream aborted successfully");
                    }
                    catch (Exception e) {
                        log.warn("Error aborting S3ObjectInputStream, attempting normal close", (Throwable)e);
                    }
                }
            }
            finally {
                try {
                    if (this.s3Object != null) {
                        this.s3Object.close();
                        log.debug("S3Object closed successfully, connection returned to pool");
                    }
                    S3Backend.incrementClosedConnections();
                }
                catch (Exception e) {
                    log.error("Error closing S3Object - connection may leak!", (Throwable)e);
                    throw e;
                }
            }
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.objectContent.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.objectContent.reset();
    }

    @Override
    public boolean markSupported() {
        return this.objectContent.markSupported();
    }
}

