/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.metadata.Ignore;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceMethodSignature;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.regex.Pattern;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.IdNotFoundException;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.items.TrashItem;
import org.gcube.common.storagehub.model.items.VreFolder;
import org.gcube.common.storagehub.model.items.nodes.Content;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.common.storagehub.model.service.Version;
import org.gcube.common.storagehub.model.service.VersionList;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.types.FolderInfoType;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.SearchTask;
import org.gcube.data.access.storagehub.StorageHubApplicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.accounting.ReportHandler;
import org.gcube.data.access.storagehub.handlers.ClassHandler;
import org.gcube.data.access.storagehub.handlers.DownloadHandler;
import org.gcube.data.access.storagehub.handlers.PublicLinkHandler;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.plugins.StorageOperationMediator;
import org.gcube.data.access.storagehub.predicates.IncludeTypePredicate;
import org.gcube.data.access.storagehub.predicates.ItemTypePredicate;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;
import org.gcube.data.access.storagehub.services.Impersonable;
import org.gcube.data.access.storagehub.types.LinkType;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@jakarta.ws.rs.Path(value="items")
@ManagedBy(value=StorageHubApplicationManager.class)
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class ItemsManager
extends Impersonable {
    private static final Logger log;
    private final StoragehubRepository repository = StoragehubRepository.repository;
    private final int SEARCH_THREADS = 4;
    @Inject
    ReportHandler reportHandler;
    @Inject
    AccountingHandler accountingHandler;
    @PathParam(value="id")
    String id;
    @Context
    ServletContext context;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    VersionHandler versionHandler;
    @Inject
    DownloadHandler downloadHandler;
    @Inject
    TrashHandler trashHandler;
    @Inject
    PathUtil pathUtil;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;
    @Inject
    StorageOperationMediator opMediator;
    @Inject
    PublicLinkHandler publicLinkHandler;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$access$storagehub$types$LinkType;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        ItemsManager.ajc$preClinit();
        log = LoggerFactory.getLogger(ItemsManager.class);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResourceMethodSignature(output=ItemWrapper.class, pathParams={@PathParam(value="id")}, queryParams={@QueryParam(value="exclude")})
    @GET
    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=406, condition="Unable to find this item.")})
    @jakarta.ws.rs.Path(value="{id}")
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getById(@QueryParam(value="exclude") List<String> excludes) {
        InnerMethodName.set((String)"getById");
        Session ses = null;
        Item toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            Node node = ses.getNodeByIdentifier(this.id);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            toReturn = this.node2Item.getItem(node, excludes);
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemWrapper(toReturn);
            ses.logout();
            return new ItemWrapper(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error getting item", (Throwable)re)));
            return new ItemWrapper(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemWrapper(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemWrapper(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemWrapper(toReturn);
        ses.logout();
        return new ItemWrapper(toReturn);
    }

    @ResourceMethodSignature(output=ItemWrapper.class, pathParams={@PathParam(value="id")}, queryParams={@QueryParam(value="path"), @QueryParam(value="exclude")})
    @GET
    @jakarta.ws.rs.Path(value="{id}/path")
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getByRelativePath(@QueryParam(value="path") String path, @QueryParam(value="exclude") List<String> excludes) {
        InnerMethodName.set((String)"getByPath");
        Session ses = null;
        Item toReturn = null;
        try {
            String[] paths;
            String relativePath;
            if (path == null || path.isEmpty()) {
                log.debug("attempted search with empty path");
                throw new InvalidCallParameters("empty path");
            }
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            String string = relativePath = path.startsWith("/") ? path.substring(1) : path;
            if (path.endsWith("/")) {
                relativePath.substring(0, relativePath.lastIndexOf("/"));
            }
            if (relativePath.isEmpty()) {
                throw new InvalidCallParameters("empty path");
            }
            Item item = null;
            String nextId = this.id;
            String[] stringArray = paths = relativePath.split("/");
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String actualPath = stringArray[n2];
                item = this.getChildrenMatchingName(ses, nextId, actualPath, Excludes.ALL);
                if (item == null) {
                    throw new InvalidCallParameters("relative path " + actualPath + " not found under item with id " + nextId);
                }
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, item.getId());
                nextId = item.getId();
                ++n2;
            }
            if (excludes.containsAll(Excludes.ALL)) {
                ItemWrapper itemWrapper = new ItemWrapper(item);
                return itemWrapper;
            }
            ItemWrapper itemWrapper = new ItemWrapper(this.node2Item.getItem(ses.getNodeByIdentifier(item.getId()), excludes));
            return itemWrapper;
        }
        catch (RepositoryException re) {
            log.error("jcr error getting item  by path", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error getting item by path", (Throwable)re)));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemWrapper(toReturn);
    }

    private Item getChildrenMatchingName(Session ses, String id, String name, List<String> excludes) throws ItemNotFoundException, RepositoryException, StorageHubException {
        NodeIterator it = ses.getNodeByIdentifier(id).getNodes();
        while (it.hasNext()) {
            Node child = it.nextNode();
            String nodeName = child.getName();
            if (!child.hasProperty(NodeProperty.TITLE.toString())) continue;
            String title = child.getProperty(NodeProperty.TITLE.toString()).getString();
            if (!nodeName.equals(name) && !title.equals(name)) continue;
            return this.node2Item.getItem(child, excludes);
        }
        return null;
    }

    @Ignore
    @Deprecated
    @GET
    @jakarta.ws.rs.Path(value="{id}/items/{name}")
    @Produces(value={"application/json"})
    public ItemList findChildrenByNamePatternInPath(@QueryParam(value="exclude") List<String> excludes, @PathParam(value="name") String name) {
        InnerMethodName.set((String)"findChildrenByNamePattern");
        return this._findChildrenByNamePattern(excludes, name);
    }

    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")}, queryParams={@QueryParam(value="exclude"), @QueryParam(value="name")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=406, condition="Parent item does not exist.")})
    @GET
    @jakarta.ws.rs.Path(value="{id}/items")
    @Produces(value={"application/json"})
    public ItemList findChildrenByNamePattern(@QueryParam(value="exclude") List<String> excludes, @QueryParam(value="name") String name) {
        InnerMethodName.set((String)"findChildrenByNamePattern");
        return this._findChildrenByNamePattern(excludes, name);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemList _findChildrenByNamePattern(List<String> excludes, String name) {
        Session ses = null;
        ArrayList<Item> toReturn = new ArrayList<Item>();
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            NodeIterator it = ses.getNodeByIdentifier(this.id).getNodes();
            while (it.hasNext()) {
                Node child = it.nextNode();
                String nodeName = child.getName();
                if (!child.hasProperty(NodeProperty.TITLE.toString())) continue;
                String title = child.getProperty(NodeProperty.TITLE.toString()).getString();
                String cleanedName = name;
                if (name.startsWith("*")) {
                    cleanedName = name.substring(1);
                }
                if (name.endsWith("*")) {
                    cleanedName = name.substring(0, name.length() - 1);
                }
                if ((!name.startsWith("*") || !nodeName.endsWith(cleanedName) && !title.endsWith(cleanedName)) && (!name.endsWith("*") || !nodeName.startsWith(cleanedName) && !title.startsWith(cleanedName)) && !nodeName.equals(cleanedName) && !title.equals(cleanedName)) continue;
                toReturn.add(this.node2Item.getItem(child, excludes));
            }
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(toReturn);
            ses.logout();
            return new ItemList(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error searching item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error searching item", (Throwable)re)));
            return new ItemList(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(toReturn);
        ses.logout();
        return new ItemList(toReturn);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResourceMethodSignature(output=Long.class, pathParams={@PathParam(value="id")}, queryParams={@QueryParam(value="showHidden"), @QueryParam(value="onlyType")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=406, condition="Parent item does not exist")})
    @GET
    @jakarta.ws.rs.Path(value="{id}/children/count")
    public Long countById(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="onlyType") String nodeType) {
        InnerMethodName.set((String)"countById");
        Session ses = null;
        Long toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                IncludeTypePredicate itemPredicate = nodeType != null ? new IncludeTypePredicate(ClassHandler.instance().get(nodeType)) : null;
                Node node = ses.getNodeByIdentifier(this.id);
                toReturn = Utils.getItemCount((Node)node, (boolean)(showHidden == null ? false : showHidden), (ItemTypePredicate)itemPredicate);
                return toReturn;
            }
            catch (ItemNotFoundException e) {
                log.error("id {} not found", (Object)this.id, (Object)e);
                GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (RuntimeException | RepositoryException re) {
                log.error("jcr error counting item", re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError(re)));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResourceMethodSignature(output=ItemList.class, pathParams={@PathParam(value="id")}, queryParams={@QueryParam(value="showHidden"), @QueryParam(value="exclude"), @QueryParam(value="onlyType")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=406, condition="Parent item does not exist.")})
    @GET
    @jakarta.ws.rs.Path(value="{id}/children")
    @Produces(value={"application/json"})
    public ItemList listById(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="exclude") List<String> excludes, @QueryParam(value="onlyType") String nodeType) {
        InnerMethodName.set((String)"listById");
        Session ses = null;
        List toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            IncludeTypePredicate itemPredicate = nodeType != null ? new IncludeTypePredicate(ClassHandler.instance().get(nodeType)) : null;
            Node node = ses.getNodeByIdentifier(this.id);
            toReturn = Utils.getItemList((Node)node, excludes, null, (boolean)(showHidden == null ? false : showHidden), (ItemTypePredicate)itemPredicate);
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(toReturn);
            ses.logout();
            return new ItemList(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting children", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
            return new ItemList(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(toReturn);
        ses.logout();
        return new ItemList(toReturn);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResourceMethodSignature(output=ItemList.class, pathParams={@PathParam(value="id")}, queryParams={@QueryParam(value="showHidden"), @QueryParam(value="excludeTrashed"), @QueryParam(value="exclude"), @QueryParam(value="onlyType"), @QueryParam(value="name")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=406, condition="Parent item does not exist.")})
    @GET
    @jakarta.ws.rs.Path(value="{id}/search")
    @Produces(value={"application/json"})
    public ItemList searchItems(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="excludeTrashed") Boolean excludeTrashed, @QueryParam(value="exclude") List<String> excludes, @QueryParam(value="onlyType") String nodeType, @QueryParam(value="name") String name) {
        InnerMethodName.set((String)"search");
        Session ses = null;
        LinkedList toReturn = new LinkedList();
        if (name == null || name.isEmpty()) {
            log.debug("attempted search with empty name");
            return new ItemList();
        }
        try {
            Node vreNode;
            SearchTask vreSearchTask;
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            if (name.startsWith("%") && name.endsWith("%")) {
                name = name.substring(1, name.length() - 1);
            }
            log.debug("search for regex \"{}\"", (Object)name);
            IncludeTypePredicate itemPredicate = nodeType != null ? new IncludeTypePredicate(ClassHandler.instance().get(nodeType)) : null;
            Node node = ses.getNodeByIdentifier(this.id);
            Node wsNode = ses.getNode(this.pathUtil.getWorkspacePath(this.currentUser).toPath());
            Pattern pattern = Pattern.compile(name, 2);
            if (showHidden == null) {
                showHidden = false;
            }
            if (excludeTrashed == null) {
                excludeTrashed = true;
            }
            ForkJoinPool threadPool = new ForkJoinPool(4);
            long start = System.currentTimeMillis();
            SearchTask searchTask = new SearchTask(this.currentUser, this.authChecker, node, excludes, null, showHidden.booleanValue(), excludeTrashed.booleanValue(), (ItemTypePredicate)itemPredicate, pattern, this.node2Item, ses);
            List subTaskList = (List)threadPool.invoke(searchTask);
            if (subTaskList != null) {
                toReturn.addAll(subTaskList);
            }
            if (node.getIdentifier().equals(wsNode.getIdentifier()) && (subTaskList = (List)threadPool.invoke(vreSearchTask = new SearchTask(this.currentUser, this.authChecker, vreNode = ses.getNode(this.pathUtil.getVREsPath(this.currentUser, ses).toPath()), excludes, null, showHidden.booleanValue(), excludeTrashed.booleanValue(), (ItemTypePredicate)itemPredicate, pattern, this.node2Item, ses))) != null) {
                toReturn.addAll(subTaskList);
            }
            log.trace("[SEARCH] real search took {} millis", (Object)(System.currentTimeMillis() - start));
            log.debug("search retrieved {} elements", (Object)toReturn.size());
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(toReturn);
            ses.logout();
            return new ItemList(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting children", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
            return new ItemList(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(toReturn);
        ses.logout();
        return new ItemList(toReturn);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResourceMethodSignature(output=ItemList.class, pathParams={@PathParam(value="id")}, queryParams={@QueryParam(value="showHidden"), @QueryParam(value="exclude"), @QueryParam(value="onlyType"), @QueryParam(value="start"), @QueryParam(value="limit")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=406, condition="Parent item does not exist."), @ResponseCode(code=500, condition="Missing 'start' or 'limit' parameter.")})
    @GET
    @jakarta.ws.rs.Path(value="{id}/children/paged")
    @Produces(value={"application/json"})
    public ItemList listByIdPaged(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit, @QueryParam(value="exclude") List<String> excludes, @QueryParam(value="onlyType") String nodeType) {
        InnerMethodName.set((String)"listByIdPaged");
        Session ses = null;
        List toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            IncludeTypePredicate itemPredicate = nodeType != null ? new IncludeTypePredicate(ClassHandler.instance().get(nodeType)) : null;
            Node node = ses.getNodeByIdentifier(this.id);
            toReturn = Utils.getItemList((Node)node, excludes, (Range)new Range(start.intValue(), limit.intValue()), (boolean)(showHidden == null ? false : showHidden), (ItemTypePredicate)itemPredicate);
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(toReturn);
            ses.logout();
            return new ItemList(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting paged children", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
            return new ItemList(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(toReturn);
        ses.logout();
        return new ItemList(toReturn);
    }

    /*
     * Exception decompiling
     */
    @Ignore
    @GET
    @jakarta.ws.rs.Path(value="publiclink/{id}")
    @AuthorizationControl(allowedUsers={"URIResolver"})
    public Response resolvePublicLink() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResourceMethodSignature(output=URL.class, pathParams={@PathParam(value="id")}, queryParams={@QueryParam(value="version")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=400, condition="This item is not a file."), @ResponseCode(code=406, condition="Item does not exist.")})
    @GET
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Path(value="{id}/publiclink")
    public URL getPublicLink(@QueryParam(value="version") String version) {
        InnerMethodName.set((String)"getPubliclink");
        Session ses = null;
        URL toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                Node selectedNode = ses.getNodeByIdentifier(this.id);
                Item item = this.node2Item.getItem(selectedNode, Arrays.asList("hl:accounting", "hl:metadata"));
                if (!(item instanceof AbstractFileItem)) {
                    throw new InvalidCallParameters("the choosen item is not a File");
                }
                if (version != null) {
                    boolean versionFound = false;
                    VersionList versions = this.getVersions();
                    for (Version v : versions.getItemlist()) {
                        if (!v.getName().equals(version)) continue;
                        versionFound = true;
                        break;
                    }
                    if (!versionFound) {
                        throw new InvalidCallParameters("the selected file has no version " + version);
                    }
                }
                String url = version != null ? this.publicLinkHandler.getForVersionedItem(this.id, version, this.context) : this.publicLinkHandler.getForItem(this.id, this.context);
                toReturn = new URL(url);
                return toReturn;
            }
            catch (MalformedURLException | RepositoryException re) {
                log.error("jcr error getting public link", re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError(re)));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")}, formParams={@FormParam(value="publish")})
    @DocumentationExample(value="...\n\npublish=true")
    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=400, condition="This item is not a file."), @ResponseCode(code=406, condition="Item does not exist.")})
    @PUT
    @jakarta.ws.rs.Path(value="{id}/publish")
    @Produces(value={"application/json"})
    public String makeFolderPublic(@FormParam(value="publish") boolean publish) {
        InnerMethodName.set((String)("makeFolderPublic(" + publish + ")"));
        Session ses = null;
        Item folder = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node currentNode = ses.getNodeByIdentifier(this.id);
                log.trace("current node is {}", (Object)currentNode.getPath());
                folder = this.node2Item.getItem(currentNode, Excludes.ALL);
                if (!(folder instanceof FolderItem)) {
                    throw new InvalidCallParameters("item is not a folder");
                }
                currentNode.setProperty(NodeProperty.IS_PUBLIC.toString(), publish);
                ses.save();
                return this.id;
            }
            catch (RepositoryException re) {
                log.error("jcr error publishing folder", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses == null) return this.id;
                ses.logout();
                return this.id;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return this.id;
                ses.logout();
                return this.id;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=400, condition="This item is not a shared."), @ResponseCode(code=406, condition="Item does not exist.")})
    @ResourceMethodSignature(output=ItemWrapper.class, pathParams={@PathParam(value="id")}, queryParams={@QueryParam(value="exclude")})
    @GET
    @jakarta.ws.rs.Path(value="{id}/rootSharedFolder")
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getRootSharedFolder(@QueryParam(value="exclude") List<String> excludes) {
        Item sharedParent;
        block10: {
            InnerMethodName.set((String)"getRootSharedFolder");
            Session ses = null;
            sharedParent = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                Node currentNode = ses.getNodeByIdentifier(this.id);
                log.trace("current node is {}", (Object)currentNode.getPath());
                Node sharedParentNode = this.getSharedParentNode(currentNode);
                if (sharedParentNode == null) {
                    throw new InvalidCallParameters("item is not shared");
                }
                sharedParent = this.node2Item.getItem(sharedParentNode, excludes);
            }
            catch (RepositoryException re) {
                log.error("jcr error getting rootSharedFolder", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block10;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block10;
            ses.logout();
        }
        return new ItemWrapper(sharedParent);
    }

    private Node getSharedParentNode(Node node) throws RepositoryException, BackendGenericError {
        Item currentItem = this.node2Item.getItem(node, Excludes.ALL);
        if (!currentItem.isShared()) {
            return null;
        }
        Node currentNode = node;
        while (!this.node2Item.checkNodeType(currentNode, SharedFolder.class)) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=406, condition="Item does not exist.")})
    @ResourceMethodSignature(output=VersionList.class, pathParams={@PathParam(value="id")})
    @GET
    @jakarta.ws.rs.Path(value="{id}/versions")
    @Produces(value={"application/json"})
    public VersionList getVersions() {
        ArrayList<Version> versions;
        block11: {
            InnerMethodName.set((String)"getVersions");
            Session ses = null;
            versions = new ArrayList<Version>();
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                Node node = ses.getNodeByIdentifier(this.id);
                Item currentItem = this.node2Item.getItem(node, Excludes.GET_ONLY_CONTENT);
                if (!(currentItem instanceof AbstractFileItem)) {
                    throw new InvalidItemException("this item is not versioned");
                }
                List jcrVersions = this.versionHandler.getContentVersionHistory(node);
                for (javax.jcr.version.Version version : jcrVersions) {
                    boolean currentVersion = ((AbstractFileItem)currentItem).getContent().getStorageId().equals(version.getFrozenNode().getProperty(NodeProperty.STORAGE_ID.toString()).getString());
                    versions.add(new Version(version.getIdentifier(), version.getName(), version.getCreated(), currentVersion));
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error retrieving versions", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block11;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block11;
            ses.logout();
        }
        return new VersionList(versions);
    }

    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=406, condition="Item does not exist."), @ResponseCode(code=500, condition="Invalid version.")})
    @GET
    @jakarta.ws.rs.Path(value="{id}/versions/{version}/download")
    public Response downloadVersion(@PathParam(value="version") String versionName) {
        StorageUsageRecord sur;
        Response response;
        block11: {
            InnerMethodName.set((String)"downloadSpecificVersion");
            Session ses = null;
            response = null;
            sur = this.reportHandler.generateRecord(null, this.currentUser, "DOWNLOAD", null, null, null);
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                Node node = ses.getNodeByIdentifier(this.id);
                Item currentItem = this.node2Item.getItem(node, Excludes.ALL);
                if (!(currentItem instanceof AbstractFileItem)) {
                    throw new InvalidItemException("this item is not a file");
                }
                this.reportHandler.setOwner(sur, currentItem.getOwner());
                for (javax.jcr.version.Version version : this.versionHandler.getContentVersionHistory((Node)currentItem.getRelatedNode())) {
                    if (!version.getName().equals(versionName)) continue;
                    long fileSize = this.node2Item.getContentFromVersion(version).getSize();
                    this.reportHandler.setSize(sur, fileSize >= 0L ? Long.valueOf(fileSize / 1024L) : null);
                    break;
                }
                response = this.downloadHandler.downloadVersionedItem(ses, this.currentUser, (AbstractFileItem)currentItem, versionName, true);
                this.reportHandler.setSuccessResult(sur);
            }
            catch (RepositoryException re) {
                log.error("jcr error downloading version", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                response = Response.serverError().build();
                this.reportHandler.setFailureResult(sur);
                if (ses != null) {
                    ses.logout();
                }
                break block11;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    response = Response.serverError().build();
                    this.reportHandler.setFailureResult(sur);
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block11;
            ses.logout();
        }
        this.reportHandler.send(sur);
        return response;
    }

    @ResourceMethodSignature(output=void.class, pathParams={@PathParam(value="id"), @PathParam(value="version")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Item deleted."), @ResponseCode(code=400, condition="This item's version cannot be removed."), @ResponseCode(code=406, condition="Item does not exist."), @ResponseCode(code=500, condition="Invalid version.")})
    @DELETE
    @jakarta.ws.rs.Path(value="{id}/versions/{version}")
    public void deleteVersion(@PathParam(value="version") String versionName) {
        StorageUsageRecord sur;
        block13: {
            InnerMethodName.set((String)"deleteVersion");
            Session ses = null;
            sur = this.reportHandler.generateRecord(null, this.currentUser, "DELETE", null, null, null);
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node node = ses.getNodeByIdentifier(this.id);
                Item currentItem = this.node2Item.getItem(node, Excludes.GET_ONLY_CONTENT);
                if (!(currentItem instanceof AbstractFileItem)) {
                    throw new InvalidItemException("this item is not a file");
                }
                this.reportHandler.setOwner(sur, currentItem.getOwner());
                List versions = this.versionHandler.getContentVersionHistory(node);
                boolean found = false;
                for (javax.jcr.version.Version version : versions) {
                    if (!version.getName().equals(versionName)) continue;
                    long fileSize = this.node2Item.getContentFromVersion(version).getSize();
                    this.reportHandler.setSize(sur, fileSize >= 0L ? Long.valueOf(fileSize / 1024L) : null);
                    boolean currentVersion = ((AbstractFileItem)currentItem).getContent().getStorageId().equals(version.getFrozenNode().getProperty(NodeProperty.STORAGE_ID.toString()).getString());
                    if (currentVersion) {
                        throw new InvalidCallParameters("current version cannot be removed");
                    }
                    this.versionHandler.removeContentVersion(node, versionName);
                    this.accountingHandler.createVersionDeleted(currentItem.getTitle(), versionName, ses, node, this.currentUser, false);
                    ses.save();
                    found = true;
                    this.reportHandler.setSuccessResult(sur);
                    break;
                }
                if (!found) {
                    throw new InvalidItemException("the version " + versionName + " is not valid or is current version for item " + currentItem.getTitle());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error removing version", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                this.reportHandler.setFailureResult(sur);
                if (ses != null) {
                    ses.logout();
                }
                break block13;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    this.reportHandler.setFailureResult(sur);
                    break block13;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block13;
            ses.logout();
        }
        this.reportHandler.send(sur);
    }

    @ResourceMethodSignature(output=ItemList.class, pathParams={@PathParam(value="id")}, queryParams={@QueryParam(value="exclude")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=406, condition="Item does not exist.")})
    @GET
    @jakarta.ws.rs.Path(value="{id}/anchestors")
    @Produces(value={"application/json"})
    public ItemList getAnchestors(@QueryParam(value="exclude") List<String> excludes) {
        LinkedList<Item> toReturn;
        block14: {
            InnerMethodName.set((String)"getAnchestors");
            Path absolutePath = this.pathUtil.getWorkspacePath(this.currentUser);
            Session ses = null;
            toReturn = new LinkedList<Item>();
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                Node currentNode = ses.getNodeByIdentifier(this.id);
                Item currentItem = this.node2Item.getItem(currentNode, excludes);
                log.trace("current node is {}", (Object)currentNode.getPath());
                while (!currentNode.getPath().matches("/Home/[^/]{1,}/Workspace")) {
                    if (currentItem instanceof SharedFolder) {
                        NodeIterator sharedSetIterator = currentNode.getSharedSet();
                        boolean found = false;
                        while (sharedSetIterator.hasNext()) {
                            Node sharedNode = sharedSetIterator.nextNode();
                            if (!sharedNode.getPath().startsWith(absolutePath.toPath())) continue;
                            currentNode = sharedNode.getParent();
                            found = true;
                            break;
                        }
                        if (!found) break;
                        currentItem = this.node2Item.getItem(currentNode, excludes);
                    } else {
                        currentNode = currentNode.getParent();
                        currentItem = this.node2Item.getItem(currentNode, excludes);
                    }
                    log.trace("current node is {}", (Object)currentNode.getPath());
                    toReturn.add(currentItem);
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error getting anchestors", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block14;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block14;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block14;
            ses.logout();
        }
        log.trace("item list to return is empty ? {}", (Object)toReturn.isEmpty());
        return new ItemList(toReturn);
    }

    @ResourceMethodSignature(output=Response.class, pathParams={@PathParam(value="id")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=406, condition="Item does not exist.")})
    @GET
    @jakarta.ws.rs.Path(value="{id}/download")
    public Response download() {
        Response response;
        StorageUsageRecord sur;
        block12: {
            Session ses;
            block11: {
                InnerMethodName.set((String)"downloadById");
                ses = null;
                sur = this.reportHandler.generateRecord(null, this.currentUser, "DOWNLOAD", null, null, null);
                response = null;
                try {
                    ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                    Node node = ses.getNodeByIdentifier(this.id);
                    this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                    Item item = this.node2Item.getItem(node, null);
                    this.reportHandler.setOwner(sur, item.getOwner());
                    if (item instanceof AbstractFileItem) {
                        AbstractFileItem fileItem = (AbstractFileItem)item;
                        long fileSize = fileItem.getContent().getSize();
                        this.reportHandler.setSize(sur, fileSize >= 0L ? Long.valueOf(fileSize / 1024L) : null);
                        response = this.downloadHandler.downloadFileItem(ses, fileItem, this.currentUser, true);
                        this.reportHandler.setSuccessResult(sur);
                        break block11;
                    }
                    if (item instanceof FolderItem) {
                        FolderItem folderItem = (FolderItem)item;
                        FolderInfoType fit = Utils.getFolderInfo((Node)node);
                        long folderSize = fit.getSize();
                        this.reportHandler.setSize(sur, folderSize >= 0L ? Long.valueOf(folderSize / 1024L) : null);
                        response = this.downloadHandler.downloadFolderItem(ses, this.currentUser, folderItem, true);
                        this.reportHandler.setSuccessResult(sur);
                        break block11;
                    }
                    throw new InvalidItemException("item type not supported for download: " + String.valueOf(item.getClass()));
                }
                catch (RepositoryException re) {
                    log.error("jcr error download", (Throwable)re);
                    GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                    this.reportHandler.setFailureResult(sur);
                    if (ses != null) {
                        ses.logout();
                    }
                    break block12;
                }
                catch (StorageHubException she) {
                    try {
                        log.error(she.getErrorMessage(), (Throwable)she);
                        GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                        this.reportHandler.setFailureResult(sur);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (ses != null) {
                            ses.logout();
                        }
                    }
                }
            }
            if (ses == null) break block12;
            ses.logout();
        }
        this.reportHandler.send(sur);
        return response;
    }

    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")}, formParams={@FormParam(value="destinationId")})
    @DocumentationExample(value="...\n\ndestinationId=19863b4e-b33f- ... -5b6d2e0e1eee")
    @StatusCodes(value={@ResponseCode(code=200, condition="Item moved."), @ResponseCode(code=406, condition="Source or destination item does not exist."), @ResponseCode(code=409, condition="Source and destination are the same item.")})
    @PUT
    @jakarta.ws.rs.Path(value="{id}/move")
    public String move(@FormParam(value="destinationId") String destinationId) {
        StorageUsageRecord sur;
        block35: {
            InnerMethodName.set((String)"move");
            Session ses = null;
            sur = this.reportHandler.generateRecord(null, this.currentUser, "MOVE", null, null, null);
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkMoveOpsForProtectedFolders(ses, this.id);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, destinationId, true);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node nodeToMove = ses.getNodeByIdentifier(this.id);
                Node destination = ses.getNodeByIdentifier(destinationId);
                Node originalParent = nodeToMove.getParent();
                Item destinationItem = this.node2Item.getItem(destination, null);
                Item item = this.node2Item.getItem(nodeToMove, null);
                this.reportHandler.setOwner(sur, item.getOwner());
                long itemSize = 0L;
                if (item instanceof FolderItem || item instanceof SharedFolder || item instanceof VreFolder) {
                    itemSize = Utils.getFolderInfo((Node)nodeToMove).getSize();
                } else if (item instanceof AbstractFileItem) {
                    itemSize = ((AbstractFileItem)item).getContent().getSize();
                } else if (item instanceof TrashItem) {
                    TrashItem trashItem = (TrashItem)item;
                    if (trashItem.isFolder()) {
                        List children = Utils.getItemList((Node)ses.getNodeByIdentifier(item.getId()), (List)Excludes.ALL, null, (boolean)false, null);
                        if (children.size() == 1) {
                            FolderItem folderItem = (FolderItem)children.get(0);
                            itemSize = Utils.getFolderInfo((Node)((Node)folderItem.getRelatedNode())).getSize();
                        }
                    } else {
                        itemSize = trashItem.getLenght();
                    }
                }
                this.reportHandler.setSize(sur, itemSize >= 0L ? Long.valueOf(itemSize / 1024L) : null);
                if (item instanceof SharedFolder) {
                    throw new InvalidItemException("shared folder cannot be moved");
                }
                if (item instanceof FolderItem && Utils.hasSharedChildren((Node)nodeToMove)) {
                    throw new InvalidItemException("folder item with shared children cannot be moved");
                }
                if (Constants.FOLDERS_TO_EXLUDE.contains(item.getTitle()) || Constants.FOLDERS_TO_EXLUDE.contains(destinationItem.getTitle())) {
                    throw new InvalidItemException("protected folder cannot be moved");
                }
                if (!(destinationItem instanceof FolderItem)) {
                    throw new InvalidItemException("destination item is not a folder");
                }
                String nodeToMovePath = nodeToMove.getPath();
                String destinationPath = destination.getPath();
                if (destinationPath.startsWith(nodeToMovePath + "/")) {
                    throw new InvalidCallParameters("Cannot move an item into itself or its descendant");
                }
                boolean movingUpward = nodeToMovePath.startsWith(destinationPath + "/");
                boolean movingSharedItemOutside = item.isShared() && (!destinationItem.isShared() || !this.getSharedParentNode(nodeToMove).getIdentifier().equals(this.getSharedParentNode(destination).getIdentifier()));
                boolean destinationLocked = false;
                boolean nodeToMoveLocked = false;
                try {
                    ses.getWorkspace().getLockManager().lock(destinationPath, movingUpward, true, 0L, this.currentUser);
                    destinationLocked = true;
                    if (!movingUpward) {
                        ses.getWorkspace().getLockManager().lock(nodeToMovePath, true, true, 0L, this.currentUser);
                        nodeToMoveLocked = true;
                    }
                }
                catch (LockException lockException) {
                    if (destinationLocked) {
                        try {
                            ses.getWorkspace().getLockManager().unlock(destinationPath);
                        }
                        catch (RepositoryException unlockEx) {
                            log.warn("Failed to unlock destination after lock failure", (Throwable)unlockEx);
                        }
                    }
                    throw new ItemLockedException("Cannot move item, source and/or destination are busy. Please, retry later.");
                }
                try {
                    String mimeTypeForAccounting;
                    String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)destination, (String)nodeToMove.getName());
                    String newPath = String.format("%s/%s", destinationPath, uniqueName);
                    ses.move(nodeToMovePath, newPath);
                    Utils.setPropertyOnChangeNode((Node)ses.getNode(newPath), (String)this.currentUser, (ItemAction)ItemAction.MOVED);
                    String string = mimeTypeForAccounting = item instanceof AbstractFileItem ? ((AbstractFileItem)item).getContent().getMimeType() : null;
                    if (movingSharedItemOutside) {
                        this.item2Node.updateOwnerOnSubTree(nodeToMove, this.currentUser);
                    }
                    this.accountingHandler.createFolderAddObj(uniqueName, item.getClass().getSimpleName(), mimeTypeForAccounting, ses, this.currentUser, destination, false);
                    this.accountingHandler.createFolderRemoveObj(item.getTitle(), item.getClass().getSimpleName(), mimeTypeForAccounting, ses, this.currentUser, originalParent, false);
                    this.reportHandler.setSuccessResult(sur);
                    ses.save();
                }
                finally {
                    if (nodeToMoveLocked) {
                        ses.getWorkspace().getLockManager().unlock(nodeToMove.getPath());
                    }
                    if (destinationLocked) {
                        ses.getWorkspace().getLockManager().unlock(destinationPath);
                    }
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                this.reportHandler.setFailureResult(sur);
                if (ses != null) {
                    ses.logout();
                }
                break block35;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    this.reportHandler.setFailureResult(sur);
                    break block35;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block35;
            ses.logout();
        }
        this.reportHandler.send(sur);
        return this.id;
    }

    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")}, formParams={@FormParam(value="destinationId"), @FormParam(value="fileName")})
    @DocumentationExample(value="...\n\ndestinationId=19863b4e-b33f- ... -5b6d2e0e1eee&fileName=myCopy.jpg")
    @StatusCodes(value={@ResponseCode(code=200, condition="Item copied."), @ResponseCode(code=406, condition="Source or destination item does not exist.")})
    @PUT
    @jakarta.ws.rs.Path(value="{id}/copy")
    public String copy(@FormParam(value="destinationId") String destinationId, @FormParam(value="fileName") String newFileName) {
        StorageUsageRecord sur;
        String newFileIdentifier;
        block17: {
            InnerMethodName.set((String)"copy");
            Session ses = null;
            newFileIdentifier = null;
            sur = this.reportHandler.generateRecord(null, this.currentUser, "COPY", null, this.currentUser, null);
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, destinationId, true);
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                Node nodeToCopy = ses.getNodeByIdentifier(this.id);
                Node destination = ses.getNodeByIdentifier(destinationId);
                FolderItem destinationItem = (FolderItem)this.node2Item.getItem(destination, null);
                Item item = this.node2Item.getItem(nodeToCopy, Arrays.asList("hl:accounting", "hl:metadata"));
                if (item instanceof FolderItem) {
                    long folderSize = Utils.getFolderInfo((Node)nodeToCopy).getSize();
                    this.reportHandler.setSize(sur, folderSize >= 0L ? Long.valueOf(folderSize / 1024L) : null);
                    throw new InvalidItemException("folder cannot be copied");
                }
                if (item instanceof AbstractFileItem) {
                    long fileSize = ((AbstractFileItem)item).getContent().getSize();
                    this.reportHandler.setSize(sur, fileSize >= 0L ? Long.valueOf(fileSize / 1024L) : null);
                }
                try {
                    ses.getWorkspace().getLockManager().lock(destination.getPath(), false, true, 0L, this.currentUser);
                    ses.getWorkspace().getLockManager().lock(nodeToCopy.getPath(), true, true, 0L, this.currentUser);
                }
                catch (LockException lockException) {
                    throw new ItemLockedException("Cannot copy item, source and/or destination are busy. Please, retry later.");
                }
                try {
                    String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)destination, (String)newFileName);
                    String newPath = String.format("%s/%s", destination.getPath(), uniqueName);
                    ses.getWorkspace().copy(nodeToCopy.getPath(), newPath);
                    Node newNode = ses.getNode(newPath);
                    newFileIdentifier = newNode.getIdentifier();
                    Content contentToCopy = ((AbstractFileItem)item).getContent();
                    MetaInfo contentInfo = this.opMediator.copy(contentToCopy, destinationItem.getBackend(), destination.getPath(), uniqueName, this.currentUser);
                    this.item2Node.replaceContent(newNode, (AbstractFileItem)item, ItemAction.CLONED);
                    Utils.setContentFromMetaInfo((AbstractFileItem)((AbstractFileItem)item), (MetaInfo)contentInfo);
                    Utils.setPropertyOnChangeNode((Node)newNode, (String)this.currentUser, (ItemAction)ItemAction.CLONED);
                    newNode.setProperty(NodeProperty.PORTAL_LOGIN.toString(), this.currentUser);
                    newNode.setProperty(NodeProperty.IS_PUBLIC.toString(), false);
                    newNode.setProperty(NodeProperty.TITLE.toString(), uniqueName);
                    String mimeTypeForAccounting = ((AbstractFileItem)item).getContent().getMimeType();
                    this.accountingHandler.createFolderAddObj(uniqueName, item.getClass().getSimpleName(), mimeTypeForAccounting, ses, this.currentUser, destination, false);
                    this.reportHandler.setSuccessResult(sur);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToCopy.getPath());
                    ses.getWorkspace().getLockManager().unlock(destination.getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                this.reportHandler.setFailureResult(sur);
                if (ses != null) {
                    ses.logout();
                }
                break block17;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    this.reportHandler.setFailureResult(sur);
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block17;
            ses.logout();
        }
        this.reportHandler.send(sur);
        return newFileIdentifier;
    }

    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")}, formParams={@FormParam(value="newName")})
    @DocumentationExample(value="...\n\nnewName=newFileName.txt")
    @StatusCodes(value={@ResponseCode(code=200, condition="Item renamed."), @ResponseCode(code=406, condition="Item does not exist.")})
    @PUT
    @jakarta.ws.rs.Path(value="{id}/rename")
    public Response rename(@FormParam(value="newName") String newName) {
        block16: {
            InnerMethodName.set((String)"rename");
            Session ses = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkMoveOpsForProtectedFolders(ses, this.id);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node nodeToMove = ses.getNodeByIdentifier(this.id);
                Item item = this.node2Item.getItem(nodeToMove, null);
                if (item instanceof SharedFolder && this.getSharedParentNode(nodeToMove).getIdentifier() == item.getId()) {
                    throw new InvalidItemException("root shared folder name cannot be modfied");
                }
                String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)nodeToMove.getParent(), (String)newName);
                try {
                    ses.getWorkspace().getLockManager().lock(nodeToMove.getPath(), true, true, 0L, this.currentUser);
                    ses.getWorkspace().getLockManager().lock(nodeToMove.getParent().getPath(), false, true, 0L, this.currentUser);
                }
                catch (LockException lockException) {
                    throw new ItemLockedException("Cannot rename item, the resource is busy. Please, retry later.");
                }
                try {
                    String newPath = String.format("%s/%s", nodeToMove.getParent().getPath(), uniqueName);
                    nodeToMove.setProperty(NodeProperty.TITLE.toString(), uniqueName);
                    Utils.setPropertyOnChangeNode((Node)nodeToMove, (String)this.currentUser, (ItemAction)ItemAction.RENAMED);
                    ses.move(nodeToMove.getPath(), newPath);
                    this.accountingHandler.createRename(item.getTitle(), uniqueName, ses.getNode(newPath), this.currentUser, ses, false);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToMove.getPath());
                    ses.getWorkspace().getLockManager().unlock(nodeToMove.getParent().getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block16;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block16;
            ses.logout();
        }
        return Response.ok((Object)this.id).build();
    }

    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")})
    @DocumentationExample(value="...\n\ntrue")
    @StatusCodes(value={@ResponseCode(code=200, condition="Item visibility set."), @ResponseCode(code=400, condition="Unable to parse request body."), @ResponseCode(code=406, condition="Item does not exist.")})
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @jakarta.ws.rs.Path(value="/{id}/hidden")
    public Response setItemAsHidden(Boolean hidden) {
        block15: {
            InnerMethodName.set((String)"setHidden");
            Session ses = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node nodeToUpdate = ses.getNodeByIdentifier(this.id);
                try {
                    ses.getWorkspace().getLockManager().lock(nodeToUpdate.getPath(), false, true, 0L, this.currentUser);
                }
                catch (LockException lockException) {
                    throw new ItemLockedException("Cannot " + (hidden != false ? "hide" : "unhide") + " item, the resource is busy. Please, retry later.");
                }
                try {
                    this.item2Node.updateHidden(nodeToUpdate, hidden, this.currentUser);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToUpdate.getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block15;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block15;
            ses.logout();
        }
        return Response.ok((Object)this.id).build();
    }

    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")})
    @DocumentationExample(value="...\n\nThis is a sample description")
    @StatusCodes(value={@ResponseCode(code=200, condition="Item description set."), @ResponseCode(code=400, condition="Unable to parse request body."), @ResponseCode(code=406, condition="Item does not exist.")})
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @jakarta.ws.rs.Path(value="/{id}/description")
    public Response setDescription(String description) {
        block15: {
            InnerMethodName.set((String)"setDescription");
            Session ses = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node nodeToUpdate = ses.getNodeByIdentifier(this.id);
                try {
                    ses.getWorkspace().getLockManager().lock(nodeToUpdate.getPath(), false, true, 0L, this.currentUser);
                }
                catch (LockException lockException) {
                    throw new ItemLockedException("Cannot update description, the resource is busy. Please, retry later.");
                }
                try {
                    this.item2Node.updateDescription(nodeToUpdate, description, this.currentUser);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToUpdate.getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block15;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block15;
            ses.logout();
        }
        return Response.ok((Object)this.id).build();
    }

    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")})
    @DocumentationExample(value="...\n\n{\n    \"map\": {\n        \"meta1\": \"value1\",\n        \"meta2\": \"value2\"\n    }\n}")
    @StatusCodes(value={@ResponseCode(code=200, condition="Item metadata set."), @ResponseCode(code=400, condition="Unable to parse request body."), @ResponseCode(code=406, condition="Item does not exist.")})
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @jakarta.ws.rs.Path(value="/{id}/metadata")
    public Response setMetadata(Metadata metadata) {
        block15: {
            InnerMethodName.set((String)"updateMetadata");
            Session ses = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node nodeToUpdate = ses.getNodeByIdentifier(this.id);
                try {
                    ses.getWorkspace().getLockManager().lock(nodeToUpdate.getPath(), false, true, 0L, this.currentUser);
                }
                catch (LockException lockException) {
                    throw new ItemLockedException("Cannot update metadata, the resource is busy. Please, retry later.");
                }
                try {
                    this.item2Node.updateMetadataNode(nodeToUpdate, metadata.getMap(), this.currentUser);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToUpdate.getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block15;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block15;
            ses.logout();
        }
        return Response.ok((Object)this.id).build();
    }

    /*
     * Exception decompiling
     */
    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")}, queryParams={@QueryParam(value="force")})
    @DELETE
    @StatusCodes(value={@ResponseCode(code=200, condition="Item deleted."), @ResponseCode(code=406, condition="Unable to find this item."), @ResponseCode(code=500, condition="Unable to delete this item.")})
    @jakarta.ws.rs.Path(value="{id}")
    public Response deleteItem(@QueryParam(value="force") boolean force) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Item found."), @ResponseCode(code=400, condition="This item is not a folder."), @ResponseCode(code=406, condition="Unable to find this folder.")})
    @jakarta.ws.rs.Path(value="{id}/info")
    @GET
    @Produces(value={"application/json"})
    public FolderInfoType getFolderInfo() {
        InnerMethodName.set((String)"getFolderInfo");
        Session ses = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            Node node = ses.getNodeByIdentifier(this.id);
            Item item = this.node2Item.getItem(node, Excludes.ALL);
            if (!(item instanceof FolderItem)) {
                throw new InvalidCallParameters("the item is not a folder");
            }
            FolderInfoType folderInfoType = Utils.getFolderInfo((Node)node);
            return folderInfoType;
        }
        catch (RepositoryException re) {
            log.error("error getting workspace total size", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new FolderInfoType(0L, 0L);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$access$storagehub$types$LinkType() {
        if ($SWITCH_TABLE$org$gcube$data$access$storagehub$types$LinkType != null) {
            return $SWITCH_TABLE$org$gcube$data$access$storagehub$types$LinkType;
        }
        int[] nArray = new int[LinkType.values().length];
        try {
            nArray[LinkType.STANDARD.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[LinkType.VERSIONED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[LinkType.VOLATILE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$data$access$storagehub$types$LinkType = nArray;
        return nArray;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ItemsManager.java", ItemsManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resolvePublicLink", "org.gcube.data.access.storagehub.services.ItemsManager", "", "", "", "jakarta.ws.rs.core.Response"), 595);
    }
}

