/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers.plugins;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.storagehub.model.exceptions.PluginNotFoundException;
import org.gcube.common.storagehub.model.items.nodes.PayloadBackend;
import org.gcube.common.storagehub.model.storages.StorageBackendFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StorageBackendHandler {
    private static Logger log = LoggerFactory.getLogger(StorageBackendHandler.class);
    @Inject
    Instance<StorageBackendFactory> factories;
    Map<String, StorageBackendFactory> storagebackendMap = new HashMap();

    public static PayloadBackend getDefaultPayloadForFolder() {
        return new PayloadBackend("default-gcube-s3", null);
    }

    @PostConstruct
    void init() {
        if (this.factories != null) {
            for (StorageBackendFactory connector : this.factories) {
                if (this.storagebackendMap.containsKey(connector.getName())) {
                    log.error("multiple storage backend with the same name");
                    throw new RuntimeException("multiple storage backend with the same name");
                }
                this.storagebackendMap.put(connector.getName(), connector);
            }
        } else {
            throw new RuntimeException("storage backend implementation not found");
        }
    }

    public StorageBackendFactory get(PayloadBackend payload) throws PluginNotFoundException {
        if (payload == null || !this.storagebackendMap.containsKey(payload.getStorageName())) {
            throw new PluginNotFoundException(String.format("implementation for storage %s not found", payload.getStorageName()));
        }
        return (StorageBackendFactory)this.storagebackendMap.get(payload.getStorageName());
    }

    public StorageBackendFactory get(String storageName) throws PluginNotFoundException {
        return (StorageBackendFactory)this.storagebackendMap.get(storageName);
    }

    public Collection<StorageBackendFactory> getAllImplementations() {
        return this.storagebackendMap.values();
    }
}

