/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers.vres;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventJournal;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VREQueryRetriever
implements Callable<List<Item>> {
    private static final Logger logger = LoggerFactory.getLogger(VREQueryRetriever.class);
    private static final int CACHE_DIMENSION = 50;
    private Repository repository;
    private Credentials credentials;
    private Item vreFolder;
    Map<String, Long> cachedMap = new HashMap(50);
    long lastTimestamp = 0L;
    long doTime = 0L;
    boolean underRedo = false;
    Node2ItemConverter node2Item;
    private static int TIME_MEASURE = 12;
    private static int VALUE_TIME_BEFORE = 30;

    public VREQueryRetriever(Repository repository, Credentials credentials, Node2ItemConverter node2Item, Item vreFolder) {
        this.repository = repository;
        this.credentials = credentials;
        this.vreFolder = vreFolder;
        this.node2Item = node2Item;
    }

    @Override
    public List<Item> call() {
        Session ses = null;
        try {
            ses = this.repository.login(this.credentials);
            Calendar now = Calendar.getInstance();
            now.add(TIME_MEASURE, -1 * Math.abs(VALUE_TIME_BEFORE));
            if (this.doTime > now.getTimeInMillis() || this.underRedo) {
                logger.debug("executing recents task for {} (cahced result)", (Object)this.vreFolder.getTitle());
                List list = this.correctValues(ses, this.cachedMap);
                return list;
            }
            logger.debug("executing recents task for {} (redoing it)", (Object)this.vreFolder.getTitle());
            List toReturn = this.redo(ses);
            this.doTime = System.currentTimeMillis();
            List list = toReturn;
            return list;
        }
        catch (Exception e) {
            logger.error("error preparing recents for folder {}", (Object)this.vreFolder.getTitle(), (Object)e);
            List<Item> list = Collections.emptyList();
            return list;
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
            logger.debug("recents task finished");
        }
    }

    public synchronized List<Item> redo(Session ses) {
        this.underRedo = true;
        try {
            HashMap tempCachedMap = new HashMap(this.cachedMap);
            if (this.cachedMap.isEmpty()) {
                this.init(ses, tempCachedMap);
            } else {
                logger.debug("redoing recents for {}", (Object)this.vreFolder.getTitle());
                this.update(ses, tempCachedMap);
            }
            this.cachedMap = tempCachedMap;
            List list = this.correctValues(ses, tempCachedMap);
            return list;
        }
        finally {
            this.underRedo = false;
        }
    }

    private List<Item> correctValues(Session ses, Map<String, Long> tempCachedMap) {
        List cachedIds;
        logger.debug("preparing returning values for {}", (Object)this.vreFolder.getTitle());
        long start = System.currentTimeMillis();
        LinkedList<Map.Entry<String, Long>> list = new LinkedList<Map.Entry<String, Long>>(tempCachedMap.entrySet());
        list.sort((c1, c2) -> ((Long)c1.getValue()).compareTo((Long)c2.getValue()) * -1);
        if (list.size() > 50) {
            int index = 49;
            while (index < list.size()) {
                tempCachedMap.remove(((Map.Entry)list.get(index)).getKey());
                ++index;
            }
        }
        if ((cachedIds = list.stream().map(m -> (String)m.getKey()).collect(Collectors.toList())).size() > 10) {
            cachedIds = cachedIds.subList(0, 10);
        }
        ArrayList<Item> result = new ArrayList<Item>(10);
        for (String id : cachedIds) {
            try {
                Item item = this.node2Item.getItem(id, ses, Excludes.EXCLUDE_ACCOUNTING);
                if (item != null) {
                    result.add(item);
                    continue;
                }
                logger.warn("item with id {} is null", (Object)id);
            }
            catch (RepositoryException | BackendGenericError throwable) {}
        }
        logger.debug("returning values prepared in {} for {}", (Object)(System.currentTimeMillis() - start), (Object)this.vreFolder.getTitle());
        return result;
    }

    private void insertItemInTheRightPlace(Item item, Map<String, Long> tempCachedMap) {
        long lastModifiedTime = item.getLastModificationTime().getTimeInMillis();
        if (tempCachedMap.size() < 50 || lastModifiedTime > Collections.min(tempCachedMap.values())) {
            tempCachedMap.put(item.getId(), lastModifiedTime);
        }
    }

    private void init(Session ses, Map<String, Long> tempCachedMap) {
        try {
            long start = System.currentTimeMillis();
            this.lastTimestamp = System.currentTimeMillis();
            Node vreFolderNode = ses.getNodeByIdentifier(this.vreFolder.getId());
            logger.debug("starting visiting children for {}", (Object)this.vreFolder.getTitle());
            this.visitChildren(vreFolderNode, tempCachedMap);
            logger.debug("initializing recents for {} took {}", (Object)this.vreFolder.getTitle(), (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("error querying vre {}", (Object)this.vreFolder.getTitle(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private void update(Session ses, Map<String, Long> tempCachedMap) {
        try {
            long timestampToUse = this.lastTimestamp;
            this.lastTimestamp = System.currentTimeMillis();
            long start = System.currentTimeMillis();
            String[] types = new String[]{"nthl:workspaceLeafItem", "nthl:workspaceItem"};
            EventJournal journalChanged = ses.getWorkspace().getObservationManager().getEventJournal(51, this.vreFolder.getPath(), true, null, types);
            journalChanged.skipTo(timestampToUse);
            logger.debug("getting the journal took {}", (Object)(System.currentTimeMillis() - start));
            int events = 0;
            block10: while (journalChanged.hasNext()) {
                ++events;
                Event event = journalChanged.nextEvent();
                try {
                    switch (event.getType()) {
                        case 1: {
                            Node nodeAdded;
                            if (!ses.nodeExists(event.getPath()) || !(nodeAdded = ses.getNode(event.getPath())).isNodeType("nthl:workspaceLeafItem")) continue block10;
                            logger.debug("node added event received with name {}", (Object)nodeAdded.getName());
                            Item item = this.node2Item.getItem(nodeAdded, Excludes.ALL);
                            if (tempCachedMap.get(event.getIdentifier()) != null) {
                                tempCachedMap.remove(event.getIdentifier());
                            }
                            if (item.isHidden()) continue block10;
                            this.insertItemInTheRightPlace(item, tempCachedMap);
                            break;
                        }
                        case 16: {
                            Property property;
                            if (!ses.propertyExists(event.getPath()) || !(property = ses.getProperty(event.getPath())).getName().equalsIgnoreCase("jcr:lastModified")) continue block10;
                            logger.debug("event property changed on {} with value {} and parent {}", new Object[]{property.getName(), property.getValue().getString(), property.getParent().getPath()});
                            String identifier = property.getParent().getIdentifier();
                            tempCachedMap.remove(identifier);
                            Item item = this.node2Item.getItem(property.getParent(), Excludes.ALL);
                            if (item.isHidden()) continue block10;
                            this.insertItemInTheRightPlace(item, tempCachedMap);
                            break;
                        }
                        case 2: {
                            logger.trace("node removed event received with type {}", (Object)event.getIdentifier());
                            if (tempCachedMap.get(event.getIdentifier()) == null || tempCachedMap.get(event.getIdentifier()) >= event.getDate()) continue block10;
                            tempCachedMap.remove(event.getIdentifier());
                            break;
                        }
                        case 32: {
                            Node nodeMoved = ses.getNode(event.getPath());
                            logger.trace("node moved event received with type {}", (Object)nodeMoved.getPrimaryNodeType());
                            if (!nodeMoved.isNodeType("nthl:workspaceLeafItem")) continue block10;
                            logger.debug("event node moved on {} with path {}", (Object)nodeMoved.getName(), (Object)nodeMoved.getPath());
                            String identifier = nodeMoved.getIdentifier();
                            String nodePath = ses.getNode(identifier).getPath();
                            if (tempCachedMap.get(event.getIdentifier()) == null || nodePath.startsWith(this.vreFolder.getPath())) continue block10;
                            tempCachedMap.remove(event.getIdentifier());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("error handling event {}", (Object)event.getType(), (Object)e);
                }
            }
            logger.trace("retrieving event took {} with {} events", (Object)(System.currentTimeMillis() - start), (Object)events);
        }
        catch (Exception e) {
            logger.error("error getting events for vre {}", (Object)this.vreFolder.getTitle(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private void visitChildren(Node node, Map<String, Long> tempCachedMap) throws Exception {
        NodeIterator nodeIt = node.getNodes();
        while (nodeIt.hasNext()) {
            Node child = nodeIt.nextNode();
            Item item = this.node2Item.getItem(child, Excludes.ALL);
            if (item == null || item.isHidden()) continue;
            if (item instanceof FolderItem) {
                this.visitChildren(child, tempCachedMap);
                continue;
            }
            if (!(item instanceof AbstractFileItem)) continue;
            this.insertItemInTheRightPlace(item, tempCachedMap);
        }
    }
}

