/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.storage.backend.impl;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Singleton;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.items.nodes.PayloadBackend;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.gcube.common.storagehub.model.storages.StorageBackendFactory;
import org.gcube.data.access.storagehub.storage.backend.impl.S3Backend;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;

@Singleton
public class GcubeS3StorageBackendFactory
implements StorageBackendFactory {
    private static final String PROP_PREFIX = "default.";
    private Metadata baseParameters;

    @PostConstruct
    public void init() {
        this.baseParameters = this.getParameters();
    }

    public String getName() {
        return "gcube-s3";
    }

    public boolean isSystemStorage() {
        return true;
    }

    public StorageBackend create(PayloadBackend payloadConfiguration) throws InvalidCallParameters {
        if (payloadConfiguration.getParameters().isEmpty()) {
            throw new InvalidCallParameters(this.getName() + ": null or empty parameter not allowed");
        }
        String bucketName = (String)payloadConfiguration.getParameters().get("bucketName");
        if (bucketName == null || bucketName.isBlank()) {
            throw new InvalidCallParameters(this.getName() + ": 'bucketName' cannot be blank or empty");
        }
        Metadata metadata = new Metadata(new HashMap(this.baseParameters.getMap()));
        metadata.getMap().putAll(payloadConfiguration.getParameters());
        S3Backend backend = new S3Backend(new PayloadBackend(this.getName(), metadata), String2 -> UUID.randomUUID().toString());
        backend.setPayloadConfiguration(new PayloadBackend(this.getName(), new Metadata(payloadConfiguration.getParameters())));
        return backend;
    }

    private Metadata getParameters() {
        ApplicationContext context = ContextProvider.get();
        String folderPath = context.appSpecificConfigurationFolder().toString();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream input = new FileInputStream(Paths.get(folderPath, "storage-settings.properties").toFile());){
                Properties prop = new Properties();
                prop.load(input);
                HashMap params = new HashMap();
                prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    if (k.toString().startsWith(PROP_PREFIX)) {
                        params.put(k.toString().replace(PROP_PREFIX, ""), v);
                    }
                }));
                return new Metadata(params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("error reading property file", ex);
        }
    }
}

