/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.storagehub.model.exporter.DumpData;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.handlers.DataHandler;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageHubApplicationManager
implements ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(StorageHubApplicationManager.class);
    private boolean alreadyShutDown = false;
    private boolean alreadyInit = false;
    private StoragehubRepository repository = StoragehubRepository.repository;

    public synchronized void onInit() {
        block12: {
            logger.info("onInit Called on storagehub");
            try {
                block13: {
                    if (this.alreadyInit) break block12;
                    logger.info("jackrabbit initialization started");
                    this.repository.initContainerAtFirstStart();
                    DataHandler dh = new DataHandler();
                    Path shubSpecificConf = ContextProvider.get().appSpecificConfigurationFolder();
                    Path importPath = Paths.get(shubSpecificConf.toString(), "import");
                    Path mainFileImportPath = Paths.get(importPath.toString(), "data.json");
                    if (importPath.toFile().exists() && mainFileImportPath.toFile().exists()) {
                        JackrabbitSession session = null;
                        try {
                            ObjectMapper mapper = new ObjectMapper();
                            DumpData data = (DumpData)mapper.readValue(mainFileImportPath.toFile(), DumpData.class);
                            session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                            dh.importData(session, data);
                            session.save();
                        }
                        catch (RepositoryException e) {
                            logger.error("error importing data", (Throwable)e);
                            if (session != null) {
                                session.logout();
                            }
                            break block13;
                        }
                        catch (IOException je) {
                            try {
                                logger.error("error parsing json data, invalid schema file", (Throwable)je);
                                break block13;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (session != null) {
                                    session.logout();
                                }
                            }
                        }
                        if (session == null) break block13;
                        session.logout();
                    }
                }
                this.alreadyInit = true;
            }
            catch (Throwable e) {
                logger.error("unexpected error initiliazing storagehub", e);
            }
        }
    }

    public synchronized void onShutdown() {
        if (!this.alreadyShutDown) {
            try {
                logger.info("jackrabbit is shutting down");
                this.repository.shutdown();
                this.alreadyShutDown = true;
            }
            catch (Exception e) {
                logger.warn("the database was not shutdown properly", (Throwable)e);
            }
        }
    }
}

