/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFileStreamingOutput
implements StreamingOutput {
    private static final Logger log = LoggerFactory.getLogger(SingleFileStreamingOutput.class);
    InputStream streamToWrite;

    public SingleFileStreamingOutput(InputStream streamToWrite) {
        this.streamToWrite = streamToWrite;
    }

    public void write(OutputStream outputStream) throws IOException, WebApplicationException {
        log.debug("writing StreamOutput");
        this.copy(this.streamToWrite, outputStream);
        log.debug("StreamOutput written");
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[2048];
        int readcount = 0;
        while ((readcount = in.read(buffer)) != -1) {
            out.write(buffer, 0, readcount);
        }
    }
}

