/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.RecursiveTask;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.NodeChildrenFilterIterator;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.predicates.ItemTypePredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTask
extends RecursiveTask<List<Item>> {
    private static final Logger logger = LoggerFactory.getLogger(SearchTask.class);
    private final String user;
    private final AuthorizationChecker authChecker;
    private final Node parentNode;
    private final List<String> excludes;
    private final Range range;
    private final boolean showHidden;
    private final boolean excludeTrashed;
    private final ItemTypePredicate itemTypePredicate;
    private final Pattern pattern;
    private final Node2ItemConverter node2ItemConverter;
    private final Session session;

    public SearchTask(String user, AuthorizationChecker authChecker, Node parentNode, List<String> excludes, Range range, boolean showHidden, boolean excludeTrashed, ItemTypePredicate itemTypePredicate, Pattern pattern, Node2ItemConverter node2ItemConverter, Session session) {
        this.user = user;
        this.authChecker = authChecker;
        this.parentNode = parentNode;
        this.excludes = excludes;
        this.range = range;
        this.showHidden = showHidden;
        this.excludeTrashed = excludeTrashed;
        this.itemTypePredicate = itemTypePredicate;
        this.pattern = pattern;
        this.node2ItemConverter = node2ItemConverter;
        this.session = session;
    }

    /*
     * Unable to fully structure code
     */
    protected List<Item> compute() {
        subtasks = null;
        returnList = null;
        iterator = null;
        try {
            iterator = new NodeChildrenFilterIterator(this.parentNode);
            if (true) ** GOTO lbl36
        }
        catch (BackendGenericError e) {
            SearchTask.logger.debug(e.getMessage());
            return returnList;
        }
        do {
            node = iterator.next();
            try {
                if (!node.hasProperty(NodeProperty.TITLE.toString())) continue;
                nodeTitle = node.getProperty(NodeProperty.TITLE.toString()).getString();
                SearchTask.logger.trace("[SEARCH] evaluating node {} ", (Object)nodeTitle);
                minItem = this.node2ItemConverter.getItem(node, Excludes.ALL);
                if (minItem instanceof FolderItem) {
                    this.authChecker.checkReadAuthorizationControl(this.session, this.user, node.getIdentifier());
                    if (subtasks == null) {
                        subtasks = new LinkedList<SearchTask>();
                    }
                    subTask = new SearchTask(this.user, this.authChecker, node, this.excludes, this.range, this.showHidden, this.excludeTrashed, this.itemTypePredicate, this.pattern, this.node2ItemConverter, this.session);
                    subTask.fork();
                    subtasks.add(subTask);
                }
                if (!this.pattern.matcher(nodeTitle).find() || Utils.isToExclude((Node)node, (boolean)this.showHidden) || minItem == null || minItem.isTrashed() && this.excludeTrashed) continue;
                if (returnList == null) {
                    returnList = new LinkedList<E>();
                }
                item = this.node2ItemConverter.getFilteredItem(node, this.excludes, this.itemTypePredicate);
                returnList.add(item);
                SearchTask.logger.trace("[SEARCH] added node {}", (Object)nodeTitle);
            }
            catch (RepositoryException | BackendGenericError | UserNotAuthorizedException e) {
                SearchTask.logger.debug(e.getMessage());
            }
lbl36:
            // 5 sources

        } while (iterator.hasNext());
        if (subtasks != null) {
            for (SearchTask subtask : subtasks) {
                subtaskResult = (List)subtask.join();
                if (subtaskResult == null) continue;
                if (returnList == null) {
                    returnList = new LinkedList<Item>();
                }
                returnList.addAll(subtaskResult);
            }
        }
        return returnList;
    }
}

