/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers.content;

import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.gcube.common.storagehub.model.annotations.MimeTypeHandler;
import org.gcube.data.access.storagehub.handlers.content.ContentHandler;
import org.gcube.data.access.storagehub.handlers.content.GenericFileHandler;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ContentHandlerFactory {
    private static Logger logger = LoggerFactory.getLogger(ContentHandlerFactory.class);
    private Reflections reflection = new Reflections(new Object[0]);
    private static HashMap<String, Class<? extends ContentHandler>> handlerMap = new HashMap();
    private Class<? extends ContentHandler> defaultHandler = GenericFileHandler.class;

    public ContentHandlerFactory() {
        Set classesAnnotated = this.reflection.getTypesAnnotatedWith(MimeTypeHandler.class);
        for (Class clazz : classesAnnotated) {
            if (!ContentHandler.class.isAssignableFrom(clazz)) continue;
            logger.debug("searching for mimetypes {} with values {}", (Object)clazz.getName(), (Object)Arrays.toString(clazz.getAnnotation(MimeTypeHandler.class).value()));
            String[] stringArray = clazz.getAnnotation(MimeTypeHandler.class).value();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                logger.debug("value for class {} is {}", (Object)clazz.getName(), (Object)value);
                handlerMap.put(value, clazz);
                ++n2;
            }
        }
    }

    public ContentHandler create(String mimetype) throws Exception {
        Class handlerClass = (Class)handlerMap.get(mimetype);
        if (handlerClass != null) {
            return (ContentHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return (ContentHandler)this.defaultHandler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

