/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services.admin;

import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceMethodSignature;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import javax.jcr.Credentials;
import javax.jcr.Node;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gcube.common.authorization.control.AuthorizationAspect;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.DataHandler;
import org.gcube.data.access.storagehub.handlers.items.ItemHandler;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;
import org.gcube.data.access.storagehub.scripting.AbstractScript;
import org.gcube.data.access.storagehub.scripting.ScriptUtil;
import org.gcube.data.access.storagehub.services.admin.ScriptManager;
import org.gcube.data.access.storagehub.services.admin.ScriptStatus;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@jakarta.ws.rs.Path(value="admin/script")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class ScriptManager {
    private static Logger log;
    private final StoragehubRepository repository = StoragehubRepository.repository;
    @Inject
    AccountingHandler accountingHandler;
    @Inject
    ScriptUtil scriptUtil;
    @Inject
    ItemHandler itemHandler;
    @Inject
    DataHandler dataHandler;
    @Inject
    PathUtil pathUtil;
    protected static HashMap<String, ScriptStatus> scriptStatusMap;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        ScriptManager.ajc$preClinit();
        log = LoggerFactory.getLogger(ScriptManager.class);
        scriptStatusMap = new HashMap();
    }

    @ResourceMethodSignature(output=ScriptStatus.class, formParams={@FormParam(value="name"), @FormParam(value="asynch"), @FormParam(value="writeResult"), @FormParam(value="destinationFolderId"), @FormParam(value="file")})
    @DocumentationExample(value="...\n\n--------boundaryString\nContent-Disposition: form-data; name=\"file\"; filename=\"MoveFiles.class\"; size=171018;\nContent-Type: application/octet-stream\n\n(binary data)\n--------boundaryString\nContent-Disposition: form-data; name=\"name\"\n\nMoveFile\n--------boundaryString\nContent-Disposition: form-data; name=\"async\"\n\nfalse\n--------boundaryString\nContent-Disposition: form-data; name=\"writeResult\"\n\ntrue\n--------boundaryString\nContent-Disposition: form-data; name=\"destinationFolderId=\"\n\n5f4b3b4e-4b3b- ... -4b3b4e4b3b4e\n--------boundaryString--")
    @POST
    @jakarta.ws.rs.Path(value="execute")
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"})
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Script correctly loaded."), @ResponseCode(code=403, condition="You're not allowed to run scripts."), @ResponseCode(code=500, condition="Error loading the script.")})
    public ScriptStatus run(@FormDataParam(value="name") String name, @FormDataParam(value="asynch") @DefaultValue(value="false") Boolean asynch, @FormDataParam(value="writeResult") @DefaultValue(value="false") Boolean writeResult, @FormDataParam(value="destinationFolderId") String destinationFolderId, @FormDataParam(value="file") InputStream file, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        String string = name;
        Boolean bl = asynch;
        Boolean bl2 = writeResult;
        String string2 = destinationFolderId;
        InputStream inputStream = file;
        FormDataContentDisposition formDataContentDisposition = fileDetail;
        Object[] objectArray = new Object[]{string, bl, bl2, string2, inputStream, formDataContentDisposition};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        AuthorizationAspect.aspectOf().before(joinPoint);
        try {
            InnerMethodName.set((String)"executeScript");
            ScriptClassLoader scriptClassLoader = new ScriptClassLoader(this, Thread.currentThread().getContextClassLoader());
            Class scriptClass = this.uploadClass(file, scriptClassLoader, fileDetail.getFileName().replace(".class", ""));
            return this.internalRun(scriptClass, name, destinationFolderId, asynch.booleanValue(), writeResult.booleanValue());
        }
        catch (Throwable e) {
            log.error("error executing script {}", (Object)name, (Object)e);
            throw new WebApplicationException("error loading class", e);
        }
    }

    @ResourceMethodSignature(output=ScriptStatus.class, pathParams={@PathParam(value="id")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Script status retrieved."), @ResponseCode(code=403, condition="You're not allowed to inquire script status."), @ResponseCode(code=404, condition="Script not found.")})
    @GET
    @jakarta.ws.rs.Path(value="{id}/status")
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"})
    @Produces(value={"application/json"})
    public ScriptStatus getStatus(@PathParam(value="id") String runningId) {
        String string = runningId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.set((String)"getScriptStatus");
        if (!scriptStatusMap.containsKey(runningId)) {
            log.error("script with id {} not found", (Object)runningId);
            throw new WebApplicationException("id " + runningId + " not found", 404);
        }
        ScriptStatus status = (ScriptStatus)scriptStatusMap.get(runningId);
        if (status.getStatus() != ScriptStatus.Status.Running) {
            scriptStatusMap.remove(runningId);
        }
        return status;
    }

    @StatusCodes(value={@ResponseCode(code=200, condition="Script status retrieved."), @ResponseCode(code=403, condition="You're not allowed to inquire script status."), @ResponseCode(code=404, condition="Script not found.")})
    @GET
    @jakarta.ws.rs.Path(value="export")
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"})
    @Produces(value={"application/json"})
    public ScriptStatus export() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.set((String)"export");
        try {
            String runningId = UUID.randomUUID().toString();
            ApplicationContext appContext = ContextProvider.get();
            String serverHost = appContext.container().configuration().hostname();
            ScriptStatus status = new ScriptStatus(runningId, null, serverHost);
            scriptStatusMap.put(runningId, status);
            1 execution = new /* Unavailable Anonymous Inner Class!! */;
            new Thread((Runnable)execution).start();
            return status;
        }
        catch (Exception e) {
            throw new WebApplicationException("error starting export", (Throwable)e);
        }
    }

    private Class<?> uploadClass(InputStream stream, ScriptClassLoader classLoader, String name) throws Throwable {
        Throwable throwable = null;
        Object var5_6 = null;
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int nRead;
            byte[] data = new byte[1024];
            while ((nRead = stream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] byteArray = buffer.toByteArray();
            return classLoader.findClass(name, byteArray);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ScriptStatus internalRun(Class<?> clazz, String name, String destinationFolderId, boolean asynch, boolean writeResult) throws Throwable {
        String login = SecretManagerProvider.get().getOwner().getId();
        log.info("script {} called by {}", (Object)clazz.getSimpleName(), (Object)login);
        String resultPath = null;
        Node parentNode = null;
        if (writeResult) {
            JackrabbitSession ses = null;
            try {
                ses = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                String parentId = destinationFolderId != null ? destinationFolderId : ses.getNode(this.pathUtil.getWorkspacePath(login).toPath()).getIdentifier();
                parentNode = ses.getNodeByIdentifier(parentId);
                resultPath = Paths.append((Path)Paths.getPath((String)parentNode.getPath()), (String)name).toPath();
            }
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (AbstractScript.class.isAssignableFrom(clazz)) {
            AbstractScript scriptInstance = (AbstractScript)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ApplicationContext appContext = ContextProvider.get();
            String serverHost = appContext.container().configuration().hostname();
            String runningId = UUID.randomUUID().toString();
            ScriptStatus status = new ScriptStatus(runningId, resultPath, serverHost);
            RealRun realRun = new RealRun(this, scriptInstance, login, parentNode, name, writeResult, status);
            if (asynch) {
                scriptStatusMap.put(runningId, status);
                new Thread(AuthorizedTasks.bind((Runnable)realRun)).start();
                return status;
            }
            realRun.run();
            return status;
        }
        throw new Exception("class " + clazz.getSimpleName() + " not implements AbstractScript");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ScriptManager.java", ScriptManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.gcube.data.access.storagehub.services.admin.ScriptManager", "java.lang.String:java.lang.Boolean:java.lang.Boolean:java.lang.String:java.io.InputStream:org.glassfish.jersey.media.multipart.FormDataContentDisposition", "name:asynch:writeResult:destinationFolderId:file:fileDetail", "", "org.gcube.data.access.storagehub.services.admin.ScriptStatus"), 141);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getStatus", "org.gcube.data.access.storagehub.services.admin.ScriptManager", "java.lang.String", "runningId", "", "org.gcube.data.access.storagehub.services.admin.ScriptStatus"), 175);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "export", "org.gcube.data.access.storagehub.services.admin.ScriptManager", "", "", "", "org.gcube.data.access.storagehub.services.admin.ScriptStatus"), 203);
    }
}

