/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import jakarta.inject.Singleton;
import jakarta.servlet.ServletContext;
import java.util.Base64;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.secrets.Secret;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.data.access.storagehub.handlers.PublicLinkHandler;
import org.gcube.data.access.storagehub.types.PublicLink;
import org.gcube.smartgears.ContextProvider;

@Singleton
public class PublicLinkHandler {
    public String getForItem(String itemId, ServletContext context) throws BackendGenericError {
        return this.getUrl(itemId, "E_", context);
    }

    public String getForVersionedItem(String itemId, String version, ServletContext context) throws BackendGenericError {
        return this.getUrl(String.format("%s%s%s", itemId, "_v", version), "E_", context);
    }

    public String getForVolatile(String fileId, String storageName, ServletContext context) throws BackendGenericError {
        return this.getUrl(String.format("%s_%s", fileId, storageName), "VLT_", context);
    }

    public PublicLink resolveEnchriptedId(String enchriptedId) throws StorageHubException {
        String complexId = enchriptedId;
        boolean isVolatile = false;
        if (enchriptedId.startsWith("E_") || enchriptedId.startsWith("VLT_")) {
            String enchriptedValue = enchriptedId.startsWith("E_") ? "E_" : "VLT_";
            isVolatile = enchriptedId.startsWith("VLT_");
            try {
                String infraContext = String.format("/%s", ContextProvider.get().container().configuration().infrastructure());
                Secret infraSecret = ContextProvider.get().container().authorizationProvider().getSecretForContext(infraContext);
                complexId = (String)AuthorizedTasks.executeSafely(() -> StringEncrypter.getEncrypter().decrypt(new String(Base64.getUrlDecoder().decode(enchriptedId.replace(enchriptedValue, "")))), (Secret)infraSecret);
            }
            catch (Throwable e) {
                throw new BackendGenericError("invalid public url", e);
            }
        }
        if (isVolatile) {
            String[] volatileIdSplit = complexId.split("_");
            return new VolatilePublicLink(volatileIdSplit[0], volatileIdSplit[1]);
        }
        if (complexId.contains("_v")) {
            String[] split = complexId.split("_v");
            String itemId = split[0];
            String versionName = split[1];
            return new ItemPublicLink(itemId, versionName);
        }
        return new ItemPublicLink(complexId);
    }

    private String getUrl(String toEnchript, String prefix, ServletContext context) throws BackendGenericError {
        String infraContext = String.format("/%s", ContextProvider.get().container().configuration().infrastructure());
        Secret infraSecret = ContextProvider.get().container().authorizationProvider().getSecretForContext(infraContext);
        try {
            String enchriptedQueryString = (String)AuthorizedTasks.executeSafely(() -> StringEncrypter.getEncrypter().encrypt(toEnchript), (Secret)infraSecret);
            String basepath = context.getInitParameter("resolver-basepath");
            String filePublicUrl = String.format("%s/%s%s", basepath, prefix, Base64.getUrlEncoder().encodeToString(enchriptedQueryString.getBytes()));
            return filePublicUrl;
        }
        catch (Throwable e) {
            throw new BackendGenericError("error encrypting item id", e);
        }
    }
}

