/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers.items;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.version.Version;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.GCubeItem;
import org.gcube.common.storagehub.model.items.RootItem;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.gcube.common.storagehub.model.storages.StorageBackendFactory;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.handlers.content.ContentHandler;
import org.gcube.data.access.storagehub.handlers.content.ContentHandlerFactory;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.ItemHandler;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.items.builders.ArchiveStructureCreationParameter;
import org.gcube.data.access.storagehub.handlers.items.builders.CreateParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.FileCreationParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.FolderCreationParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.GCubeItemCreationParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.URLCreationParameters;
import org.gcube.data.access.storagehub.handlers.plugins.StorageBackendHandler;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ItemHandler {
    @Inject
    AccountingHandler accountingHandler;
    @Inject
    ContentHandlerFactory contenthandlerFactory;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    VersionHandler versionHandler;
    @Inject
    TrashHandler trashHandler;
    @Inject
    StorageBackendHandler storageBackendHandler;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;
    private static Logger log = LoggerFactory.getLogger(ItemHandler.class);
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$access$storagehub$handlers$items$builders$CreateParameters$ManagedType;

    /*
     * Exception decompiling
     */
    public <T extends CreateParameters> String create(T parameters) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String create(FolderCreationParameters params, Node destination) throws Exception {
        Utils.acquireLockWithWait((Session)params.getSession(), (String)destination.getPath(), (boolean)false, (String)params.getUser(), (int)10);
        Node newNode = Utils.createFolderInternally((FolderCreationParameters)params, (AccountingHandler)this.accountingHandler, (boolean)false);
        params.getSession().save();
        return newNode.getIdentifier();
    }

    private String create(FileCreationParameters params, Node destination) throws Exception {
        Node newNode = this.createFileItemInternally(params.getSession(), destination, params.getStream(), params.getName(), params.getDescription(), params.getFileDetails(), params.getUser(), true);
        params.getSession().save();
        this.versionHandler.checkinContentNode(newNode);
        return newNode.getIdentifier();
    }

    private String create(URLCreationParameters params, Node destination) throws Exception {
        Utils.acquireLockWithWait((Session)params.getSession(), (String)destination.getPath(), (boolean)false, (String)params.getUser(), (int)10);
        Node newNode = Utils.createURLInternally((Session)params.getSession(), (Node)destination, (String)params.getName(), (URL)params.getUrl(), (String)params.getDescription(), (String)params.getUser(), (AccountingHandler)this.accountingHandler);
        params.getSession().save();
        return newNode.getIdentifier();
    }

    private String create(ArchiveStructureCreationParameter params, Node destination) throws Exception {
        ArchiveEntry entry;
        Utils.acquireLockWithWait((Session)params.getSession(), (String)destination.getPath(), (boolean)false, (String)params.getUser(), (int)10);
        FolderCreationParameters folderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name(params.getParentFolderName()).author(params.getUser()).on(destination.getIdentifier()).with(params.getSession()).build();
        Node parentDirectoryNode = Utils.createFolderInternally((FolderCreationParameters)folderParameters, (AccountingHandler)this.accountingHandler, (boolean)false);
        params.getSession().save();
        try {
            if (params.getSession().getWorkspace().getLockManager().isLocked(destination.getPath())) {
                params.getSession().getWorkspace().getLockManager().unlock(destination.getPath());
            }
        }
        catch (Throwable t) {
            log.warn("error unlocking {}", (Object)destination.getPath(), (Object)t);
        }
        HashSet<Node> fileNodes = new HashSet<Node>();
        HashMap directoryNodeMap = new HashMap();
        ArchiveInputStream input = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(params.getStream()));
        String macNestedFolderName = null;
        while ((entry = input.getNextEntry()) != null) {
            String entirePath = entry.getName();
            if (entirePath.startsWith("__MACOSX/") || entirePath.equals("__MACOSX")) {
                log.debug("skipping __MACOSX entry: {}", (Object)entirePath);
                if (macNestedFolderName != null || !entirePath.startsWith("__MACOSX/") || entirePath.length() <= 9) continue;
                String afterMacOSX = entirePath.substring(9);
                int slashIndex = afterMacOSX.indexOf("/");
                if (slashIndex > 0) {
                    macNestedFolderName = afterMacOSX.substring(0, slashIndex);
                } else if (!afterMacOSX.isEmpty()) {
                    macNestedFolderName = afterMacOSX;
                }
                if (macNestedFolderName == null) continue;
                log.info("detected Mac folder name from __MACOSX structure: {}", (Object)macNestedFolderName);
                continue;
            }
            if (entirePath.contains("/__MACOSX/") && macNestedFolderName == null) {
                int macosxIndex = entirePath.indexOf("/__MACOSX/");
                String afterMacOSX = entirePath.substring(macosxIndex + 10);
                int slashIndex = afterMacOSX.indexOf("/");
                if (slashIndex > 0) {
                    macNestedFolderName = afterMacOSX.substring(0, slashIndex);
                } else if (!afterMacOSX.isEmpty()) {
                    macNestedFolderName = afterMacOSX;
                }
                if (macNestedFolderName != null) {
                    log.info("detected Mac folder name from __MACOSX structure: {}", (Object)macNestedFolderName);
                }
                log.debug("skipping __MACOSX entry: {}", (Object)entirePath);
                continue;
            }
            if (entirePath.contains("/.DS_Store") || entirePath.equals(".DS_Store")) {
                log.debug("skipping .DS_Store file: {}", (Object)entirePath);
                continue;
            }
            log.debug("reading new entry ------> {} ", (Object)entirePath);
            if (entry.isDirectory()) {
                log.debug("creating directory with entire path {} ", (Object)entirePath);
                this.createPath(entirePath, directoryNodeMap, parentDirectoryNode, params.getSession(), params.getUser());
                continue;
            }
            try {
                String name = entirePath.replaceAll("([^/]*/)*(.*)", "$2");
                String parentPath = entirePath.replaceAll("(([^/]*/)*)(.*)", "$1");
                log.debug("creating file with entire path {}, name {}, parentPath {} ", new Object[]{entirePath, name, parentPath});
                Node fileNode = null;
                long fileSize = entry.getSize();
                FormDataContentDisposition fileDetail = ((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)name).size(fileSize)).build();
                1 notClosableIS = new /* Unavailable Anonymous Inner Class!! */;
                if (parentPath.isEmpty()) {
                    fileNode = this.createFileItemInternally(params.getSession(), parentDirectoryNode, (InputStream)notClosableIS, name, "", fileDetail, params.getUser(), false);
                } else {
                    Node parentNode = (Node)directoryNodeMap.get(parentPath);
                    if (parentNode == null) {
                        parentNode = this.createPath(parentPath, directoryNodeMap, parentDirectoryNode, params.getSession(), params.getUser());
                    }
                    fileNode = this.createFileItemInternally(params.getSession(), parentNode, (InputStream)notClosableIS, name, "", fileDetail, params.getUser(), false);
                }
                fileNodes.add(fileNode);
            }
            catch (Throwable e) {
                log.warn("error getting file {}", (Object)entry.getName(), (Object)e);
            }
        }
        log.info("archive {} uploading finished ", (Object)params.getParentFolderName());
        if (macNestedFolderName != null) {
            this.flattenMacNestedStructure(parentDirectoryNode, macNestedFolderName, params.getSession());
        }
        params.getSession().save();
        for (Node node : fileNodes) {
            this.versionHandler.checkinContentNode(node);
        }
        return parentDirectoryNode.getIdentifier();
    }

    private void flattenMacNestedStructure(Node parentDirectoryNode, String nestedFolderName, Session ses) throws RepositoryException {
        try {
            Node nestedFolder;
            String nestedFolderPath = Paths.append((Path)Paths.getPath((String)parentDirectoryNode.getPath()), (String)nestedFolderName).toPath();
            if (ses.nodeExists(nestedFolderPath) && (nestedFolder = ses.getNode(nestedFolderPath)).hasNodes()) {
                log.info("Detected Mac nested structure, flattening folder: {}", (Object)nestedFolderPath);
                NodeIterator children = nestedFolder.getNodes();
                while (children.hasNext()) {
                    Node child = children.nextNode();
                    String childName = child.getName();
                    String newPath = Paths.append((Path)Paths.getPath((String)parentDirectoryNode.getPath()), (String)childName).toPath();
                    log.debug("Moving {} to {}", (Object)child.getPath(), (Object)newPath);
                    ses.move(child.getPath(), newPath);
                }
                nestedFolder.remove();
                ses.save();
                log.info("Mac nested structure flattened successfully");
            }
        }
        catch (Exception e) {
            log.warn("Error flattening Mac nested structure, proceeding without optimization", (Throwable)e);
        }
    }

    public Node checkUpdateContent(String path, String newItemId, Session ses, String login) throws RepositoryException, StorageHubException {
        Node existingNode = ses.getNode(path);
        Node newNode = ses.getNodeByIdentifier(newItemId);
        this.authChecker.checkWriteAuthorizationControl(ses, login, existingNode.getIdentifier(), false);
        try {
            Utils.acquireLockWithWait((Session)ses, (String)existingNode.getPath(), (boolean)true, (String)login, (int)2);
            this.versionHandler.checkoutContentNode(existingNode);
            AbstractFileItem item = (AbstractFileItem)this.node2Item.getItem(newNode, null);
            this.item2Node.replaceContent(existingNode, item, ItemAction.UPDATED);
            String versionName = null;
            Version version = this.versionHandler.getCurrentVersion(existingNode);
            versionName = version.getName();
            this.accountingHandler.createFileUpdated(item.getTitle(), versionName, ses, existingNode, login, false);
            this.trashHandler.removeNodes(ses, Collections.singletonList(item), null);
            ses.save();
            this.versionHandler.checkinContentNode(existingNode);
        }
        finally {
            if (ses.getWorkspace().getLockManager().isLocked(existingNode.getPath()) && ses.getWorkspace().getLockManager().getLock(existingNode.getPath()).isLockOwningSession()) {
                ses.getWorkspace().getLockManager().unlock(existingNode.getPath());
            }
        }
        return existingNode;
    }

    private Node createPath(String parentPath, Map<String, Node> directoryNodeMap, Node rootNode, Session ses, String user) throws StorageHubException, RepositoryException {
        String[] parentPathSplit = parentPath.split("/");
        String name = parentPathSplit[parentPathSplit.length - 1];
        StringBuilder relParentPath = new StringBuilder();
        int i = 0;
        while (i <= parentPathSplit.length - 2) {
            relParentPath.append(parentPathSplit[i]).append("/");
            ++i;
        }
        if (relParentPath.toString().isEmpty()) {
            FolderCreationParameters folderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name(name).author(user).on(rootNode.getIdentifier()).with(ses).build();
            Node createdNode = Utils.createFolderInternally((FolderCreationParameters)folderParameters, (AccountingHandler)this.accountingHandler, (boolean)false);
            directoryNodeMap.put(name + "/", createdNode);
            return createdNode;
        }
        Node relParentNode = directoryNodeMap.get(relParentPath.toString());
        if (relParentNode == null) {
            relParentNode = this.createPath(relParentPath.toString(), directoryNodeMap, rootNode, ses, user);
        }
        FolderCreationParameters folderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name(name).author(user).on(relParentNode.getIdentifier()).with(ses).build();
        Node createdNode = Utils.createFolderInternally((FolderCreationParameters)folderParameters, (AccountingHandler)this.accountingHandler, (boolean)false);
        directoryNodeMap.put(relParentPath.append(name).append("/").toString(), createdNode);
        return createdNode;
    }

    private String create(GCubeItemCreationParameters params, Node destination) throws Exception {
        Utils.acquireLockWithWait((Session)params.getSession(), (String)destination.getPath(), (boolean)false, (String)params.getUser(), (int)10);
        Node newNode = Utils.createGcubeItemInternally((Session)params.getSession(), (Node)destination, (String)params.getItem().getName(), (String)params.getItem().getDescription(), (String)params.getUser(), (GCubeItem)params.getItem(), (AccountingHandler)this.accountingHandler);
        params.getSession().save();
        return newNode.getIdentifier();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node createFileItemInternally(Session ses, Node destinationNode, InputStream stream, String name, String description, FormDataContentDisposition fileDetails, String login, boolean withLock) throws RepositoryException, StorageHubException {
        Node newNode;
        log.trace("UPLOAD: starting preparing file");
        FolderItem destinationItem = (FolderItem)this.node2Item.getItem(destinationNode, Excludes.ALL);
        StorageBackendFactory sbf = this.storageBackendHandler.get(destinationItem.getBackend());
        StorageBackend sb = sbf.create(destinationItem.getBackend());
        String relativePath = destinationNode.getPath();
        String newNodePath = Paths.append((Path)Paths.getPath((String)destinationNode.getPath()), (String)name).toPath();
        log.info("new node path is {}", (Object)newNodePath);
        if (ses.nodeExists(newNodePath)) {
            newNode = ses.getNode(newNodePath);
            this.authChecker.checkWriteAuthorizationControl(ses, login, newNode.getIdentifier(), false);
            if (withLock) {
                try {
                    ses.getWorkspace().getLockManager().lock(newNode.getPath(), true, true, 0L, login);
                }
                catch (LockException lockException) {
                    throw new ItemLockedException("Cannot update item, the resource is busy. Please, retry later.");
                }
            }
            AbstractFileItem item = this.fillItemWithContent(stream, sb, name, description, fileDetails, relativePath, login);
            try {
                try {
                    this.versionHandler.checkoutContentNode(newNode);
                    log.trace("replacing content of class {}", item.getContent().getClass());
                    this.item2Node.replaceContent(newNode, item, ItemAction.UPDATED);
                    String versionName = null;
                    try {
                        Version version = this.versionHandler.getCurrentVersion(newNode);
                        versionName = version.getName();
                    }
                    catch (RepositoryException repositoryException) {
                        log.warn("current version of {} cannot be retreived", (Object)item.getId());
                    }
                    this.accountingHandler.createFileUpdated(item.getTitle(), versionName, ses, newNode, login, false);
                    ses.save();
                    return newNode;
                }
                catch (Throwable t) {
                    log.error("error saving item", t);
                    if (!withLock) return newNode;
                    if (ses != null && ses.hasPendingChanges()) {
                        ses.save();
                    }
                    ses.getWorkspace().getLockManager().unlock(newNode.getPath());
                }
                return newNode;
            }
            finally {
                if (withLock) {
                    if (ses != null && ses.hasPendingChanges()) {
                        ses.save();
                    }
                    ses.getWorkspace().getLockManager().unlock(newNode.getPath());
                }
            }
        }
        this.authChecker.checkWriteAuthorizationControl(ses, login, destinationNode.getIdentifier(), true);
        AbstractFileItem item = this.fillItemWithContent(stream, sb, name, description, fileDetails, relativePath, login);
        if (withLock) {
            try {
                log.debug("trying to acquire lock");
                Utils.acquireLockWithWait((Session)ses, (String)destinationNode.getPath(), (boolean)false, (String)login, (int)10);
            }
            catch (LockException lockException) {
                throw new ItemLockedException("Cannot update item, the resource is busy. Please, retry later.");
            }
        }
        try {
            try {
                newNode = this.item2Node.getNode(destinationNode, (RootItem)item);
                this.accountingHandler.createEntryCreate(item.getTitle(), ses, newNode, login, false);
                ses.save();
            }
            catch (Throwable t) {
                log.error("error saving item", t);
                throw new BackendGenericError(t);
            }
        }
        finally {
            if (withLock) {
                ses.getWorkspace().getLockManager().unlock(destinationNode.getPath());
            }
        }
        this.versionHandler.makeVersionableContent(newNode);
        this.accountingHandler.createFolderAddObj(name, item.getClass().getSimpleName(), item.getContent().getMimeType(), ses, login, destinationNode, false);
        return newNode;
    }

    private AbstractFileItem fillItemWithContent(InputStream stream, StorageBackend storageBackend, String name, String description, FormDataContentDisposition fileDetails, String relPath, String login) throws BackendGenericError {
        log.trace("UPLOAD: filling content");
        ContentHandler handler = this.getContentHandler(stream, storageBackend, name, fileDetails, relPath, login);
        return handler.buildItem(name, description, login);
    }

    private ContentHandler getContentHandler(InputStream stream, StorageBackend storageBackend, String name, FormDataContentDisposition fileDetails, String relPath, String login) throws BackendGenericError {
        log.trace("UPLOAD: handling content");
        long start = System.currentTimeMillis();
        log.trace("UPLOAD: writing the stream - start");
        try {
            ContentHandler handler;
            MetaInfo info;
            block28: {
                String mimeType;
                BufferedInputStream is1;
                Object var13_16;
                Throwable throwable;
                info = null;
                try {
                    log.debug("UPLOAD: upload on {} - start", storageBackend.getClass());
                    if (fileDetails != null && fileDetails.getSize() > 0L) {
                        log.debug("UPLOAD: file size set is {} Byte", (Object)fileDetails.getSize());
                        info = storageBackend.upload(stream, relPath, name, Long.valueOf(fileDetails.getSize()), login);
                    } else {
                        info = storageBackend.upload(stream, relPath, name, login);
                    }
                    log.debug("UPLOAD: upload on storage - stop");
                }
                catch (Throwable e) {
                    log.error("error writing content", e);
                    throw e;
                }
                handler = null;
                log.debug("UPLOAD: reading the mimetype - start");
                try {
                    throwable = null;
                    var13_16 = null;
                    try {
                        is1 = new BufferedInputStream(storageBackend.download(info.getStorageId()));
                        try {
                            MediaType mediaType = null;
                            TikaConfig config = TikaConfig.getDefaultConfig();
                            Detector detector = config.getDetector();
                            TikaInputStream tikastream = TikaInputStream.get((InputStream)is1);
                            Metadata metadata = new Metadata();
                            mediaType = detector.detect((InputStream)tikastream, metadata);
                            mimeType = mediaType.getBaseType().toString();
                            handler = this.contenthandlerFactory.create(mimeType);
                            log.debug("UPLOAD: reading the mimetype {} - finished in {}", (Object)mimeType, (Object)(System.currentTimeMillis() - start));
                        }
                        finally {
                            if (is1 != null) {
                                ((InputStream)is1).close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    log.error("error retrieving mimeType", e);
                    throw new RuntimeException(e);
                }
                if (handler.requiresInputStream()) {
                    throwable = null;
                    var13_16 = null;
                    try {
                        is1 = new BufferedInputStream(storageBackend.download(info.getStorageId()));
                        try {
                            log.debug("UPLOAD: the file type requires input stream");
                            handler.initiliseSpecificContent((InputStream)is1, name, mimeType, info.getSize());
                            break block28;
                        }
                        finally {
                            if (is1 != null) {
                                ((InputStream)is1).close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                log.debug("UPLOAD: the file type doesn't requires input stream");
                handler.initiliseSpecificContent(name, mimeType);
            }
            log.debug("UPLOAD: writing the stream - finished in {}", (Object)(System.currentTimeMillis() - start));
            handler.getContent().setData("jcr:content");
            handler.getContent().setStorageId(info.getStorageId());
            handler.getContent().setSize(Long.valueOf(info.getSize()));
            handler.getContent().setRemotePath(info.getRemotePath());
            handler.getContent().setPayloadBackend(info.getPayloadBackend());
            log.debug("UPLOAD: content payload set as {} ", (Object)handler.getContent().getPayloadBackend());
            return handler;
        }
        catch (Throwable e) {
            log.error("error writing file", e);
            throw new BackendGenericError(e);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$access$storagehub$handlers$items$builders$CreateParameters$ManagedType() {
        if ($SWITCH_TABLE$org$gcube$data$access$storagehub$handlers$items$builders$CreateParameters$ManagedType != null) {
            return $SWITCH_TABLE$org$gcube$data$access$storagehub$handlers$items$builders$CreateParameters$ManagedType;
        }
        int[] nArray = new int[CreateParameters.ManagedType.values().length];
        try {
            nArray[CreateParameters.ManagedType.ARCHIVE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CreateParameters.ManagedType.FILE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CreateParameters.ManagedType.FOLDER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CreateParameters.ManagedType.GCUBEITEM.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CreateParameters.ManagedType.URL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$data$access$storagehub$handlers$items$builders$CreateParameters$ManagedType = nArray;
        return nArray;
    }
}

