package org.gcube.data.access.storagehub.health;

import org.gcube.common.health.api.HealthCheck;
import org.gcube.common.health.api.ReadinessChecker;
import org.gcube.common.health.api.response.HealthCheckResponse;
import org.gcube.common.storagehub.model.items.nodes.PayloadBackend;
import org.gcube.data.access.storagehub.handlers.plugins.StorageBackendHandler;
import org.gcube.data.access.storagehub.storage.backend.impl.GcubeDefaultS3StorageBackendFactory;
import org.gcube.data.access.storagehub.storage.backend.impl.S3Backend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReadinessChecker
public class DefaultStorageCheck implements HealthCheck{

	private static Logger log = LoggerFactory.getLogger(DefaultStorageCheck.class);
	
	private static final String NAME;
	private static final PayloadBackend defaultPayload;
	private static final HealthCheckResponse OK;
	private static final HealthCheckResponse ERROR_CONTACTING_STORAGE;

	static {
		defaultPayload = StorageBackendHandler.getDefaultPayloadForFolder();
		NAME = "default storage (" + defaultPayload.getStorageName() + ")";
		OK = HealthCheckResponse.builder(NAME).up().build(); 
		ERROR_CONTACTING_STORAGE = HealthCheckResponse.builder(NAME).down().error("error contacting storage").build();
	}

	@Override
	public String getName() {
		return NAME;
	}

	@Override
	public HealthCheckResponse check() {
		try {
			GcubeDefaultS3StorageBackendFactory storageFactory =new GcubeDefaultS3StorageBackendFactory();
			storageFactory.init();
 			if (((S3Backend)storageFactory.create(defaultPayload)).isAlive())
				return OK;
			else
				return ERROR_CONTACTING_STORAGE;
		} catch (Exception e) {
			log.error("error checking defaultStorage",e);
			return HealthCheckResponse.builder(getName()).down().error(e.getMessage()).build(); 
		} 
		
	}

}
