/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.data.access.storagehub.handlers.ClassHandler;

public class NodeChildrenFilterIterator
implements Iterator<Node> {
    private NodeIterator it;
    private Node currentNode = null;

    public NodeChildrenFilterIterator(Node node) throws BackendGenericError {
        try {
            this.it = node.getNodes();
        }
        catch (RepositoryException e) {
            throw new BackendGenericError((Throwable)e);
        }
    }

    public NodeChildrenFilterIterator(NodeIterator iterator) throws BackendGenericError {
        this.it = iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasNext() {
        try {
            do {
                if (!this.it.hasNext()) {
                    return false;
                }
                this.currentNode = this.it.nextNode();
            } while (ClassHandler.instance().get(this.currentNode.getPrimaryNodeType().getName()) == null);
            return true;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Node next() {
        return this.currentNode;
    }
}

