/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.gcube.common.storagehub.model.acls.ACL;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exporter.DumpData;
import org.gcube.common.storagehub.model.exporter.GroupData;
import org.gcube.common.storagehub.model.exporter.UserData;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.types.SHUBUser;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.vres.VREManager;
import org.gcube.data.access.storagehub.services.delegates.ACLManagerDelegate;
import org.gcube.data.access.storagehub.services.delegates.GroupManagerDelegate;
import org.gcube.data.access.storagehub.services.delegates.UserManagerDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DataHandler {
    public static final Logger logger = LoggerFactory.getLogger(DataHandler.class);
    @Inject
    UserManagerDelegate userHandler;
    @Inject
    GroupManagerDelegate groupHandler;
    @Inject
    ACLManagerDelegate aclHandler;
    @Inject
    PathUtil pathUtil;
    @Inject
    VREManager vreManager;

    public DumpData exportData(JackrabbitSession session) throws RepositoryException, StorageHubException {
        DumpData data = new DumpData();
        List users = this.userHandler.getAllUsers(session);
        List usersData = users.stream().map(u -> new UserData(u.getUserName())).collect(Collectors.toList());
        List groups = this.groupHandler.getGroups(session);
        logger.debug("found users {} ", usersData);
        logger.debug("found groups {} ", (Object)groups);
        ArrayList<GroupData> groupsData = new ArrayList<GroupData>(groups.size());
        for (String group : groups) {
            logger.debug("searching for group {}", (Object)group);
            Item vreFolderItem = this.vreManager.getVreFolderItemByGroupName(session, group, null).getVreFolder();
            String owner = vreFolderItem.getOwner();
            List acls = this.aclHandler.getByItem(vreFolderItem, (Session)session);
            AccessType accessType = AccessType.READ_ONLY;
            ArrayList<ACL> otherAccess = new ArrayList<ACL>(acls.size() - 1);
            for (ACL acl : acls) {
                if (acl.getPrincipal().equals(group)) {
                    accessType = (AccessType)acl.getAccessTypes().get(0);
                    continue;
                }
                otherAccess.add(acl);
            }
            List members = this.groupHandler.getUsersBelongingToGroup(session, group);
            groupsData.add(new GroupData(group, owner, members, accessType, otherAccess));
        }
        HashMap<String, List> itemsPerUser = new HashMap<String, List>();
        for (SHUBUser user : users) {
            logger.debug("getting all the files in {} workspace folder ", (Object)user.getUserName());
            String homePath = this.pathUtil.getWorkspacePath(user.getUserName()).toPath();
            Node homeNode = session.getNode(homePath);
            List items = Utils.getItemList((Node)homeNode, Collections.emptyList(), null, (boolean)true, null);
            items.forEach(i -> i.setParentId(null));
            itemsPerUser.put(user.getUserName(), this.retrieveSubItems(items));
        }
        data.setUsers(usersData);
        data.setGroups(groupsData);
        data.setItemPerUser(itemsPerUser);
        return data;
    }

    List<Item> retrieveSubItems(List<Item> items) throws StorageHubException, RepositoryException {
        ArrayList<Item> toReturn = new ArrayList<Item>();
        for (Item item : items) {
            if (item instanceof FolderItem) {
                FolderItem f = (FolderItem)item;
                if (f.isShared()) continue;
                toReturn.addAll(this.retrieveSubItems(Utils.getItemList((Node)((Node)f.getRelatedNode()), Collections.emptyList(), null, (boolean)true, null)));
                continue;
            }
            toReturn.add(item);
        }
        return toReturn;
    }

    public void importData(JackrabbitSession session, DumpData data) {
        data.getUsers().forEach(u -> {
            try {
                this.userHandler.createUser(session, u.getUserName(), "pwd");
            }
            catch (RepositoryException | StorageHubException e) {
                logger.warn("error importing user {} ", (Object)u.getUserName(), (Object)e);
            }
        });
        data.getGroups().forEach(g -> {
            try {
                this.groupHandler.createGroup(session, g.getName(), g.getAccessType(), g.getFolderOwner(), true);
                for (String member : g.getMembers()) {
                    try {
                        this.groupHandler.addUserToGroup(session, member, g.getName());
                    }
                    catch (Throwable t) {
                        logger.warn("error adding user {} to group {}", new Object[]{member, g.getName(), t});
                    }
                }
                Item vreFolderItem = this.vreManager.getVreFolderItemByGroupName(session, g.getName(), null).getVreFolder();
                for (ACL acl : g.getAcls()) {
                    this.aclHandler.update(acl.getPrincipal(), (Node)vreFolderItem.getRelatedNode(), (AccessType)acl.getAccessTypes().get(0), (Session)session);
                }
            }
            catch (Throwable e) {
                logger.warn("error importing group {} ", (Object)g.getName(), (Object)e);
            }
        });
    }
}

