/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.metadata.Ignore;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceMethodSignature;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.items.TrashItem;
import org.gcube.common.storagehub.model.items.nodes.PayloadBackend;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.gcube.common.storagehub.model.storages.StorageBackendFactory;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.StorageHubApplicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.ReportHandler;
import org.gcube.data.access.storagehub.handlers.PublicLinkHandler;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.items.builders.FolderCreationParameters;
import org.gcube.data.access.storagehub.handlers.plugins.StorageBackendHandler;
import org.gcube.data.access.storagehub.handlers.vres.VRE;
import org.gcube.data.access.storagehub.handlers.vres.VREManager;
import org.gcube.data.access.storagehub.predicates.IncludeTypePredicate;
import org.gcube.data.access.storagehub.predicates.ItemTypePredicate;
import org.gcube.data.access.storagehub.query.sql2.evaluators.Evaluators;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;
import org.gcube.data.access.storagehub.services.Impersonable;
import org.gcube.data.access.storagehub.services.delegates.UserManagerDelegate;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@jakarta.ws.rs.Path(value="/")
@ManagedBy(value=StorageHubApplicationManager.class)
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class WorkspaceManager
extends Impersonable {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceManager.class);
    private final StoragehubRepository repository = StoragehubRepository.repository;
    @Inject
    Evaluators evaluator;
    @Inject
    PathUtil pathUtil;
    @Inject
    VREManager vreManager;
    @Context
    ServletContext context;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    TrashHandler trashHandler;
    @Inject
    StorageBackendHandler storageBackendHandler;
    @Inject
    PublicLinkHandler publicLinkHandler;
    @Inject
    UserManagerDelegate userHandler;
    @Inject
    ReportHandler reportHandler;
    @RequestScoped
    @QueryParam(value="exclude")
    private List<String> excludes = Collections.emptyList();
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;

    @StatusCodes(value={@ResponseCode(code=200, condition="Item retrieved."), @ResponseCode(code=406, condition="Item not found.")})
    @ResourceMethodSignature(output=ItemWrapper.class, queryParams={@QueryParam(value="relPath"), @QueryParam(value="exclude")})
    @jakarta.ws.rs.Path(value="/")
    @GET
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getWorkspace(@QueryParam(value="relPath") String relPath) {
        Item toReturn;
        block10: {
            InnerMethodName.set((String)"getWorkspace");
            Session ses = null;
            Path absolutePath = relPath == null ? this.pathUtil.getWorkspacePath(this.currentUser) : Paths.append((Path)this.pathUtil.getWorkspacePath(this.currentUser), (String)relPath);
            toReturn = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                Path trashPath = this.pathUtil.getTrashPath(this.currentUser, ses);
                if (!ses.nodeExists(trashPath.toPath())) {
                    Node wsNode = ses.getNode(this.pathUtil.getWorkspacePath(this.currentUser).toPath());
                    FolderCreationParameters trashFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("Trash").description("trash of " + this.currentUser).author(this.currentUser).on(wsNode.getIdentifier()).with(ses).build();
                    Utils.createFolderInternally((FolderCreationParameters)trashFolderParameters, null, (boolean)true);
                    ses.save();
                }
                Node node = ses.getNode(absolutePath.toPath());
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, node.getIdentifier());
                toReturn = this.node2Item.getItem(node, this.excludes);
            }
            catch (RepositoryException re) {
                log.error("jcr error getting workspace item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses != null) {
                    ses.logout();
                }
                break block10;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block10;
            ses.logout();
        }
        return new ItemWrapper(toReturn);
    }

    @ResourceMethodSignature(output=String.class, formParams={@FormParam(value="file")}, queryParams={@QueryParam(value="exclude")})
    @DocumentationExample(value="...\n\n--------boundaryString\nContent-Disposition: form-data; name=\"file\"; filename=\"doc.pdf\"; size=426018;\nContent-Type: application/pdf\n\n(data)\n--------boundaryString--")
    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="File created."), @ResponseCode(code=400, condition="File not provided."), @ResponseCode(code=415, condition="Wrong content type."), @ResponseCode(code=500, condition="Wrong set of parameters.")})
    @jakarta.ws.rs.Path(value="volatile")
    public String uploadVolatileFile(@FormDataParam(value="file") InputStream file, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        InnerMethodName.set((String)"uploadToVolatileArea");
        log.info("uploading file {} of size {} to volatile area ({} - {})", new Object[]{fileDetail.getFileName(), fileDetail.getSize(), fileDetail.getName(), fileDetail.getParameters().toString()});
        String toReturn = null;
        try {
            long size = fileDetail.getSize();
            PayloadBackend payloadBackend = new PayloadBackend("volatile-minio", null);
            StorageBackendFactory sbf = this.storageBackendHandler.get(payloadBackend);
            StorageBackend sb = sbf.create(payloadBackend);
            log.info("UPLOAD: call started with file size {}", (Object)size);
            MetaInfo info = sb.upload(file, null, fileDetail.getFileName(), this.currentUser);
            log.debug("UPLOAD: call finished");
            toReturn = this.publicLinkHandler.getForVolatile(info.getStorageId(), "volatile-minio", this.context);
        }
        catch (StorageHubException se) {
            log.error("error uploading file to volatile area", (Throwable)se);
            GXOutboundErrorResponse.throwException((Exception)((Object)se));
        }
        catch (Throwable e) {
            log.error("error uploading file to volatile area", e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
        }
        return toReturn;
    }

    @ResourceMethodSignature(output=ItemWrapper.class, queryParams={@QueryParam(value="exclude")})
    @jakarta.ws.rs.Path(value="vrefolder")
    @GET
    @StatusCodes(value={@ResponseCode(code=200, condition="Success.")})
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getCurrentVreFolder() {
        Item vreItem;
        block10: {
            InnerMethodName.set((String)"getCurrentVreFolder");
            JackrabbitSession ses = null;
            vreItem = null;
            try {
                ses = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                Secret secret = SecretManagerProvider.get();
                String groupName = this.vreManager.retrieveGroupNameFromContext(secret.getContext());
                if (!this.userHandler.getGroupsPerUser(ses, this.currentUser).contains(groupName)) {
                    throw new InvalidCallParameters("error getting VRE with user " + this.currentUser + " for group " + groupName);
                }
                vreItem = this.vreManager.getVreFolderItemByGroupName(ses, groupName, this.excludes).getVreFolder();
            }
            catch (RepositoryException re) {
                log.error("jcr error getting vrefolder", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses != null) {
                    ses.logout();
                }
                break block10;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block10;
            ses.logout();
        }
        return new ItemWrapper(vreItem);
    }

    @ResourceMethodSignature(output=ItemList.class, queryParams={@QueryParam(value="exclude")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Success.")})
    @jakarta.ws.rs.Path(value="vrefolder/recents")
    @GET
    @Produces(value={"application/json"})
    public ItemList getVreFolderRecentsDocument() {
        InnerMethodName.set((String)"getVreFolderRecents");
        JackrabbitSession ses = null;
        List recentItems = Collections.emptyList();
        try {
            ses = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            Secret secret = SecretManagerProvider.get();
            String groupName = this.vreManager.retrieveGroupNameFromContext(secret.getContext());
            if (!this.userHandler.getGroupsPerUser(ses, this.currentUser).contains(groupName)) {
                throw new InvalidCallParameters("error getting VRE with user " + this.currentUser + " for group " + groupName);
            }
            VRE vre = this.vreManager.getVreFolderItemByGroupName(ses, groupName, this.excludes);
            log.trace("VRE retrieved {}", (Object)vre.getVreFolder().getTitle());
            recentItems = vre.getRecents();
            log.trace("recents retrieved {}", (Object)vre.getVreFolder().getTitle());
            ItemList itemList = new ItemList(recentItems);
            return itemList;
        }
        catch (RepositoryException re) {
            log.error("jcr error getting recents", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemList(recentItems);
    }

    @ResourceMethodSignature(output=ItemWrapper.class, queryParams={@QueryParam(value="exclude")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Success.")})
    @jakarta.ws.rs.Path(value="trash")
    @GET
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getTrashRootFolder() {
        Item item;
        block9: {
            InnerMethodName.set((String)"getTrashRootFolder");
            Session ses = null;
            item = null;
            try {
                long start = System.currentTimeMillis();
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                Path trashPath = this.pathUtil.getTrashPath(this.currentUser, ses);
                log.info("time to connect to repo  {}", (Object)(System.currentTimeMillis() - start));
                Node folder = ses.getNode(trashPath.toPath());
                item = this.node2Item.getItem(folder, this.excludes);
            }
            catch (RepositoryException re) {
                log.error("jcr error getting trash", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses != null) {
                    ses.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block9;
            ses.logout();
        }
        return new ItemWrapper(item);
    }

    @ResourceMethodSignature(output=String.class, queryParams={@QueryParam(value="exclude")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Trash emptied.")})
    @jakarta.ws.rs.Path(value="trash/empty")
    @Produces(value={"text/plain"})
    @DELETE
    public String emptyTrash() {
        ArrayList records;
        String toReturn;
        block10: {
            InnerMethodName.set((String)"emptyTrash");
            Session ses = null;
            toReturn = null;
            records = new ArrayList();
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                Path trashPath = this.pathUtil.getTrashPath(this.currentUser, ses);
                Node trashNode = ses.getNode(trashPath.toPath());
                List itemsToDelete = Utils.getItemList((Node)trashNode, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, null);
                this.trashHandler.removeNodes(ses, itemsToDelete, records);
                toReturn = trashNode.getIdentifier();
            }
            catch (RepositoryException re) {
                log.error("jcr error emptying trash", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses != null) {
                    ses.logout();
                }
                break block10;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block10;
            ses.logout();
        }
        for (StorageUsageRecord sur : records) {
            this.reportHandler.setConsumerId(sur, this.currentUser);
            this.reportHandler.send(sur);
        }
        return toReturn;
    }

    @ResourceMethodSignature(output=String.class, queryParams={@QueryParam(value="exclude")}, formParams={@FormParam(value="trashedItemId"), @FormParam(value="destinationId")})
    @DocumentationExample(value="...\n\ntrashedId=17dae181-f33c- ... - 3fa22198dd30&destinationId=19863b4e-b33f- ... -5b6d2e0e1eee")
    @StatusCodes(value={@ResponseCode(code=200, condition="Item restored."), @ResponseCode(code=406, condition="Source or destination item does not exist."), @ResponseCode(code=409, condition="Source and destination are the same item."), @ResponseCode(code=415, condition="Wrong content type.")})
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @jakarta.ws.rs.Path(value="trash/restore")
    public String restoreItem(@FormParam(value="trashedItemId") String trashedItemId, @FormParam(value="destinationId") String destinationFolderId) {
        StorageUsageRecord sur;
        String toReturn;
        block17: {
            InnerMethodName.set((String)"restoreItem");
            Session ses = null;
            toReturn = null;
            sur = this.reportHandler.generateRecord(null, this.currentUser, "RESTORE", null, null, null);
            try {
                log.info("restoring node with id {}", (Object)trashedItemId);
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                Node nodeToRestore = ses.getNodeByIdentifier(trashedItemId);
                Item itemToRestore = this.node2Item.getItem(nodeToRestore, Excludes.ALL);
                this.reportHandler.setOwner(sur, itemToRestore.getOwner());
                if (!(itemToRestore instanceof TrashItem)) {
                    throw new InvalidItemException("Only trash items can be restored");
                }
                Path trashPath = this.pathUtil.getTrashPath(this.currentUser, ses);
                if (!itemToRestore.getPath().startsWith(trashPath.toPath())) {
                    throw new UserNotAuthorizedException("this item is not in the user " + this.currentUser + " trash");
                }
                Item destinationItem = null;
                if (destinationFolderId != null) {
                    destinationItem = this.node2Item.getItem(ses.getNodeByIdentifier(destinationFolderId), Excludes.ALL);
                    if (!(destinationItem instanceof FolderItem)) {
                        throw new InvalidCallParameters("destination item is not a folder");
                    }
                    toReturn = this.trashHandler.restoreItem(ses, (TrashItem)itemToRestore, (FolderItem)destinationItem, this.currentUser);
                } else {
                    toReturn = this.trashHandler.restoreItem(ses, (TrashItem)itemToRestore, null, this.currentUser);
                }
                Item restoredItem = this.node2Item.getItem(ses.getNodeByIdentifier(toReturn), Excludes.GET_ONLY_CONTENT);
                long size = 0L;
                if (restoredItem instanceof AbstractFileItem) {
                    size = ((AbstractFileItem)restoredItem).getContent().getSize();
                } else if (restoredItem instanceof FolderItem) {
                    size = Utils.getFolderInfo((Node)nodeToRestore).getSize();
                }
                this.reportHandler.setSize(sur, size >= 0L ? Long.valueOf(size / 1024L) : null);
                this.reportHandler.setSuccessResult(sur);
            }
            catch (RepositoryException re) {
                log.error("error restoring item with id {}", (Object)trashedItemId, (Object)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                this.reportHandler.setFailureResult(sur);
                if (ses != null) {
                    ses.logout();
                }
                break block17;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    this.reportHandler.setFailureResult(sur);
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block17;
            ses.logout();
        }
        this.reportHandler.send(sur);
        return toReturn;
    }

    @ResourceMethodSignature(output=ItemList.class, queryParams={@QueryParam(value="exclude")})
    @jakarta.ws.rs.Path(value="vrefolders")
    @GET
    @Produces(value={"application/json"})
    public ItemList getVreFolders() {
        List toReturn;
        block9: {
            InnerMethodName.set((String)"getVreFolders");
            Session ses = null;
            toReturn = null;
            Path vrePath = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                vrePath = this.pathUtil.getVREsPath(this.currentUser, ses);
                log.info("vres folder path is {}", (Object)vrePath.toPath());
                toReturn = Utils.getItemList((Node)ses.getNode(vrePath.toPath()), (List)this.excludes, null, (boolean)false, null);
            }
            catch (RepositoryException re) {
                log.error("error reading the node children of {}", vrePath, (Object)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses != null) {
                    ses.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block9;
            ses.logout();
        }
        return new ItemList(toReturn);
    }

    @ResourceMethodSignature(output=ItemList.class, queryParams={@QueryParam(value="start"), @QueryParam(value="limit"), @QueryParam(value="exclude")})
    @jakarta.ws.rs.Path(value="vrefolders/paged")
    @GET
    @Produces(value={"application/json"})
    public ItemList getVreFoldersPaged(@QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        List toReturn;
        block9: {
            InnerMethodName.set((String)"getVreFoldersPaged");
            Session ses = null;
            Path vrePath = null;
            toReturn = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                vrePath = this.pathUtil.getVREsPath(this.currentUser, ses);
                toReturn = Utils.getItemList((Node)ses.getNode(vrePath.toPath()), (List)this.excludes, (Range)new Range(start.intValue(), limit.intValue()), (boolean)false, null);
            }
            catch (RepositoryException re) {
                log.error("(paged) error reading the node children of {}", vrePath, (Object)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses != null) {
                    ses.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block9;
            ses.logout();
        }
        return new ItemList(toReturn);
    }

    @Ignore
    @StatusCodes(value={@ResponseCode(code=200, condition="List retrieved."), @ResponseCode(code=406, condition="Error retrieving shared-with-me folder.")})
    @jakarta.ws.rs.Path(value="shared-with-me")
    @GET
    @Produces(value={"application/json"})
    public ItemList getSharedWithMeFolders() {
        List toReturn;
        block9: {
            InnerMethodName.set((String)"getSharedWithMeFolders");
            Session ses = null;
            toReturn = null;
            Path sharedPath = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                sharedPath = this.pathUtil.getSharedWithMePath(this.currentUser);
                log.info("shared With Me folder path is {}", (Object)sharedPath.toPath());
                IncludeTypePredicate itemPredicate = new IncludeTypePredicate(SharedFolder.class);
                toReturn = Utils.getItemList((Node)ses.getNode(sharedPath.toPath()), (List)this.excludes, null, (boolean)false, (ItemTypePredicate)itemPredicate);
            }
            catch (RepositoryException re) {
                log.error("error reading shared with me folder ({})", sharedPath, (Object)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses != null) {
                    ses.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block9;
            ses.logout();
        }
        return new ItemList(toReturn);
    }

    @Ignore
    @jakarta.ws.rs.Path(value="count")
    @GET
    @Deprecated
    public String getTotalItemsCount() {
        InnerMethodName.set((String)"getTotalItemsCount");
        Session ses = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            Node wsNode = ses.getNode(this.pathUtil.getWorkspacePath(this.currentUser).toPath());
            String string = Long.toString(Utils.getFolderInfo((Node)wsNode).getCount());
            return string;
        }
        catch (RepositoryException re) {
            log.error("error getting workspace total item count", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return "0";
    }

    @Ignore
    @jakarta.ws.rs.Path(value="size")
    @GET
    @Deprecated
    public String getTotalVolume() {
        InnerMethodName.set((String)"getTotalSize");
        Session ses = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            Node wsNode = ses.getNode(this.pathUtil.getWorkspacePath(this.currentUser).toPath());
            String string = Long.toString(Utils.getFolderInfo((Node)wsNode).getSize());
            return string;
        }
        catch (RepositoryException re) {
            log.error("error getting workspace total size", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return "0";
    }
}

