/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.accounting;

import jakarta.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.data.access.storagehub.accounting.ReportHandler;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReportHandlerImpl
implements ReportHandler {
    final Logger logger = LoggerFactory.getLogger(ReportHandlerImpl.class);
    private static final String DEFAULT_PROVIDER_URI = "data.d4science.org";
    private URI providerURI;
    public AccountingPersistence accountingPersistence = AccountingPersistenceFactory.getPersistence();

    public ReportHandlerImpl() {
        try {
            this.providerURI = new URI(DEFAULT_PROVIDER_URI);
        }
        catch (URISyntaxException e) {
            this.logger.error("Invalid provider URI: data.d4science.org", (Throwable)e);
        }
    }

    public StorageUsageRecord generateRecord(StorageUsageRecord sur, String consumerId, String operation, String operationResult, String owner, Long size) {
        this.logger.trace("Generating accounting record: consumerId: [" + consumerId + "] operation: [" + operation + "] operationResult: [" + operationResult + "] owner: [" + owner + "] size: [" + String.valueOf(size) + "]");
        if (sur == null) {
            sur = new StorageUsageRecord();
        }
        try {
            sur.setScope(SecretManagerProvider.get().getContext());
            sur.setDataType(AbstractStorageUsageRecord.DataType.STORAGE);
            sur.setProviderURI(this.providerURI);
            if (consumerId != null) {
                sur.setConsumerId(consumerId);
            }
            if (owner != null) {
                sur.setResourceOwner(owner);
            }
            if (size != null) {
                sur.setDataVolume(size.longValue());
            }
            if (operation != null) {
                try {
                    sur.setOperationType(this.convertOperation(operation));
                }
                catch (RuntimeException e) {
                    this.logger.error("Error converting operation: " + operation, (Throwable)e);
                }
            }
            if (operationResult != null) {
                try {
                    sur.setOperationResult(this.convertOperationResult(operationResult));
                }
                catch (RuntimeException e) {
                    this.logger.error("Error converting operationResult: " + operationResult, (Throwable)e);
                }
            }
        }
        catch (InvalidValueException e) {
            this.logger.error("Error setting accounting record properties", (Throwable)e);
            return null;
        }
        this.logger.trace("Generated accounting record: " + String.valueOf(sur));
        return sur;
    }

    private UsageRecord.OperationResult convertOperationResult(String operationResult) {
        this.logger.debug("converting operationResult: " + operationResult);
        switch (operationResult) {
            case "SUCCESS": {
                return UsageRecord.OperationResult.SUCCESS;
            }
            case "FAILED": {
                return UsageRecord.OperationResult.FAILED;
            }
        }
        throw new RuntimeException("The operationResult " + operationResult + " is not converted or supported");
    }

    private AbstractStorageUsageRecord.OperationType convertOperation(String operation) {
        this.logger.debug("converting operation: " + operation);
        switch (operation) {
            case "UPLOAD": {
                return AbstractStorageUsageRecord.OperationType.CREATE;
            }
            case "DELETE": {
                return AbstractStorageUsageRecord.OperationType.DELETE;
            }
            case "MOVE": {
                return AbstractStorageUsageRecord.OperationType.UPDATE;
            }
            case "TRASH": {
                return AbstractStorageUsageRecord.OperationType.UPDATE;
            }
            case "RESTORE": {
                return AbstractStorageUsageRecord.OperationType.UPDATE;
            }
            case "COPY": {
                return AbstractStorageUsageRecord.OperationType.CREATE;
            }
            case "SOFT_COPY": {
                return AbstractStorageUsageRecord.OperationType.CREATE;
            }
            case "MOVE_DIR": {
                return AbstractStorageUsageRecord.OperationType.UPDATE;
            }
            case "COPY_DIR": {
                return AbstractStorageUsageRecord.OperationType.CREATE;
            }
            case "CREATE_DIR": {
                return AbstractStorageUsageRecord.OperationType.CREATE;
            }
            case "DOWNLOAD": {
                return AbstractStorageUsageRecord.OperationType.READ;
            }
        }
        throw new RuntimeException("The operation " + operation + " is not converted or supported");
    }

    public void send(StorageUsageRecord sur) {
        this.logger.debug("report sending...");
        try {
            this.accountingPersistence.account((Record)sur);
        }
        catch (InvalidValueException e) {
            this.logger.error("Error sending accounting record: " + String.valueOf(sur), (Throwable)e);
        }
        this.logger.debug("report sent");
        this.logger.trace(sur.toString());
    }

    public void setSuccessResult(StorageUsageRecord sur) {
        try {
            if (sur != null) {
                sur.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            }
        }
        catch (InvalidValueException invalidValueException) {}
    }

    public void setFailureResult(StorageUsageRecord sur) {
        try {
            if (sur != null) {
                sur.setOperationResult(UsageRecord.OperationResult.FAILED);
            }
        }
        catch (InvalidValueException invalidValueException) {}
    }

    public void setSize(StorageUsageRecord sur, Long size) {
        try {
            if (sur != null && size != null) {
                sur.setDataVolume(size.longValue());
            }
        }
        catch (InvalidValueException invalidValueException) {}
    }

    public void setOwner(StorageUsageRecord sur, String owner) {
        try {
            if (sur != null && owner != null) {
                sur.setResourceOwner(owner);
            }
        }
        catch (InvalidValueException invalidValueException) {}
    }

    public void setOperationType(StorageUsageRecord sur, String operation) {
        try {
            if (sur != null && operation != null) {
                sur.setOperationType(this.convertOperation(operation));
            }
        }
        catch (Exception exception) {}
    }

    public void setConsumerId(StorageUsageRecord sur, String consumerId) {
        try {
            if (sur != null && consumerId != null) {
                sur.setConsumerId(consumerId);
            }
        }
        catch (InvalidValueException invalidValueException) {}
    }

    public String getProviderUri() {
        return this.providerURI.toString();
    }
}

