package org.gcube.data.access.storagehub.health;

import javax.jcr.LoginException;
import javax.jcr.Session;

import org.gcube.common.health.api.HealthCheck;
import org.gcube.common.health.api.ReadinessChecker;
import org.gcube.common.health.api.response.HealthCheckResponse;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;

@ReadinessChecker
public class JCRRepositoryCheck implements HealthCheck{
	
	private static final String NAME = "Jackrabbit repository";
	private static final HealthCheckResponse OK;

	static {
		OK = HealthCheckResponse.builder(NAME).up().build();	
	}
	
	@Override
	public String getName() {
		return NAME;
	}

	@Override
	public HealthCheckResponse check() {
		try {
			Session session = StoragehubRepository.repository.getRepository().login();
			if (session != null) session.logout();
			return OK;
		}catch (LoginException e) {	}
		catch(Throwable ex) {
			return HealthCheckResponse.builder(getName()).down().error(ex.getMessage()).build(); 
		}
		return OK;
	}

}
