/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.metadata.Ignore;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceMethodSignature;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.UnshareHandler;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;
import org.gcube.data.access.storagehub.services.Impersonable;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class ItemSharing
extends Impersonable {
    private static final Logger log = LoggerFactory.getLogger(ItemSharing.class);
    private final StoragehubRepository repository = StoragehubRepository.repository;
    @Inject
    AccountingHandler accountingHandler;
    @RequestScoped
    @PathParam(value="id")
    String id;
    @Context
    ServletContext context;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    PathUtil pathUtil;
    @Inject
    UnshareHandler unshareHandler;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Ignore
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    @Path(value="{id}/share")
    public String shareWithMap(@FormParam(value="mapUserPermission") String mapUserPermissionString, @FormParam(value="defaultAccessType") String defaultAccessTypeString) {
        InnerMethodName.set((String)"shareFolder");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                Node sharedFolderNode;
                AccessType defaultAccessType;
                HashMap mapUserPermission;
                try {
                    mapUserPermission = (HashMap)new ObjectMapper().readValue(mapUserPermissionString, HashMap.class);
                }
                catch (Exception exception) {
                    throw new InvalidCallParameters("invalid map passed");
                }
                try {
                    defaultAccessType = AccessType.fromValue((String)defaultAccessTypeString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidCallParameters("invalid default accessType");
                }
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Item item = this.node2Item.getItem(ses.getNodeByIdentifier(this.id), Excludes.ALL);
                if (mapUserPermission == null || mapUserPermission.isEmpty()) {
                    throw new InvalidCallParameters("users is empty");
                }
                Node nodeToShare = ses.getNodeByIdentifier(this.id);
                boolean alreadyShared = false;
                if (!this.node2Item.checkNodeType(nodeToShare, SharedFolder.class)) {
                    sharedFolderNode = this.shareFolder(nodeToShare, ses);
                } else {
                    sharedFolderNode = nodeToShare;
                    alreadyShared = true;
                }
                ses.save();
                try {
                    ses.getWorkspace().getLockManager().lock(sharedFolderNode.getPath(), true, true, 0L, this.currentUser);
                }
                catch (LockException lockException) {
                    throw new ItemLockedException("Cannot share item, the resource is busy. Please retry later");
                }
                try {
                    AccessControlManager acm = ses.getAccessControlManager();
                    JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)sharedFolderNode.getPath());
                    if (!alreadyShared) {
                        Privilege[] adminPrivileges = new Privilege[]{acm.privilegeFromName(AccessType.ADMINISTRATOR.getValue())};
                        this.addUserToSharing(sharedFolderNode, ses, this.currentUser, item, adminPrivileges, acls);
                        mapUserPermission.remove(this.currentUser);
                    }
                    for (Map.Entry entry : mapUserPermission.entrySet()) {
                        try {
                            AccessType accessType = defaultAccessType;
                            try {
                                if (entry.getValue() != null) {
                                    accessType = AccessType.fromValue((String)((String)entry.getValue()));
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                log.warn("an illegal accessType passed to sharing ({})", entry.getValue());
                            }
                            Privilege[] userPrivileges = new Privilege[]{acm.privilegeFromName(accessType.getValue())};
                            this.addUserToSharing(sharedFolderNode, ses, (String)entry.getKey(), null, userPrivileges, acls);
                        }
                        catch (Exception exception) {
                            log.warn("error adding user {} to sharing of folder {}", entry.getKey(), (Object)sharedFolderNode.getName());
                        }
                    }
                    acm.setPolicy(sharedFolderNode.getPath(), (AccessControlPolicy)acls);
                    String title = sharedFolderNode.getProperty(NodeProperty.TITLE.toString()).getString();
                    this.accountingHandler.createShareFolder(title, mapUserPermission.keySet(), ses, sharedFolderNode, this.currentUser, false);
                    ses.save();
                    toReturn = sharedFolderNode.getIdentifier();
                    return toReturn;
                }
                finally {
                    if (!ses.hasPendingChanges()) {
                        ses.getWorkspace().getLockManager().unlock(sharedFolderNode.getPath());
                    }
                }
            }
            catch (RepositoryException re) {
                log.error("jcr sharing", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error sharing folder", (Throwable)re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")}, formParams={@FormParam(value="users"), @FormParam(value="defaultAccessType")})
    @DocumentationExample(value="...\n\n--------boundaryString\nContent-Disposition: form-data; name=\"users\"\n\nuser1\n--------boundaryString\nContent-Disposition: form-data; name=\"users\"\n\nuser2\n--------boundaryString\nContent-Disposition: form-data; name=\"defaultAccessType\"\n\nREAD_ONLY\n------boundaryString--")
    @PUT
    @Path(value="{id}/share")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    public String share(@FormDataParam(value="users") Set<String> users, @FormDataParam(value="defaultAccessType") AccessType accessType) {
        InnerMethodName.set((String)"shareFolder");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                Node sharedFolderNode;
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Item item = this.node2Item.getItem(ses.getNodeByIdentifier(this.id), Excludes.ALL);
                if (accessType == null) {
                    accessType = AccessType.READ_ONLY;
                }
                if (users == null || users.isEmpty()) {
                    throw new InvalidCallParameters("users is empty");
                }
                log.info("shared method called with users {} and default access type {} ", users, (Object)accessType.getValue());
                Node nodeToShare = ses.getNodeByIdentifier(this.id);
                boolean alreadyShared = false;
                if (!this.node2Item.checkNodeType(nodeToShare, SharedFolder.class)) {
                    sharedFolderNode = this.shareFolder(nodeToShare, ses);
                } else {
                    sharedFolderNode = nodeToShare;
                    alreadyShared = true;
                }
                ses.save();
                try {
                    ses.getWorkspace().getLockManager().lock(sharedFolderNode.getPath(), true, true, 0L, this.currentUser);
                }
                catch (LockException lockException) {
                    throw new ItemLockedException("Cannot share item, the resource is busy. please retry later.");
                }
                try {
                    AccessControlManager acm = ses.getAccessControlManager();
                    JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)sharedFolderNode.getPath());
                    if (!alreadyShared) {
                        Privilege[] adminPrivileges = new Privilege[]{acm.privilegeFromName(AccessType.ADMINISTRATOR.getValue())};
                        this.addUserToSharing(sharedFolderNode, ses, this.currentUser, item, adminPrivileges, acls);
                        users.remove(this.currentUser);
                    }
                    Privilege[] userPrivileges = new Privilege[]{acm.privilegeFromName(accessType.getValue())};
                    for (String user : users) {
                        try {
                            this.addUserToSharing(sharedFolderNode, ses, user, null, userPrivileges, acls);
                            log.info("added user {} to the shared node", (Object)user);
                        }
                        catch (Exception e) {
                            log.warn("error adding user {} to sharing of folder {}", new Object[]{user, sharedFolderNode.getName(), e});
                        }
                    }
                    acm.setPolicy(sharedFolderNode.getPath(), (AccessControlPolicy)acls);
                    this.accountingHandler.createShareFolder(sharedFolderNode.getProperty(NodeProperty.TITLE.toString()).getString(), users, ses, sharedFolderNode, this.currentUser, false);
                    ses.save();
                    toReturn = sharedFolderNode.getIdentifier();
                    return toReturn;
                }
                finally {
                    if (!ses.hasPendingChanges()) {
                        ses.getWorkspace().getLockManager().unlock(sharedFolderNode.getPath());
                    }
                }
            }
            catch (RepositoryException re) {
                log.error("jcr sharing", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error sharing folder", (Throwable)re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (Exception e) {
                log.error("jcr sharing", (Throwable)e);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error sharing folder", (Throwable)e));
                if (ses == null) return toReturn;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    private Node shareFolder(Node node, Session ses) throws RepositoryException, BackendGenericError, StorageHubException {
        if (!this.node2Item.checkNodeType(node, FolderItem.class) || Utils.hasSharedChildren((Node)node) || !node.getProperty(NodeProperty.PORTAL_LOGIN.toString()).getString().equals(this.currentUser)) {
            throw new InvalidItemException("item with id " + this.id + " cannot be shared");
        }
        String sharedFolderName = node.getIdentifier();
        String newNodePath = "/Share/" + sharedFolderName;
        ses.move(node.getPath(), newNodePath);
        Node sharedFolderNode = ses.getNode(newNodePath);
        sharedFolderNode.setPrimaryType("nthl:workspaceSharedItem");
        return sharedFolderNode;
    }

    private void addUserToSharing(Node sharedFolderNode, Session ses, String user, Item itemToShare, Privilege[] userPrivileges, JackrabbitAccessControlList acls) throws RepositoryException {
        try {
            String userPath;
            String userRootWSId;
            if (itemToShare == null) {
                String userRootWS = this.pathUtil.getWorkspacePath(user).toPath();
                userRootWSId = ses.getNode(userRootWS).getIdentifier();
                userPath = String.format("%s%s", userRootWS, sharedFolderNode.getProperty(NodeProperty.TITLE.toString()).getString());
            } else {
                userPath = itemToShare.getPath();
                userRootWSId = itemToShare.getParentId();
            }
            log.info("cloning directory to {} ", (Object)userPath);
            ses.getWorkspace().clone(ses.getWorkspace().getName(), sharedFolderNode.getPath(), userPath, false);
            acls.addAccessControlEntry(AccessControlUtils.getPrincipal((Session)ses, (String)user), userPrivileges);
            Node usersNode = null;
            usersNode = sharedFolderNode.hasNode("hl:users") ? sharedFolderNode.getNode("hl:users") : sharedFolderNode.addNode("hl:users");
            usersNode.setProperty(user, String.format("%s/%s", userRootWSId, sharedFolderNode.getProperty(NodeProperty.TITLE.toString()).getString()));
        }
        catch (Exception e) {
            log.error("error sharing node with user {}", (Object)user, (Object)e);
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")}, formParams={@FormParam(value="users")})
    @DocumentationExample(value="...\n\n--------boundaryString\nContent-Disposition: form-data; name=\"users\"\n\nuser1,user2,user3\n--------boundaryString--")
    @PUT
    @Path(value="{id}/unshare")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    public String unshare(@FormDataParam(value="users") Set<String> users) {
        InnerMethodName.set((String)"unshareFolder");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                log.debug("unsharing folder with id {} with users {}", (Object)this.id, users);
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                Node sharedNode = ses.getNodeByIdentifier(this.id);
                toReturn = this.unshareHandler.unshare(ses, users, sharedNode, this.currentUser);
                if (toReturn != null) return toReturn;
                throw new InvalidItemException("item with id " + this.id + " cannot be unshared");
            }
            catch (RepositoryException re) {
                log.error("jcr unsharing", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error extracting archive", (Throwable)re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }
}

