/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.repository;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackrabbitRepositoryImpl
implements StoragehubRepository {
    private static final Logger log = LoggerFactory.getLogger(JackrabbitRepositoryImpl.class);
    private Repository repository;
    private boolean jackrabbitInitialized = false;

    public JackrabbitRepositoryImpl() {
        try {
            InitialContext context = new InitialContext();
            Context environment = (Context)context.lookup("java:comp/env");
            this.repository = (Repository)environment.lookup("jcr/repository");
        }
        catch (Throwable e) {
            log.error("error initializing repository", e);
            throw new RuntimeException("error initializing repository", e);
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public synchronized void initContainerAtFirstStart() {
        try {
            JackrabbitSession ses = (JackrabbitSession)this.repository.login((Credentials)Constants.JCR_CREDENTIALS);
            try {
                boolean notAlreadyDone;
                boolean bl = notAlreadyDone = !this.jackrabbitInitialized && !ses.getRootNode().hasNode("Home");
                if (notAlreadyDone) {
                    this.init(ses);
                } else {
                    log.info("jackrabbit is already initialized");
                }
            }
            finally {
                ses.logout();
            }
        }
        catch (Exception e) {
            log.warn("error initialising Jackrabbit", (Throwable)e);
        }
        this.jackrabbitInitialized = true;
    }

    public void shutdown() {
        ((JackrabbitRepository)this.repository).shutdown();
    }

    public void init(JackrabbitSession ses) throws Exception {
        log.info("init started");
        try {
            this.initNodeTypes((Session)ses);
            ses.getRootNode().addNode("Home");
            ses.getRootNode().addNode("Share");
            PrivilegeManager pm = ((JackrabbitWorkspace)ses.getWorkspace()).getPrivilegeManager();
            pm.registerPrivilege("hl:writeAll", false, new String[0]);
            ses.save();
        }
        catch (Exception e) {
            log.error("init error", (Throwable)e);
            throw e;
        }
        log.info("init finished");
    }

    void initNodeTypes(Session ses) throws Exception {
        NodeType[] nodeTypes;
        InputStream stream = this.getClass().getResourceAsStream("/init/NodeType.cnd");
        if (stream == null) {
            throw new Exception("NodeType.cnd inputStream is null");
        }
        InputStreamReader inputstream = new InputStreamReader(stream, Charset.forName("UTF-8"));
        log.info("start to register the custom node types defined in the CND file...");
        NodeType[] nodeTypeArray = nodeTypes = CndImporter.registerNodeTypes((Reader)inputstream, (Session)ses, (boolean)true);
        int n = nodeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeType nt = nodeTypeArray[n2];
            log.info("Registered: {} ", (Object)nt.getName());
            ++n2;
        }
        log.info("custom node types registered");
    }
}

