/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.metadata.Ignore;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceMethodSignature;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.compress.archivers.ArchiveException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.gcube.common.authorization.control.AuthorizationAspect;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.GCubeItem;
import org.gcube.common.storagehub.model.plugins.PluginParameters;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.StorageHubApplicationManager;
import org.gcube.data.access.storagehub.handlers.items.ItemHandler;
import org.gcube.data.access.storagehub.handlers.items.builders.ArchiveStructureCreationParameter;
import org.gcube.data.access.storagehub.handlers.items.builders.CreateParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.FileCreationParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.FolderCreationParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.GCubeItemCreationParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.ItemsParameterBuilder;
import org.gcube.data.access.storagehub.handlers.items.builders.URLCreationParameters;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;
import org.gcube.data.access.storagehub.services.Impersonable;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="items")
@ManagedBy(value=StorageHubApplicationManager.class)
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class ItemsCreator
extends Impersonable {
    private static final Logger log;
    @Context
    ServletContext context;
    private final StoragehubRepository repository = StoragehubRepository.repository;
    @Inject
    ItemHandler itemHandler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        ItemsCreator.ajc$preClinit();
        log = LoggerFactory.getLogger(ItemsCreator.class);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")}, formParams={@FormParam(value="name"), @FormParam(value="description"), @FormParam(value="hidden")})
    @DocumentationExample(value=" ...\n\nname=sampleFolder&description=This+is+a+sample+folder&hidden=false")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Folder created."), @ResponseCode(code=400, condition="Wrong set of parameters."), @ResponseCode(code=415, condition="Wrong content type.")})
    @Path(value="/{id}/create/FOLDER")
    public Response createFolder(@PathParam(value="id") String id, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="hidden") boolean hidden) {
        InnerMethodName.set((String)"createItem(FOLDER)");
        log.info("create folder item called");
        Session ses = null;
        String toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            ItemsParameterBuilder builder = FolderCreationParameters.builder().name(name).description(description).hidden(hidden).on(id).with(ses).author(this.currentUser);
            toReturn = this.itemHandler.create((CreateParameters)((FolderCreationParameters)builder.build()));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return Response.ok(toReturn).build();
            ses.logout();
            return Response.ok(toReturn).build();
        }
        catch (RepositoryException re) {
            log.error("jcr error creating item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
            return Response.ok(toReturn).build();
        }
        catch (Throwable e) {
            log.error("unexpected error", e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
            if (ses == null) return Response.ok(toReturn).build();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return Response.ok(toReturn).build();
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return Response.ok(toReturn).build();
        ses.logout();
        return Response.ok(toReturn).build();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Ignore
    @POST
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{id}/create/EXTERNALFOLDER")
    public Response createExternalFolder(@PathParam(value="id") String id, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="hidden") boolean hidden, @FormParam(value="pluginName") String pluginName, @Context HttpServletRequest request) {
        String string = id;
        String string2 = name;
        String string3 = description;
        boolean bl = hidden;
        String string4 = pluginName;
        HttpServletRequest httpServletRequest = request;
        Object[] objectArray = new Object[]{string, string2, string3, Conversions.booleanObject((boolean)bl), string4, httpServletRequest};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.set((String)"createItem(EXTERNALFOLDER)");
        log.info("create folder item called");
        Session ses = null;
        String toReturn = null;
        try {
            Iterator paramIt = request.getParameterNames().asIterator();
            Iterable iterable = () -> paramIt;
            Stream<String> targetStream = StreamSupport.stream(iterable.spliterator(), false);
            PluginParameters pluginParams = new PluginParameters();
            targetStream.filter(v -> v.startsWith("plugin.")).forEach(v -> pluginParams.add(v.replace("plugin.", ""), request.getParameter(v)));
            log.debug("parameters for external folder with plugin {} are {}", (Object)pluginName, (Object)pluginParams.toString());
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            ItemsParameterBuilder builder = FolderCreationParameters.builder().name(name).description(description).onRepository(pluginName).withParameters(pluginParams.getParameters()).hidden(hidden).on(id).with(ses).author(this.currentUser);
            toReturn = this.itemHandler.create((CreateParameters)((FolderCreationParameters)builder.build()));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return Response.ok(toReturn).build();
            ses.logout();
            return Response.ok(toReturn).build();
        }
        catch (RepositoryException re) {
            log.error("jcr error creating item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
            return Response.ok(toReturn).build();
        }
        catch (Throwable e) {
            log.error("unexpected error", e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
            if (ses == null) return Response.ok(toReturn).build();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return Response.ok(toReturn).build();
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return Response.ok(toReturn).build();
        ses.logout();
        return Response.ok(toReturn).build();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DocumentationExample(value=" ...\n\nname=d4science&description=D4Science+URL&value=www.d4science.org")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="URL created."), @ResponseCode(code=400, condition="Wrong set of parameters."), @ResponseCode(code=406, condition="Unable to create URL."), @ResponseCode(code=415, condition="Wrong content type.")})
    @Path(value="/{id}/create/URL")
    public Response createURL(@PathParam(value="id") String id, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="value") URL value) {
        InnerMethodName.set((String)"createItem(URL)");
        log.info("create url called");
        Session ses = null;
        String toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            ItemsParameterBuilder builder = URLCreationParameters.builder().name(name).description(description).url(value).on(id).with(ses).author(this.currentUser);
            toReturn = this.itemHandler.create((CreateParameters)((URLCreationParameters)builder.build()));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return Response.ok(toReturn).build();
            ses.logout();
            return Response.ok(toReturn).build();
        }
        catch (RepositoryException re) {
            log.error("jcr error creating item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
            return Response.ok(toReturn).build();
        }
        catch (Throwable e) {
            log.error("unexpected error", e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
            if (ses == null) return Response.ok(toReturn).build();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return Response.ok(toReturn).build();
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return Response.ok(toReturn).build();
        ses.logout();
        return Response.ok(toReturn).build();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Ignore
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/create/GCUBEITEM")
    public String createGcubeItem(@PathParam(value="id") String id, GCubeItem item) {
        InnerMethodName.set((String)"createItem(GCUBEITEM)");
        log.info("create Gcube item called");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                ItemsParameterBuilder builder = GCubeItemCreationParameters.builder().item(item).on(id).with(ses).author(this.currentUser);
                toReturn = this.itemHandler.create((CreateParameters)((GCubeItemCreationParameters)builder.build()));
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (Throwable e) {
                log.error("unexpected error", e);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
                if (ses == null) return toReturn;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Loose catch block
     */
    @DocumentationExample(value=" ...\n\nname=d4science_logo.png&description=D4Science+logo&url=\"https://www.d4science.org/image/layout_set_logo?img_id=12630&t=1720538711657\"")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="File created."), @ResponseCode(code=400, condition="Wrong set of parameters."), @ResponseCode(code=406, condition="Unable to create file."), @ResponseCode(code=415, condition="Wrong content type.")})
    @Path(value="/{id}/create/FILE")
    public String createFileItemFromUrl(@PathParam(value="id") String id, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="url") String url) {
        InnerMethodName.set((String)"createItem(FILEFromUrl)");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                log.debug("UPLOAD: call started");
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                URLConnection connectionURL = new URI(url).toURL().openConnection();
                long fileLength = connectionURL.getContentLengthLong();
                Throwable throwable = null;
                Object var11_14 = null;
                try (InputStream stream = connectionURL.getInputStream();){
                    ItemsParameterBuilder builder = FileCreationParameters.builder().name(name).fileDetails(((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)name).size(fileLength)).build()).description(description).stream(stream).on(id).with(ses).author(this.currentUser);
                    toReturn = this.itemHandler.create((CreateParameters)((FileCreationParameters)builder.build()));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                log.debug("UPLOAD: call finished");
            }
            catch (RepositoryException re) {
                log.error("jcr error creating file item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating file item", (Throwable)re));
                if (ses != null && ses.isLive()) {
                    log.info("session closed");
                    ses.logout();
                }
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses != null && ses.isLive()) {
                    log.info("session closed");
                    ses.logout();
                }
            }
            catch (Throwable e) {
                log.error("unexpected error", e);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                if (ses != null && ses.isLive()) {
                    log.info("session closed");
                    ses.logout();
                }
            }
        }
        finally {
            if (ses != null && ses.isLive()) {
                log.info("session closed");
                ses.logout();
            }
        }
        return toReturn;
    }

    /*
     * Loose catch block
     */
    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")}, formParams={@FormParam(value="name"), @FormParam(value="description"), @FormParam(value="file")})
    @DocumentationExample(value="...\n\n--------boundaryString\nContent-Disposition: form-data; name=\"file\"; filename=\"doc.pdf\"; size=426018;\nContent-Type: application/pdf\n\n(data)\n--------boundaryString\nContent-Disposition: form-data; name=\"name\"\n\ndoc.pdf\n--------boundaryString\nContent-Disposition: form-data; name=\"description\"\n\n\"This is just a sample PDF file\"\n--------boundaryString--")
    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="File created."), @ResponseCode(code=400, condition="Wrong set of parameters."), @ResponseCode(code=406, condition="Unable to create file."), @ResponseCode(code=415, condition="Wrong content type.")})
    @Path(value="/{id}/create/FILE")
    public String createFileItem(@PathParam(value="id") String id, @FormDataParam(value="name") String name, @FormDataParam(value="description") String description, @FormDataParam(value="file") InputStream file, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        InnerMethodName.set((String)"createItem(FILE)");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                Throwable throwable = null;
                Object var9_13 = null;
                try (BufferedInputStream is = new BufferedInputStream(file);){
                    long size = fileDetail.getSize();
                    log.info("UPLOAD: call started with file size {}", (Object)size);
                    ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                    ItemsParameterBuilder builder = FileCreationParameters.builder().name(name).description(description).stream(file).fileDetails(fileDetail).on(id).with(ses).author(this.currentUser);
                    log.debug("UPLOAD: item prepared");
                    toReturn = this.itemHandler.create((CreateParameters)((FileCreationParameters)builder.build()));
                    log.debug("UPLOAD: call finished");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error creating file item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating file item", (Throwable)re));
                if (ses != null && ses.isLive()) {
                    log.info("session closed");
                    ses.logout();
                }
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses != null && ses.isLive()) {
                    log.info("session closed");
                    ses.logout();
                }
            }
            catch (Throwable e) {
                log.error("unexpected error", e);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                if (ses != null && ses.isLive()) {
                    log.info("session closed");
                    ses.logout();
                }
            }
        }
        finally {
            if (ses != null && ses.isLive()) {
                log.info("session closed");
                ses.logout();
            }
        }
        return toReturn;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DocumentationExample(value=" ...\n\nname=sampleZip.zip&description=This+is+a+sample+zip&url=\"https://getsamplefiles.com/download/zip/sample-1.zip\"")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Archive extracted."), @ResponseCode(code=400, condition="Wrong set of parameters."), @ResponseCode(code=406, condition="Unable to extract archive."), @ResponseCode(code=415, condition="Wrong content type.")})
    @Path(value="/{id}/create/ARCHIVE")
    public String uploadArchiveFromURL(@PathParam(value="id") String id, @FormParam(value="parentFolderName") String parentFolderName, @FormParam(value="url") String url) {
        InnerMethodName.set((String)"createItem(ARCHIVEFromURL)");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                Throwable throwable = null;
                Object var7_11 = null;
                try (InputStream stream = new URI(url).toURL().openStream();){
                    ItemsParameterBuilder builder = ArchiveStructureCreationParameter.builder().parentName(parentFolderName).stream(stream).on(id).with(ses).author(this.currentUser);
                    toReturn = this.itemHandler.create((CreateParameters)((ArchiveStructureCreationParameter)builder.build()));
                    return toReturn;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    } else {
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | RepositoryException | ArchiveException re) {
                log.error("jcr error extracting archive", re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error extracting archive", re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (Throwable e) {
                log.error("unexpected error", e);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
                if (ses == null) return toReturn;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")}, formParams={@FormParam(value="parentFolderName"), @FormParam(value="file")})
    @DocumentationExample(value="...\n\n--------boundaryString\nContent-Disposition: form-data; name=\"file\"; filename=\"archive.zip\"; size=1560238;\nContent-Type: application/zip\n\n(compressed data)\n--------boundaryString\nContent-Disposition: form-data; name=\"parentFolderName=\"\n\nmy documents\n--------boundaryString--")
    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Archive extracted."), @ResponseCode(code=400, condition="Wrong set of parameters."), @ResponseCode(code=406, condition="Unable to extract archive."), @ResponseCode(code=415, condition="Wrong content type.")})
    @Path(value="/{id}/create/ARCHIVE")
    public String uploadArchive(@PathParam(value="id") String id, @FormDataParam(value="parentFolderName") String parentFolderName, @FormDataParam(value="file") InputStream file, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        InnerMethodName.set((String)"createItem(ARCHIVE)");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                Throwable throwable = null;
                Object var8_12 = null;
                try (BufferedInputStream is = new BufferedInputStream(file);){
                    ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                    ItemsParameterBuilder builder = ArchiveStructureCreationParameter.builder().parentName(parentFolderName).stream((InputStream)is).fileDetails(fileDetail).on(id).with(ses).author(this.currentUser);
                    toReturn = this.itemHandler.create((CreateParameters)((ArchiveStructureCreationParameter)builder.build()));
                    return toReturn;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    } else {
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | RepositoryException | ArchiveException re) {
                log.error("jcr error extracting archive", re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error extracting archive", re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (Throwable e) {
                log.error("unexpected error", e);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
                if (ses == null) return toReturn;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ItemsCreator.java", ItemsCreator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createExternalFolder", "org.gcube.data.access.storagehub.services.ItemsCreator", "java.lang.String:java.lang.String:java.lang.String:boolean:java.lang.String:jakarta.servlet.http.HttpServletRequest", "id:name:description:hidden:pluginName:request", "", "jakarta.ws.rs.core.Response"), 140);
    }
}

