/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services.delegates;

import jakarta.inject.Inject;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.NotFoundException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.types.SHUBUser;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.UnshareHandler;
import org.gcube.data.access.storagehub.handlers.items.builders.FolderCreationParameters;
import org.gcube.data.access.storagehub.predicates.IncludeTypePredicate;
import org.gcube.data.access.storagehub.predicates.ItemTypePredicate;
import org.gcube.data.access.storagehub.services.delegates.GroupManagerDelegate;
import org.gcube.data.access.storagehub.services.delegates.UserManagerDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagerDelegate {
    private static final Logger log = LoggerFactory.getLogger(UserManagerDelegate.class);
    @Inject
    UnshareHandler unshareHandler;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    TrashHandler trashHandler;
    @Inject
    GroupManagerDelegate groupHandler;
    @Inject
    PathUtil pathUtil;

    public List<SHUBUser> getAllUsers(JackrabbitSession session) throws RepositoryException {
        Iterator result = session.getUserManager().findAuthorizables((Query)new /* Unavailable Anonymous Inner Class!! */);
        HashSet<SHUBUser> usersSet = new HashSet<SHUBUser>();
        String adminUser = "admin";
        Node homeNode = session.getNode("/Home");
        while (result.hasNext()) {
            Authorizable user = (Authorizable)result.next();
            log.debug("user {} found", (Object)user.getPrincipal().getName());
            if (user.getPrincipal().getName().equals(adminUser)) continue;
            long homeVersion = -1L;
            try {
                Node userHome = homeNode.getNode(user.getPrincipal().getName());
                homeVersion = userHome.hasProperty("hl:version") ? userHome.getProperty("hl:version").getLong() : 0L;
                usersSet.add(new SHUBUser(user.getPrincipal().getName(), homeVersion));
            }
            catch (Exception exception) {
                log.warn("error retrieving user {} home", (Object)user.getPrincipal().getName());
            }
        }
        ArrayList<SHUBUser> users = new ArrayList<SHUBUser>(usersSet);
        Collections.sort(new ArrayList(usersSet));
        return users;
    }

    public SHUBUser getUser(JackrabbitSession session, String userId) throws StorageHubException, RepositoryException {
        Authorizable user = session.getUserManager().getAuthorizable(userId);
        if (user != null && !user.isGroup()) {
            Node homeNode = session.getNode("/Home");
            long homeVersion = -1L;
            try {
                Node userHome = homeNode.getNode(user.getPrincipal().getName());
                homeVersion = userHome.hasProperty("hl:version") ? userHome.getProperty("hl:version").getLong() : 0L;
                return new SHUBUser(user.getPrincipal().getName(), homeVersion);
            }
            catch (Exception exception) {
                log.warn("error retrieving user {} home", (Object)user.getPrincipal().getName());
                throw new BackendGenericError("error retrieving user home");
            }
        }
        throw new NotFoundException("user", userId);
    }

    public String createUser(JackrabbitSession session, String user, String password) throws StorageHubException, RepositoryException {
        UserManager usrManager = session.getUserManager();
        User createdUser = usrManager.createUser(user, password);
        String userId = createdUser.getID();
        Node homeNode = session.getNode("/Home");
        Node userHome = homeNode.addNode(user, "nthl:home");
        userHome.setProperty("hl:version", 1L);
        FolderCreationParameters wsFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("Workspace").description("workspace of " + user).author(user).on(userHome.getIdentifier()).with((Session)session).build();
        Utils.createFolderInternally((FolderCreationParameters)wsFolderParameters, null, (boolean)true);
        FolderCreationParameters trashFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("Trash").description("trash of " + user).author(user).on(userHome.getIdentifier()).with((Session)session).build();
        Utils.createFolderInternally((FolderCreationParameters)trashFolderParameters, null, (boolean)true);
        FolderCreationParameters vreFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("VREs").description("vre folder container of " + user).author(user).on(userHome.getIdentifier()).with((Session)session).build();
        Utils.createFolderInternally((FolderCreationParameters)vreFolderParameters, null, (boolean)true);
        FolderCreationParameters inboxFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("InBox").description("inbox of " + user).author(user).on(userHome.getIdentifier()).with((Session)session).build();
        Utils.createFolderInternally((FolderCreationParameters)inboxFolderParameters, null, (boolean)true);
        FolderCreationParameters outboxFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("OutBox").description("outbox of " + user).author(user).on(userHome.getIdentifier()).with((Session)session).build();
        Utils.createFolderInternally((FolderCreationParameters)outboxFolderParameters, null, (boolean)true);
        return userId;
    }

    public String updateHomeUserToLatestVersion(JackrabbitSession session, String user) throws StorageHubException, RepositoryException {
        UserManager usrManager = session.getUserManager();
        Authorizable auth = usrManager.getAuthorizable(user);
        if (auth == null || auth.isGroup()) {
            throw new InvalidCallParameters("invalid user passed");
        }
        Node homeNode = session.getNode("/Home");
        Node userHome = homeNode.getNode(user);
        if (userHome == null) {
            throw new BackendGenericError("home for user {} not found");
        }
        if (!userHome.hasProperty("hl:version") || userHome.getProperty("hl:version").getLong() < 1L) {
            Path workspacePath = Paths.append((Path)Paths.getPath((String)userHome.getPath()), (String)"Workspace");
            Boolean oldTrashExists = session.nodeExists(Paths.append((Path)workspacePath, (String)"Trash").toPath());
            if (oldTrashExists.booleanValue()) {
                session.move(Paths.append((Path)workspacePath, (String)"Trash").toPath(), Paths.append((Path)Paths.getPath((String)userHome.getPath()), (String)"Trash").toPath());
            } else {
                FolderCreationParameters trashFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("Trash").description("trash of " + user).author(user).on(userHome.getIdentifier()).with((Session)session).build();
                Utils.createFolderInternally((FolderCreationParameters)trashFolderParameters, null, (boolean)true);
            }
            Boolean oldVresExists = session.nodeExists(Paths.append((Path)workspacePath, (String)"MySpecialFolders").toPath());
            if (oldVresExists.booleanValue()) {
                session.move(Paths.append((Path)workspacePath, (String)"MySpecialFolders").toPath(), Paths.append((Path)Paths.getPath((String)userHome.getPath()), (String)"VREs").toPath());
            } else {
                FolderCreationParameters vreFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("VREs").description("vre folder container of " + user).author(user).on(userHome.getIdentifier()).with((Session)session).build();
                Utils.createFolderInternally((FolderCreationParameters)vreFolderParameters, null, (boolean)true);
            }
        }
        userHome.setProperty("hl:version", 1L);
        return user;
    }

    public String deleteUser(JackrabbitSession session, String user) throws StorageHubException, RepositoryException {
        UserManager usrManager = session.getUserManager();
        User authorizable = (User)usrManager.getAuthorizable((Principal)new PrincipalImpl(user));
        if (authorizable != null) {
            this.removeUserFromBelongingGroup(session, authorizable, usrManager);
        } else {
            log.warn("user was already deleted from jackrabbit, trying to delete folders");
        }
        this.unshareUsersFolders(session, user);
        this.removeUserHomeAndDeleteFiles(session, user);
        if (authorizable != null && !authorizable.isGroup()) {
            log.info("removing user {}", (Object)user);
            authorizable.remove();
        } else {
            log.warn("the user {} was already deleted, it should never happen", (Object)user);
        }
        return user;
    }

    public List<String> getGroupsPerUser(JackrabbitSession session, String user) throws RepositoryException {
        ArrayList<String> groups = new ArrayList<String>();
        UserManager usrManager = session.getUserManager();
        User authUser = (User)usrManager.getAuthorizable((Principal)new PrincipalImpl(user));
        Iterator groupsAuth = authUser.memberOf();
        while (groupsAuth.hasNext()) {
            Authorizable group = (Authorizable)groupsAuth.next();
            groups.add(group.getPrincipal().getName());
        }
        return groups;
    }

    private void removeUserFromBelongingGroup(JackrabbitSession session, User authorizable, UserManager usrManager) throws RepositoryException, StorageHubException {
        Iterator groups = session.getUserManager().findAuthorizables((Query)new /* Unavailable Anonymous Inner Class!! */);
        String user = authorizable.getPrincipal().getName();
        while (groups.hasNext()) {
            Authorizable group = (Authorizable)groups.next();
            log.info("group found {}", (Object)group.getPrincipal().getName());
            if (!group.isGroup() || !((Group)group).isMember((Authorizable)authorizable)) continue;
            boolean success = this.groupHandler.removeUserFromGroup(session, group.getPrincipal().getName(), user);
            log.warn("user {} {} removed from vre {}", new Object[]{user, success ? "" : "not", group.getPrincipal().getName()});
        }
    }

    private void unshareUsersFolders(JackrabbitSession session, String user) {
        try {
            Node sharedFolderNode = session.getNode("/Share");
            3 sharedWithUserChecker = new /* Unavailable Anonymous Inner Class!! */;
            IncludeTypePredicate itemPredicate = new IncludeTypePredicate(SharedFolder.class);
            List items = Utils.getItemList((Predicate)sharedWithUserChecker, (Node)sharedFolderNode, (List)Excludes.ALL, null, (boolean)false, (ItemTypePredicate)itemPredicate);
            log.debug(" Shared folder to unshare found are {}", (Object)items.size());
            for (SharedFolder item : items) {
                String title = item.getTitle();
                log.debug("in list folder name {} with title {} and path {} ", new Object[]{item.getName(), title, item.getPath()});
                if (item.isPublicItem() && !item.getUsers().getMap().containsKey(user) || item.isVreFolder()) continue;
                log.info("removing sharing for folder name {} with title {} and path {} ", new Object[]{item.getName(), title, item.getPath()});
                String owner = item.getOwner();
                Set<Object> usersToUnshare = owner.equals(user) ? Collections.emptySet() : Collections.singleton(user);
                try {
                    this.unshareHandler.unshareForRemoval((Session)session, usersToUnshare, session.getNodeByIdentifier(item.getId()), user);
                }
                catch (Throwable e) {
                    log.warn("error unsharing folder with title '{}' and id {} ", new Object[]{title, item.getId(), e});
                }
            }
        }
        catch (Throwable t) {
            log.warn("error getting folder shared with {}", (Object)user, (Object)t);
        }
    }

    private void removeUserHomeAndDeleteFiles(JackrabbitSession session, String user) throws RepositoryException, StorageHubException {
        Path homePath = this.pathUtil.getHome(user);
        Path workspacePath = this.pathUtil.getWorkspacePath(user);
        try {
            Node workspaceNode = session.getNode(workspacePath.toPath());
            List workspaceItems = Utils.getItemList((Node)workspaceNode, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, null).stream().filter(i -> !i.isShared()).collect(Collectors.toList());
            this.trashHandler.removeOnlyNodesContent((Session)session, workspaceItems);
        }
        catch (PathNotFoundException pathNotFoundException) {
            log.warn("{} workspace dir {} was already deleted", (Object)user, (Object)homePath.toPath());
        }
        try {
            Path trashPath = this.pathUtil.getTrashPath(user, (Session)session);
            Node trashNode = session.getNode(trashPath.toPath());
            List trashItems = Utils.getItemList((Node)trashNode, (List)Excludes.ALL, null, (boolean)true, null);
            this.trashHandler.removeOnlyNodesContent((Session)session, trashItems);
        }
        catch (PathNotFoundException pathNotFoundException) {
            log.warn("{} trash dir {} was already deleted", (Object)user, (Object)homePath.toPath());
        }
        try {
            Node homeNode = session.getNode(homePath.toPath());
            homeNode.remove();
        }
        catch (PathNotFoundException pathNotFoundException) {
            log.warn("{} home dir {} was already deleted", (Object)user, (Object)homePath.toPath());
        }
    }
}

