/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.storage.backend.impl;

import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.storagehub.model.exceptions.StorageIdNotFoundException;
import org.gcube.common.storagehub.model.items.nodes.Content;
import org.gcube.common.storagehub.model.items.nodes.PayloadBackend;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeMongoStorageBackend
extends StorageBackend {
    private static final Logger log = LoggerFactory.getLogger(GCubeMongoStorageBackend.class);
    private static final String SERVICE_NAME = "home-library";
    private static final String SERVICE_CLASS = "org.gcube.portlets.user";

    public GCubeMongoStorageBackend(PayloadBackend payloadConf) {
        super(payloadConf);
    }

    public InputStream download(Content content) throws StorageIdNotFoundException {
        return this.download(content.getStorageId());
    }

    public InputStream download(String id) throws StorageIdNotFoundException {
        IClient storageClient = this.getStorageClient(SecretManagerProvider.get().getOwner().getId()).getClient();
        if (!storageClient.exist().RFile(id)) {
            throw new StorageIdNotFoundException(id, this.getPayloadConfiguration().getStorageName());
        }
        return storageClient.get().RFileAsInputStream(id);
    }

    protected StorageClient getStorageClient(String login) {
        return new StorageClient(SERVICE_CLASS, SERVICE_NAME, login, AccessType.SHARED, MemoryType.PERSISTENT);
    }

    public MetaInfo onCopy(Content content, String newParentPath, String newName) {
        log.info("copying storage Id {} to newPath {}", (Object)content.getStorageId(), (Object)newParentPath);
        String newRemotePath = Paths.get(newParentPath, newName).toString();
        String newStorageID = this.getStorageClient(SecretManagerProvider.get().getOwner().getId()).getClient().copyFile(true).from(content.getStorageId()).to(newRemotePath);
        log.info("The id returned by storage is {}", (Object)newStorageID);
        return new MetaInfo(content.getSize().longValue(), newStorageID, newRemotePath, this.getPayloadConfiguration());
    }

    public MetaInfo onMove(Content content, String newParentPath) {
        return new MetaInfo(content.getSize().longValue(), content.getStorageId(), content.getRemotePath(), this.getPayloadConfiguration());
    }

    public MetaInfo upload(InputStream stream, String relPath, String name, String user) {
        log.debug("uploading file");
        IClient storageClient = this.getStorageClient(user).getClient();
        String uid = UUID.randomUUID().toString();
        String remotePath = String.format("%s/%s-%s", relPath, uid, name);
        String storageId = storageClient.put(true).LFile(stream).RFile(remotePath);
        long size = storageClient.getSize().RFileById(storageId);
        MetaInfo info = new MetaInfo(size, storageId, remotePath, this.getPayloadConfiguration());
        return info;
    }

    public MetaInfo upload(InputStream stream, String relPath, String name, Long size, String user) {
        return this.upload(stream, relPath, name, user);
    }

    public MetaInfo upload(InputStream stream, String relativePath, String name, String storageId, Long size, String user) {
        throw new UnsupportedOperationException();
    }

    public void delete(String storageId) {
        log.debug("deleting object {} ", (Object)storageId);
        IClient storageClient = this.getStorageClient(SecretManagerProvider.get().getOwner().getId()).getClient();
        storageClient.remove().RFileById(storageId);
    }

    public String getTotalSizeStored() {
        IClient storageClient = this.getStorageClient(SecretManagerProvider.get().getOwner().getId()).getClient();
        return storageClient.getTotalUserVolume();
    }

    public String getTotalItemsCount() {
        IClient storageClient = this.getStorageClient(SecretManagerProvider.get().getOwner().getId()).getClient();
        return storageClient.getUserTotalItems();
    }

    public Map<String, String> getFileMetadata(String id) {
        return Collections.emptyMap();
    }
}

