/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services.delegates;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.gcube.common.security.ContextBean;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.acls.ACL;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.NotFoundException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.items.builders.FolderCreationParameters;
import org.gcube.data.access.storagehub.services.GroupManager;
import org.gcube.data.access.storagehub.services.interfaces.ACLManagerInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GroupManagerDelegate {
    private static final Logger log = LoggerFactory.getLogger(GroupManager.class);
    @Inject
    PathUtil pathUtil;
    @Inject
    TrashHandler trashHandler;
    @Inject
    ACLManagerInterface aclManagerDelegate;

    public List<String> getGroups(JackrabbitSession session) throws RepositoryException {
        ArrayList<String> groups = new ArrayList<String>();
        Iterator result = session.getUserManager().findAuthorizables((Query)new /* Unavailable Anonymous Inner Class!! */);
        while (result.hasNext()) {
            Authorizable group = (Authorizable)result.next();
            log.info("group {} found", (Object)group.getPrincipal().getName());
            groups.add(group.getPrincipal().getName());
        }
        return groups;
    }

    public void createGroup(JackrabbitSession session, String groupId, AccessType accessType, String folderOwner, boolean useDefaultStorage) throws StorageHubException, Throwable {
        log.info("create group called with groupid {} , accessType {} and folderOwner {}", new Object[]{groupId, accessType, folderOwner});
        UserManager usrManager = session.getUserManager();
        Group createdGroup = usrManager.createGroup(groupId);
        User user = (User)usrManager.getAuthorizable(folderOwner);
        this.createVreFolder(session, groupId, accessType != null ? accessType : AccessType.WRITE_OWNER, folderOwner, useDefaultStorage);
        boolean success = this.internalAddUserToGroup(session, createdGroup, user);
        if (!success) {
            log.warn("the user have not been added to the group");
        } else {
            log.debug("the user have been added to the group");
        }
    }

    public void deleteGroup(JackrabbitSession session, String group) throws RepositoryException {
        UserManager usrManager = session.getUserManager();
        Authorizable authorizable = usrManager.getAuthorizable(group);
        if (authorizable != null && authorizable.isGroup()) {
            authorizable.remove();
        }
        try {
            Node node = this.getFolderNodeRelatedToGroup(session, group);
            List workspaceItems = Utils.getItemList((Node)node, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, null);
            this.trashHandler.removeOnlyNodesContent((Session)session, workspaceItems);
            node.removeSharedSet();
        }
        catch (Exception exception) {
            log.warn("vreFolder {} not found, removing only the group", (Object)group);
        }
    }

    public void addAdministratorToGroup(JackrabbitSession session, String groupId, String userId) throws StorageHubException, Throwable {
        Objects.nonNull(groupId);
        Objects.nonNull(userId);
        Node vreFolder = this.getFolderNodeRelatedToGroup(session, groupId);
        UserManager usrManager = session.getUserManager();
        Group group = (Group)usrManager.getAuthorizable(groupId);
        User authUser = (User)usrManager.getAuthorizable(userId);
        if (group == null) {
            throw new NotFoundException("group", groupId);
        }
        if (authUser == null) {
            throw new NotFoundException("user", userId);
        }
        if (!group.isMember((Authorizable)authUser)) {
            throw new InvalidCallParameters(String.format("user %s is not in the group %s", userId, groupId));
        }
        this.aclManagerDelegate.update(userId, vreFolder, AccessType.ADMINISTRATOR, (Session)session);
    }

    public void removeAdministratorFromGroup(JackrabbitSession session, String groupId, String userId) throws StorageHubException, Throwable {
        Objects.nonNull(groupId);
        Objects.nonNull(userId);
        if (!this.getGroupAdministators(session, groupId).contains(userId)) {
            throw new InvalidCallParameters(String.format("user %s is not admin of the group %s", userId, groupId));
        }
        Node vreFolder = this.getFolderNodeRelatedToGroup(session, groupId);
        this.aclManagerDelegate.delete(userId, vreFolder, (Session)session);
    }

    public List<String> getGroupAdministators(JackrabbitSession session, String groupId) throws Throwable {
        ArrayList<String> users = new ArrayList<String>();
        Node node = this.getFolderNodeRelatedToGroup(session, groupId);
        List acls = this.aclManagerDelegate.get(node, (Session)session);
        for (ACL acl : acls) {
            for (AccessType pr : acl.getAccessTypes()) {
                if (pr != AccessType.ADMINISTRATOR) continue;
                users.add(acl.getPrincipal());
            }
        }
        return users;
    }

    public void addUserToGroup(JackrabbitSession session, String userId, String groupId) throws StorageHubException, RepositoryException {
        UserManager usrManager = session.getUserManager();
        Group group = (Group)usrManager.getAuthorizable(groupId);
        User user = (User)usrManager.getAuthorizable(userId);
        if (user == null) {
            throw new InvalidCallParameters("user " + userId + " not exists");
        }
        if (group.isMember((Authorizable)user)) {
            throw new InvalidCallParameters("user " + userId + " is already member of group " + groupId);
        }
        this.internalAddUserToGroup(session, group, user);
    }

    public boolean removeUserFromGroup(JackrabbitSession session, String groupId, String userId) throws StorageHubException, RepositoryException {
        User user;
        UserManager usrManager = session.getUserManager();
        Group group = (Group)usrManager.getAuthorizable(groupId);
        if (!group.isMember((Authorizable)(user = (User)usrManager.getAuthorizable(userId)))) {
            throw new InvalidCallParameters(String.format("user %s is not in the group %s", userId, groupId));
        }
        String folderName = group.getPrincipal().getName();
        Node folder = this.getFolderNodeRelatedToGroup(session, folderName);
        AccessControlManager acm = session.getAccessControlManager();
        JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)folder.getPath());
        AccessControlEntry entryToDelete = null;
        AccessControlEntry[] accessControlEntryArray = acls.getAccessControlEntries();
        int n = accessControlEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessControlEntry ace = accessControlEntryArray[n2];
            if (ace.getPrincipal().getName().equals(userId)) {
                entryToDelete = ace;
                break;
            }
            ++n2;
        }
        if (entryToDelete != null) {
            acls.removeAccessControlEntry(entryToDelete);
        }
        boolean found = false;
        NodeIterator ni = folder.getSharedSet();
        while (ni.hasNext()) {
            Node node = ni.nextNode();
            if (!node.getPath().startsWith(this.pathUtil.getVREsPath(userId, (Session)session).toPath())) continue;
            node.removeShare();
            found = true;
            break;
        }
        if (!found) {
            log.warn("sharing not removed for user {} ", (Object)userId);
        }
        return group.removeMember((Authorizable)user);
    }

    public List<String> getUsersBelongingToGroup(JackrabbitSession session, String groupId) throws StorageHubException, RepositoryException {
        ArrayList<String> users = new ArrayList<String>();
        UserManager usrManager = session.getUserManager();
        Group group = (Group)usrManager.getAuthorizable(groupId);
        Iterator it = group.getMembers();
        while (it.hasNext()) {
            Authorizable user = (Authorizable)it.next();
            users.add(user.getPrincipal().getName());
        }
        return users;
    }

    public Node getFolderNodeRelatedToGroup(JackrabbitSession session, String name) throws ItemNotFoundException, RepositoryException {
        Node sharedRootNode = session.getNode("/Share");
        Node vreFolder = null;
        try {
            vreFolder = sharedRootNode.getNode(name);
        }
        catch (PathNotFoundException pathNotFoundException) {
            log.debug("is an old HL VRE");
        }
        if (vreFolder == null) {
            NodeIterator nodes = sharedRootNode.getNodes();
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                if (!node.hasProperty(NodeProperty.TITLE.toString()) || !node.getProperty(NodeProperty.TITLE.toString()).getString().equals(name)) continue;
                vreFolder = node;
                break;
            }
        }
        if (vreFolder == null) {
            throw new ItemNotFoundException("vre folder not found for group " + name);
        }
        return vreFolder;
    }

    private void createVreFolder(JackrabbitSession session, String groupId, AccessType defaultAccessType, String owner, boolean useDefaultStorage) throws Exception {
        Node sharedRootNode = session.getNode("/Share");
        String name = groupId;
        String currentScope = SecretManagerProvider.get().getContext();
        ContextBean bean = new ContextBean(currentScope);
        while (!bean.is(ContextBean.Type.INFRASTRUCTURE)) {
            bean = bean.enclosingScope();
        }
        String root = bean.toString().replaceAll("/", "");
        String displayName = groupId.replaceAll(root + "-[^\\-]*\\-(.*)", "$1");
        log.info("creating vreFolder with name {} and title {} and owner {} and default storage {}", new Object[]{name, displayName, owner, useDefaultStorage});
        FolderCreationParameters folderParameters = !useDefaultStorage ? (FolderCreationParameters)FolderCreationParameters.builder().onRepository("gcube-s3").withParameters(Collections.singletonMap("bucketName", name.toLowerCase() + "-gcube-vre")).name(name).description("VREFolder for " + groupId).author(owner).on(sharedRootNode.getIdentifier()).with((Session)session).build() : (FolderCreationParameters)FolderCreationParameters.builder().name(name).description("VREFolder for " + groupId).author(owner).on(sharedRootNode.getIdentifier()).with((Session)session).build();
        Node folder = Utils.createFolderInternally((FolderCreationParameters)folderParameters, null, (boolean)useDefaultStorage);
        folder.setPrimaryType("nthl:workspaceSharedItem");
        folder.setProperty(NodeProperty.IS_VRE_FOLDER.toString(), true);
        folder.setProperty(NodeProperty.TITLE.toString(), name);
        folder.setProperty(NodeProperty.DISPLAY_NAME.toString(), displayName);
        session.save();
        AccessControlManager acm = session.getAccessControlManager();
        JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)folder.getPath());
        Privilege[] usersPrivileges = new Privilege[]{acm.privilegeFromName(defaultAccessType.getValue())};
        acls.addAccessControlEntry(AccessControlUtils.getPrincipal((Session)session, (String)groupId), usersPrivileges);
        acm.setPolicy(folder.getPath(), (AccessControlPolicy)acls);
        log.debug("vrefolder created with id {}", (Object)folder.getIdentifier());
    }

    private boolean internalAddUserToGroup(JackrabbitSession session, Group group, User user) throws RepositoryException, StorageHubException {
        boolean success = group.addMember((Authorizable)user);
        session.save();
        String folderName = group.getPrincipal().getName();
        Node folder = this.getFolderNodeRelatedToGroup(session, folderName);
        String userPath = Paths.append((Path)this.pathUtil.getVREsPath(user.getPrincipal().getName(), (Session)session), (String)folderName).toPath();
        log.debug("creating folder in user path {} from {}", (Object)userPath, (Object)folder.getPath());
        session.getWorkspace().clone(session.getWorkspace().getName(), folder.getPath(), userPath, false);
        try {
            session.getNode(userPath);
            log.debug("the new folder exists ({}) ", (Object)userPath);
        }
        catch (PathNotFoundException pathNotFoundException) {
            log.debug("the new folder doesn't exists ({}) ", (Object)userPath);
        }
        return success;
    }
}

