/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services.admin;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.nodes.Content;
import org.gcube.common.storagehub.model.storages.StorageBackendFactory;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.items.builders.FolderCreationParameters;
import org.gcube.data.access.storagehub.handlers.plugins.StorageBackendHandler;
import org.gcube.data.access.storagehub.predicates.IncludeTypePredicate;
import org.gcube.data.access.storagehub.predicates.ItemTypePredicate;
import org.gcube.data.access.storagehub.scripting.ScriptUtil;

@Singleton
public class ScriptUtilImpl
implements ScriptUtil {
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;
    @Inject
    TrashHandler trashHandler;
    @Inject
    StorageBackendHandler backendHandler;

    public List<Item> getChildren(Predicate<Node> checker, Node parent, List<String> excludes, boolean showHidden, Class<? extends Item> nodeTypeToInclude) throws RepositoryException, BackendGenericError {
        IncludeTypePredicate itemPredicate = new IncludeTypePredicate(nodeTypeToInclude);
        return Utils.getItemList(checker, (Node)parent, excludes, null, (boolean)showHidden, (ItemTypePredicate)itemPredicate);
    }

    public Item getItem(Node node, List<String> excludes) throws RepositoryException, BackendGenericError {
        return this.node2Item.getItem(node, excludes);
    }

    public void removeNodes(Session ses, List<Item> itemsToDelete) throws RepositoryException, StorageHubException {
        this.trashHandler.removeNodes(ses, itemsToDelete);
    }

    public Collection<StorageBackendFactory> getStorageBackendHandler() {
        return this.backendHandler.getAllImplementations();
    }

    public void updateContentNode(Content content, Node node) throws Exception {
        this.item2Node.replaceContentNodeInternal(node, content.getClass(), (Object)content);
    }

    public Node createInternalFolder(Session ses, String name, String description, String userOwner, String parentNodeIdentifier) throws StorageHubException {
        FolderCreationParameters parameters = (FolderCreationParameters)FolderCreationParameters.builder().name(name).description(description).author(userOwner).on(parentNodeIdentifier).with(ses).build();
        return Utils.createFolderInternally((FolderCreationParameters)parameters, null, (boolean)true);
    }
}

