/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import com.webcohesion.enunciate.metadata.Ignore;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.User;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.IdNotFoundException;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.RootItem;
import org.gcube.common.storagehub.model.items.nodes.Content;
import org.gcube.common.storagehub.model.items.nodes.Owner;
import org.gcube.common.storagehub.model.messages.Message;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.gcube.common.storagehub.model.storages.StorageBackendFactory;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.common.storagehub.model.types.MessageList;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.StorageHubApplicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.plugins.StorageBackendHandler;
import org.gcube.data.access.storagehub.predicates.IncludeTypePredicate;
import org.gcube.data.access.storagehub.predicates.ItemTypePredicate;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;
import org.gcube.data.access.storagehub.services.Impersonable;
import org.gcube.data.access.storagehub.types.MessageSharable;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
@jakarta.ws.rs.Path(value="messages")
@ManagedBy(value=StorageHubApplicationManager.class)
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class MessageManager
extends Impersonable {
    private static final Logger log = LoggerFactory.getLogger(MessageManager.class);
    private final StoragehubRepository repository = StoragehubRepository.repository;
    @Inject
    AccountingHandler accountingHandler;
    @RequestScoped
    @PathParam(value="id")
    String id;
    @Inject
    PathUtil pathUtil;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;
    @Inject
    TrashHandler trashHandler;
    @Inject
    StorageBackendHandler storageBackendHandler;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @jakarta.ws.rs.Path(value="{id}")
    @Produces(value={"application/json"})
    public Message getById() {
        InnerMethodName.set((String)"getMessageById");
        Session ses = null;
        Message toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                Node messageNode = ses.getNodeByIdentifier(this.id);
                toReturn = this.node2Item.getMessageItem(messageNode);
                this.checkRights(this.currentUser, toReturn);
                return toReturn;
            }
            catch (ItemNotFoundException e) {
                log.error("id {} not found", (Object)this.id, (Object)e);
                GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (RepositoryException re) {
                log.error("jcr error getting item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error getting item", (Throwable)re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @jakarta.ws.rs.Path(value="{id}")
    public void deleteById() {
        InnerMethodName.set((String)"deleteMessageById");
        Session ses = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                Node messageNode = ses.getNodeByIdentifier(this.id);
                Message message = this.node2Item.getMessageItem(messageNode);
                Node personalNode = this.checkRights(this.currentUser, message);
                if (this.countSharedSet(messageNode) > 1) {
                    log.debug("removing node message " + personalNode.getPath());
                    personalNode.remove();
                } else {
                    if (message.isWithAttachments()) {
                        Node attachmentNode = messageNode.getNode("hl:attachments");
                        IncludeTypePredicate itemPredicate = new IncludeTypePredicate(AbstractFileItem.class);
                        List attachments = Utils.getItemList((Node)attachmentNode, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, (ItemTypePredicate)itemPredicate);
                        this.trashHandler.removeOnlyNodesContent(ses, attachments);
                    }
                    messageNode.removeSharedSet();
                }
                ses.save();
                log.debug("removing node message saved");
                return;
            }
            catch (ItemNotFoundException e) {
                log.error("id {} not found", (Object)this.id, (Object)e);
                GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
                if (ses == null) return;
                ses.logout();
                return;
            }
            catch (RepositoryException re) {
                log.error("jcr error getting item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error getting item", (Throwable)re));
                if (ses == null) return;
                ses.logout();
                return;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @jakarta.ws.rs.Path(value="{id}/attachments")
    @Produces(value={"application/json"})
    public ItemList getAttachments() {
        InnerMethodName.set((String)"getAttachmentsByMessageId");
        Session ses = null;
        List attachments = new ArrayList();
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            Node messageNode = ses.getNodeByIdentifier(this.id);
            Message messageItem = this.node2Item.getMessageItem(messageNode);
            this.checkRights(this.currentUser, messageItem);
            Node attachmentNode = messageNode.getNode("hl:attachments");
            IncludeTypePredicate itemPredicate = new IncludeTypePredicate(AbstractFileItem.class);
            attachments = Utils.getItemList((Node)attachmentNode, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, (ItemTypePredicate)itemPredicate);
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(attachments);
            ses.logout();
            return new ItemList(attachments);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error getting item", (Throwable)re));
            return new ItemList(attachments);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(attachments);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(attachments);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(attachments);
        ses.logout();
        return new ItemList(attachments);
    }

    @GET
    @jakarta.ws.rs.Path(value="inbox")
    @Produces(value={"application/json"})
    public MessageList getReceivedMessages(@QueryParam(value="reduceBody") Integer reduceBody) {
        List toReturn;
        block8: {
            InnerMethodName.set((String)"getReceivedMessages");
            Session ses = null;
            toReturn = null;
            try {
                try {
                    ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                    Node node = ses.getNode(this.pathUtil.getInboxPath(this.currentUser).toPath());
                    toReturn = this.getMessages(node, reduceBody);
                }
                catch (RepositoryException re) {
                    log.error("jcr error getting item", (Throwable)re);
                    GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error getting item", (Throwable)re));
                    if (ses != null) {
                        ses.logout();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (ses != null) {
                    ses.logout();
                }
                throw throwable;
            }
            if (ses != null) {
                ses.logout();
            }
        }
        return new MessageList(toReturn);
    }

    @GET
    @jakarta.ws.rs.Path(value="sent")
    @Produces(value={"application/json"})
    public MessageList getSentMessages(@QueryParam(value="reduceBody") Integer reduceBody) {
        List toReturn;
        block8: {
            InnerMethodName.set((String)"getSentMessages");
            Session ses = null;
            toReturn = null;
            try {
                try {
                    ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                    Node node = ses.getNode(this.pathUtil.getOutboxPath(this.currentUser).toPath());
                    toReturn = this.getMessages(node, reduceBody);
                }
                catch (RepositoryException re) {
                    log.error("jcr error getting item", (Throwable)re);
                    GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error getting item", (Throwable)re));
                    if (ses != null) {
                        ses.logout();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (ses != null) {
                    ses.logout();
                }
                throw throwable;
            }
            if (ses != null) {
                ses.logout();
            }
        }
        return new MessageList(toReturn);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @jakarta.ws.rs.Path(value="{id}/{prop}")
    @Consumes(value={"application/json"})
    public void setProperty(@PathParam(value="prop") String property, Object value) {
        InnerMethodName.set((String)("setPropertyOnMessage(" + property + ")"));
        Session ses = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                Node messageNode = ses.getNodeByIdentifier(this.id);
                Message messageItem = this.node2Item.getMessageItem(messageNode);
                this.checkRights(this.currentUser, messageItem);
                Item2NodeConverter.Values val = Item2NodeConverter.getObjectValue(value.getClass(), (Object)value);
                messageNode.setProperty(property, val.getValue());
                ses.save();
                return;
            }
            catch (ItemNotFoundException e) {
                log.error("id {} not found", (Object)this.id, (Object)e);
                GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
                if (ses == null) return;
                ses.logout();
                return;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return;
                ses.logout();
                return;
            }
            catch (Exception re) {
                log.error("jcr error getting item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error getting item", (Throwable)re));
                if (ses == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @jakarta.ws.rs.Path(value="send")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String sendMessage(@FormParam(value="to[]") List<String> addresses, @FormParam(value="subject") String subject, @FormParam(value="body") String body, @FormParam(value="attachments[]") List<String> attachments) {
        InnerMethodName.set((String)"sendMessage");
        JackrabbitSession ses = null;
        String messageId = null;
        try {
            try {
                if (addresses.size() == 0 || body == null || subject == null) {
                    throw new InvalidCallParameters();
                }
                log.debug("attachments send are {}", attachments);
                ses = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                MessageSharable message = new MessageSharable();
                message.setAddresses(addresses.toArray(new String[0]));
                message.setSubject(subject);
                message.setBody(body);
                message.setName(UUID.randomUUID().toString());
                User user = (User)ses.getUserManager().getAuthorizable(this.currentUser, User.class);
                if (user == null) {
                    throw new InvalidCallParameters("invalid storagehub user: " + this.currentUser);
                }
                Owner owner = new Owner();
                owner.setUserId(user.getID());
                owner.setUserName(user.getPrincipal().getName());
                message.setSender(owner);
                Node outbox = ses.getNode(this.pathUtil.getOutboxPath(this.currentUser).toPath());
                Node messageNode = this.item2Node.getNode(outbox, (RootItem)message);
                ses.save();
                if (attachments != null && !attachments.isEmpty()) {
                    this.saveAttachments((Session)ses, messageNode, attachments);
                    ses.save();
                }
                for (String to : addresses) {
                    try {
                        String userMessagePath = Paths.append((Path)this.pathUtil.getInboxPath(to), (String)messageNode.getName()).toPath();
                        ses.getWorkspace().clone(ses.getWorkspace().getName(), messageNode.getPath(), userMessagePath, false);
                    }
                    catch (Exception e) {
                        log.warn("message not send to {}", (Object)to, (Object)e);
                    }
                }
                ses.save();
                messageId = messageNode.getIdentifier();
                return messageId;
            }
            catch (RepositoryException re) {
                log.error("jcr error getting item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error getting item", (Throwable)re));
                if (ses == null) return messageId;
                ses.logout();
                return messageId;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return messageId;
                ses.logout();
                return messageId;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    private Node saveAttachments(Session ses, Node messageNode, List<String> attachments) throws RepositoryException, StorageHubException {
        Node attachmentNode = messageNode.getNode("hl:attachments");
        for (String itemId : attachments) {
            Node node = ses.getNodeByIdentifier(itemId);
            Item item = this.node2Item.getItem(node, Excludes.GET_ONLY_CONTENT);
            Node newNode = this.copyNode(ses, attachmentNode, item);
            if (!newNode.hasNode(NodeProperty.ACCOUNTING.toString())) continue;
            newNode.getNode(NodeProperty.ACCOUNTING.toString()).remove();
        }
        return messageNode;
    }

    private List<Message> getMessages(Node node, Integer reduceBody) throws RepositoryException {
        ArrayList<Message> messages = new ArrayList<Message>();
        NodeIterator nodeIt = node.getNodes();
        while (nodeIt.hasNext()) {
            Node child = nodeIt.nextNode();
            log.trace("message type " + child.getPrimaryNodeType().getName());
            Message message = this.node2Item.getMessageItem(child);
            if (message == null) {
                log.info("message discarded");
                continue;
            }
            if (reduceBody != null && reduceBody > 0 && message.getBody().length() > reduceBody) {
                message.setBody(message.getBody().substring(0, reduceBody));
            }
            this.insertOrdered(messages, message);
        }
        return messages;
    }

    private void insertOrdered(List<Message> messages, Message toInsert) {
        if (messages.isEmpty()) {
            messages.add(toInsert);
        } else {
            int i = 0;
            while (i < messages.size()) {
                if (messages.get(i).getCreationTime().getTimeInMillis() <= toInsert.getCreationTime().getTimeInMillis()) break;
                ++i;
            }
            messages.add(i, toInsert);
        }
    }

    private Node checkRights(String user, Message messageItem) throws RepositoryException, StorageHubException {
        Node personalNode = null;
        Node messageNode = (Node)messageItem.getRelatedNode();
        if (messageNode.getPath().startsWith(this.pathUtil.getInboxPath(user).toPath())) {
            return messageNode;
        }
        NodeIterator nodeIt = messageNode.getSharedSet();
        while (nodeIt.hasNext()) {
            Node node = nodeIt.nextNode();
            if (!node.getPath().startsWith(this.pathUtil.getInboxPath(user).toPath())) continue;
            personalNode = node;
        }
        if (personalNode == null && !messageItem.getSender().getUserName().equals(user) && !Arrays.asList(messageItem.getAddresses()).contains(user)) {
            throw new UserNotAuthorizedException("user " + this.currentUser + "cannot read message with id " + this.id);
        }
        return personalNode == null ? messageNode : personalNode;
    }

    private Node copyNode(Session session, Node destination, Item itemToCopy) throws RepositoryException, StorageHubException {
        Node nodeToCopy = (Node)itemToCopy.getRelatedNode();
        String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)session, (Node)destination, (String)itemToCopy.getName());
        String newPath = String.format("%s/%s", destination.getPath(), uniqueName);
        session.getWorkspace().copy(nodeToCopy.getPath(), newPath);
        Node newNode = session.getNode(newPath);
        if (itemToCopy instanceof AbstractFileItem) {
            AbstractFileItem newNodeItem = (AbstractFileItem)this.node2Item.getItem(newNode, Excludes.EXCLUDE_ACCOUNTING);
            Content contentToCopy = newNodeItem.getContent();
            StorageBackendFactory sbf = this.storageBackendHandler.get(contentToCopy.getPayloadBackend());
            StorageBackend sb = sbf.create(contentToCopy.getPayloadBackend());
            MetaInfo contentInfo = sb.onCopy(contentToCopy, destination.getPath(), uniqueName);
            Utils.setContentFromMetaInfo((AbstractFileItem)newNodeItem, (MetaInfo)contentInfo);
            this.item2Node.replaceContent(newNode, newNodeItem, ItemAction.CLONED);
        }
        Utils.setPropertyOnChangeNode((Node)newNode, (String)this.currentUser, (ItemAction)ItemAction.CLONED);
        newNode.setProperty(NodeProperty.PORTAL_LOGIN.toString(), this.currentUser);
        newNode.setProperty(NodeProperty.IS_PUBLIC.toString(), false);
        newNode.setProperty(NodeProperty.TITLE.toString(), uniqueName);
        return newNode;
    }

    private int countSharedSet(Node node) throws RepositoryException {
        int count = 0;
        NodeIterator it = node.getSharedSet();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }
}

