/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceMethodSignature;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.gcube.common.authorization.control.AuthorizationAspect;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.StorageHubApplicationManager;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;
import org.gcube.data.access.storagehub.services.delegates.GroupManagerDelegate;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="groups")
@Singleton
@ManagedBy(value=StorageHubApplicationManager.class)
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class GroupManager {
    private static final Logger log;
    private final StoragehubRepository repository = StoragehubRepository.repository;
    @Inject
    GroupManagerDelegate groupHandler;
    @Inject
    PathUtil pathUtil;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        GroupManager.ajc$preClinit();
        log = LoggerFactory.getLogger(GroupManager.class);
    }

    @StatusCodes(value={@ResponseCode(code=200, condition="Success.")})
    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public List<String> getGroups() {
        InnerMethodName.set((String)"getGroups");
        JackrabbitSession session = null;
        ArrayList<String> groups = new ArrayList();
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                groups = this.groupHandler.getGroups(session);
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                if (session != null) {
                    session.logout();
                }
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return groups;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResourceMethodSignature(output=String.class, formParams={@FormParam(value="group"), @FormParam(value="accessType"), @FormParam(value="folderOwner"), @FormParam(value="useDefaultStorage")})
    @StatusCodes(value={@ResponseCode(code=200, condition="Success."), @ResponseCode(code=403, condition="You're not allowed to create groups."), @ResponseCode(code=406, condition="Error creating group."), @ResponseCode(code=415, condition="Wrong content type.")})
    @DocumentationExample(value="...\n\n--------boundaryString\nContent-Disposition: form-data; name=\"group\"\n\nmy_group\n--------boundaryString\nContent-Disposition: form-data; name=\"accessType\"\n\nADMINISTRATOR\n--------boundaryString\nContent-Disposition: form-data; name=\"folderOwner\"\n\nuser1\n--------boundaryString\nContent-Disposition: form-data; name=\"useDefaultStorage\"\n\ntrue\n--------boundaryString--")
    @POST
    @Path(value="")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"})
    public String createGroup(@FormDataParam(value="group") String group, @FormDataParam(value="accessType") AccessType accessType, @FormDataParam(value="folderOwner") String folderOwner, @FormDataParam(value="useDefaultStorage") @DefaultValue(value="true") boolean useDefaultStorage) {
        String string = group;
        AccessType accessType2 = accessType;
        String string2 = folderOwner;
        boolean bl = useDefaultStorage;
        Object[] objectArray = new Object[]{string, accessType2, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.set((String)"createGroup");
        JackrabbitSession session = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.groupHandler.createGroup(session, group, accessType, folderOwner, useDefaultStorage);
                session.save();
                return group;
            }
            catch (StorageHubException se) {
                log.error("error creating group {}", (Object)group, (Object)se);
                GXOutboundErrorResponse.throwException((Exception)((Object)se));
                if (session == null) return group;
                session.logout();
                return group;
            }
            catch (Throwable e) {
                log.error("jcr error creating group {}", (Object)group, (Object)e);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
                if (session == null) return group;
                session.logout();
                return group;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @StatusCodes(value={@ResponseCode(code=200, condition="Success."), @ResponseCode(code=403, condition="You're not allowed to delete groups."), @ResponseCode(code=406, condition="Error deleting group.")})
    @DELETE
    @Path(value="{group}")
    @Produces(value={"text/plain"})
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"})
    public String deleteGroup(@PathParam(value="group") String group) {
        String string = group;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.set((String)"deleteGroup");
        JackrabbitSession session = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.groupHandler.deleteGroup(session, group);
                session.save();
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                if (session != null) {
                    session.logout();
                }
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return group;
    }

    public boolean isInfraManager() {
        return SecretManagerProvider.get().getOwner().getRoles().contains("Infrastructure-Manager");
    }

    public boolean isVREManager() {
        return SecretManagerProvider.get().getOwner().getRoles().contains("VRE-Manager");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @StatusCodes(value={@ResponseCode(code=204, condition="Success."), @ResponseCode(code=406, condition="Error adding an admin."), @ResponseCode(code=415, condition="Wrong content type.")})
    @ResourceMethodSignature(output=String.class, pathParams={@PathParam(value="id")}, formParams={@FormParam(value="userId")})
    @PUT
    @Path(value="{id}/admins")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void addAdmin(@PathParam(value="id") String groupId, @FormParam(value="userId") String userId) {
        InnerMethodName.set((String)"addAdmin");
        JackrabbitSession session = null;
        try {
            try {
                Objects.nonNull(groupId);
                Objects.nonNull(userId);
                String currentUser = SecretManagerProvider.get().getOwner().getId();
                if (!(this.isInfraManager() || this.isVREManager() && this.isValidGroupForContext(groupId) || this.groupHandler.getGroupAdministators(session, groupId).contains(currentUser))) {
                    throw new UserNotAuthorizedException();
                }
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.groupHandler.addAdministratorToGroup(session, groupId, userId);
                session.save();
                return;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return;
                session.logout();
                return;
            }
            catch (Throwable re) {
                log.error("adding admin to VREFolder", re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error adding admin to VREFolder", re));
                if (session == null) return;
                session.logout();
                return;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @StatusCodes(value={@ResponseCode(code=204, condition="Success."), @ResponseCode(code=406, condition="Error removing an admin."), @ResponseCode(code=415, condition="Wrong content type.")})
    @ResourceMethodSignature(output=void.class, pathParams={@PathParam(value="id")}, formParams={@FormParam(value="userId")})
    @DELETE
    @Path(value="{id}/admins/{userId}")
    public void removeAdmin(@PathParam(value="id") String groupId, @PathParam(value="userId") String userId) {
        InnerMethodName.set((String)"removeAdmin");
        JackrabbitSession session = null;
        try {
            try {
                Objects.nonNull(groupId);
                Objects.nonNull(userId);
                String currentUser = SecretManagerProvider.get().getOwner().getId();
                if (!(this.isInfraManager() || this.isVREManager() && this.isValidGroupForContext(groupId) || this.groupHandler.getGroupAdministators(session, groupId).contains(currentUser))) {
                    throw new UserNotAuthorizedException();
                }
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.groupHandler.removeAdministratorFromGroup(session, groupId, userId);
                session.save();
                return;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return;
                session.logout();
                return;
            }
            catch (Throwable re) {
                log.error("jcr error creating item", re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error removing admin to VREFolder", re));
                if (session == null) return;
                session.logout();
                return;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @StatusCodes(value={@ResponseCode(code=200, condition="Success."), @ResponseCode(code=406, condition="This group does not exist.")})
    @GET
    @Path(value="{groupId}/admins")
    @Produces(value={"application/json"})
    public List<String> getAdmins(@PathParam(value="groupId") String groupId) {
        InnerMethodName.set((String)"getAdmins");
        ArrayList<String> users = new ArrayList();
        JackrabbitSession session = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                users = this.groupHandler.getGroupAdministators(session, groupId);
                return users;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return users;
                session.logout();
                return users;
            }
            catch (Throwable re) {
                log.error("jcr error getting admins", re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error getting admins", re));
                if (session == null) return users;
                session.logout();
                return users;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @StatusCodes(value={@ResponseCode(code=200, condition="Success."), @ResponseCode(code=403, condition="You're not allowed to add users to groups."), @ResponseCode(code=406, condition="Group or user does not exist."), @ResponseCode(code=415, condition="Wrong content type.")})
    @ResourceMethodSignature(output=boolean.class, pathParams={@PathParam(value="id")}, formParams={@FormParam(value="userId")})
    @DocumentationExample(value="...\n\nuserId=user1\n")
    @PUT
    @Path(value="{id}/users")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @AuthorizationControl(allowedRoles={"VRE-Manager", "Infrastructure-Manager"})
    public boolean addUserToGroup(@PathParam(value="id") String groupId, @FormParam(value="userId") String userId) {
        String string = groupId;
        String string2 = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)string2);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.set((String)"addUserToGroup");
        JackrabbitSession session = null;
        boolean success = false;
        try {
            try {
                if (!(this.isInfraManager() || this.isVREManager() && this.isValidGroupForContext(groupId))) {
                    throw new UserNotAuthorizedException("only VREManager of the selected VRE can execute this operation");
                }
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.groupHandler.addUserToGroup(session, userId, groupId);
                success = true;
                session.save();
                return success;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return success;
                session.logout();
                return success;
            }
            catch (RepositoryException re) {
                log.error("jcr error adding user to group", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error adding user to group", (Throwable)re));
                if (session == null) return success;
                session.logout();
                return success;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @StatusCodes(value={@ResponseCode(code=200, condition="Success."), @ResponseCode(code=403, condition="You're not allowed to add users to groups."), @ResponseCode(code=406, condition="Group or user does not exist.")})
    @DELETE
    @Path(value="{groupId}/users/{userId}")
    @AuthorizationControl(allowedRoles={"VRE-Manager", "Infrastructure-Manager"})
    public boolean removeUserFromGroup(@PathParam(value="groupId") String groupId, @PathParam(value="userId") String userId) {
        String string = groupId;
        String string2 = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)string2);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.set((String)"removeUserFromGroup");
        JackrabbitSession session = null;
        boolean success = false;
        try {
            try {
                if (!(this.isInfraManager() || this.isVREManager() && this.isValidGroupForContext(groupId))) {
                    throw new UserNotAuthorizedException("only VREManager of the selected VRE can execute this operation");
                }
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                success = this.groupHandler.removeUserFromGroup(session, groupId, userId);
                session.save();
                return success;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return success;
                session.logout();
                return success;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                if (session == null) return success;
                session.logout();
                return success;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @StatusCodes(value={@ResponseCode(code=200, condition="Success."), @ResponseCode(code=406, condition="Group does not exist.")})
    @GET
    @Path(value="{groupId}/users")
    @Produces(value={"application/json"})
    @AuthorizationControl(allowedRoles={"VRE-Manager", "Infrastructure-Manager"})
    public List<String> getUsersOfGroup(@PathParam(value="groupId") String groupId) {
        String string = groupId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.set((String)"getUsersOfGroup");
        JackrabbitSession session = null;
        ArrayList arrayList = new ArrayList();
        try {
            void var3_7;
            try {
                if (!(this.isInfraManager() || this.isVREManager() && this.isValidGroupForContext(groupId))) {
                    throw new UserNotAuthorizedException("only VREManager of the selected VRE can execute this operation");
                }
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                List list = this.groupHandler.getUsersBelongingToGroup(session, groupId);
                return var3_7;
            }
            catch (StorageHubException e) {
                log.error("error getting users", (Throwable)e);
                GXOutboundErrorResponse.throwException((Exception)((Object)e));
                if (session == null) return var3_7;
                session.logout();
                return var3_7;
            }
            catch (RepositoryException re) {
                log.error("jcr error getting users", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error getting users", (Throwable)re));
                if (session == null) return var3_7;
                session.logout();
                return var3_7;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private boolean isValidGroupForContext(String group) {
        String currentContext = SecretManagerProvider.get().getContext();
        String expectedGroupId = currentContext.replace("/", "-").substring(1);
        return group.equals(expectedGroupId);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GroupManager.java", GroupManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createGroup", "org.gcube.data.access.storagehub.services.GroupManager", "java.lang.String:org.gcube.common.storagehub.model.acls.AccessType:java.lang.String:boolean", "group:accessType:folderOwner:useDefaultStorage", "", "java.lang.String"), 145);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteGroup", "org.gcube.data.access.storagehub.services.GroupManager", "java.lang.String", "group", "", "java.lang.String"), 183);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addUserToGroup", "org.gcube.data.access.storagehub.services.GroupManager", "java.lang.String:java.lang.String", "groupId:userId", "", "boolean"), 358);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeUserFromGroup", "org.gcube.data.access.storagehub.services.GroupManager", "java.lang.String:java.lang.String", "groupId:userId", "", "boolean"), 405);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUsersOfGroup", "org.gcube.data.access.storagehub.services.GroupManager", "java.lang.String", "groupId", "", "java.util.List"), 450);
    }
}

