package org.gcube.data.access.storagehub.health;

import javax.jcr.LoginException;
import javax.jcr.Session;

import org.gcube.common.health.api.HealthCheck;
import org.gcube.common.health.api.ReadinessChecker;
import org.gcube.common.health.api.response.HealthCheckResponse;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;

@ReadinessChecker
public class JCRRepositoryCheck implements HealthCheck{
	
	
	
	
	@Override
	public String getName() {
		return "Jackrabbit repository";
	}

	@Override
	public HealthCheckResponse check() {
		try {
			Session session = StoragehubRepository.repository.getRepository().login();
			if (session != null) session.logout();
			return HealthCheckResponse.builder(getName()).up().build();
		}catch (LoginException e) {	}
		catch(Throwable ex) {
			return HealthCheckResponse.builder(getName()).down().error(ex.getMessage()).build(); 
		}
		return HealthCheckResponse.builder(getName()).up().build();
	}

}
