/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services.admin;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gcube.data.access.storagehub.services.admin.ScriptStatus;

public class ScriptStatus {
    private static final DateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss:SSS Z");
    private Status status = Status.Running;
    private String errorMessage;
    private String result;
    private long start = System.currentTimeMillis();
    private long finished = -1L;
    private String runningId;
    private String executionServer;

    public ScriptStatus(String runningId, String resultPath, String executionServer) {
        this.runningId = runningId;
        this.result = resultPath;
        this.executionServer = executionServer;
    }

    public ScriptStatus(String runningId, String executionServer) {
        this.runningId = runningId;
        this.executionServer = executionServer;
    }

    public void setFailed(String error) {
        this.status = Status.Failed;
        this.errorMessage = error;
        this.finished = System.currentTimeMillis();
    }

    public void setSuccess() {
        this.status = Status.Success;
        this.finished = System.currentTimeMillis();
    }

    public void setSuccess(String result) {
        this.status = Status.Success;
        this.finished = System.currentTimeMillis();
        this.result = result;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getStartDate() {
        Date date = new Date(this.start);
        return dateFormat.format(date);
    }

    public long getDurationInMillis() {
        long toUse = this.finished;
        if (this.finished < 0L) {
            toUse = System.currentTimeMillis();
        }
        return toUse - this.start;
    }

    public String getHumanReadableDuration() {
        long toUse = this.finished;
        if (this.finished < 0L) {
            toUse = System.currentTimeMillis();
        }
        long duration = toUse - this.start;
        long minutes = duration / 1000L / 60L;
        long seconds = duration / 1000L % 60L;
        return String.format("%d minutes %d seconds", minutes, seconds);
    }

    public String getResult() {
        return this.result;
    }

    public String getRunningId() {
        return this.runningId;
    }

    public String getExecutionServer() {
        return this.executionServer;
    }
}

