/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gcube.common.authorization.control.AuthorizationAspect;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.IdNotFoundException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.service.UsersList;
import org.gcube.common.storagehub.model.types.SHUBUser;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.StorageHubApplicationManager;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;
import org.gcube.data.access.storagehub.services.delegates.UserManagerDelegate;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="users")
@ManagedBy(value=StorageHubApplicationManager.class)
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources")})
public class UserManager {
    private static final String INFRASTRUCTURE_MANAGER_ROLE = "Infrastructure-Manager";
    private static final Logger log;
    private final StoragehubRepository repository = StoragehubRepository.repository;
    @Inject
    UserManagerDelegate userHandler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        UserManager.ajc$preClinit();
        log = LoggerFactory.getLogger(UserManager.class);
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public UsersList getUsers() {
        InnerMethodName.set((String)"getUsers");
        JackrabbitSession session = null;
        try {
            session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            UsersList usersList = new UsersList(this.userHandler.getAllUsers(session));
            return usersList;
        }
        catch (Throwable e) {
            log.error("jcr error getting users", e);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError(e)));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return null;
    }

    @GET
    @Path(value="{user}")
    @Produces(value={"application/json"})
    public SHUBUser getUser(@PathParam(value="user") String user) {
        InnerMethodName.set((String)"getUser");
        JackrabbitSession session = null;
        try {
            session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            SHUBUser sHUBUser = this.userHandler.getUser(session, user);
            return sHUBUser;
        }
        catch (StorageHubException se) {
            log.error("error getting user", (Throwable)se);
            GXOutboundErrorResponse.throwException((Exception)((Object)se));
        }
        catch (Exception e) {
            log.error("jcr error getting user", (Throwable)e);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)e)));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(user));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Path(value="")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"})
    public String createUser(@FormParam(value="user") String user, @FormParam(value="password") String password) {
        String string = user;
        String string2 = password;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.set((String)"createUser");
        JackrabbitSession session = null;
        String userId = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                userId = this.userHandler.createUser(session, user, password);
                session.save();
                return userId;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return userId;
                session.logout();
                return userId;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error creating item", (Throwable)re)));
                if (session == null) return userId;
                session.logout();
                return userId;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Path(value="{user}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"})
    public String updateHomeUserToLatestVersion(@PathParam(value="user") String user) {
        String string = user;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.set((String)"updateHomeUserToLatestVersion");
        JackrabbitSession session = null;
        String userId = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                userId = this.userHandler.updateHomeUserToLatestVersion(session, userId);
                session.save();
                return userId;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return userId;
                session.logout();
                return userId;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error creating item", (Throwable)re)));
                if (session == null) return userId;
                session.logout();
                return userId;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @Path(value="{user}")
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"})
    public String deleteUser(@PathParam(value="user") String user) {
        String string = user;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.set((String)"deleteUser");
        JackrabbitSession session = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.userHandler.deleteUser(session, user);
                session.save();
                return user;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return user;
                session.logout();
                return user;
            }
            catch (RepositoryException re) {
                log.error("jcr error removing item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error removing item", (Throwable)re)));
                if (session == null) return user;
                session.logout();
                return user;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @GET
    @Path(value="{user}/groups")
    @Produces(value={"application/json"})
    public List<String> getGroupsPerUser(@PathParam(value="user") String user) {
        InnerMethodName.set((String)"getGroupsPerUser");
        JackrabbitSession session = null;
        ArrayList<String> groups = new ArrayList<String>();
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.userHandler.getGroupsPerUser(session, user);
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error creating item", (Throwable)re)));
                if (session != null) {
                    session.logout();
                }
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return groups;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserManager.java", UserManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createUser", "org.gcube.data.access.storagehub.services.UserManager", "java.lang.String:java.lang.String", "user:password", "", "java.lang.String"), 107);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateHomeUserToLatestVersion", "org.gcube.data.access.storagehub.services.UserManager", "java.lang.String", "user", "", "java.lang.String"), 137);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteUser", "org.gcube.data.access.storagehub.services.UserManager", "java.lang.String", "user", "", "java.lang.String"), 166);
    }
}

