/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.version.Version;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.IdNotFoundException;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.items.VreFolder;
import org.gcube.common.storagehub.model.items.nodes.Content;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.common.storagehub.model.service.VersionList;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.types.FolderInfoType;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.StorageHubApplicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.ClassHandler;
import org.gcube.data.access.storagehub.handlers.DownloadHandler;
import org.gcube.data.access.storagehub.handlers.PublicLinkHandler;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.plugins.StorageOperationMediator;
import org.gcube.data.access.storagehub.predicates.IncludeTypePredicate;
import org.gcube.data.access.storagehub.predicates.ItemTypePredicate;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;
import org.gcube.data.access.storagehub.services.Impersonable;
import org.gcube.data.access.storagehub.types.LinkType;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@jakarta.ws.rs.Path(value="items")
@ManagedBy(value=StorageHubApplicationManager.class)
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources")})
public class ItemsManager
extends Impersonable {
    private static final Logger log;
    private final StoragehubRepository repository = StoragehubRepository.repository;
    @Inject
    AccountingHandler accountingHandler;
    @PathParam(value="id")
    String id;
    @Context
    ServletContext context;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    VersionHandler versionHandler;
    @Inject
    DownloadHandler downloadHandler;
    @Inject
    TrashHandler trashHandler;
    @Inject
    PathUtil pathUtil;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;
    @Inject
    StorageOperationMediator opMediator;
    @Inject
    PublicLinkHandler publicLinkHandler;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$access$storagehub$types$LinkType;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        ItemsManager.ajc$preClinit();
        log = LoggerFactory.getLogger(ItemsManager.class);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @jakarta.ws.rs.Path(value="{id}")
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getById(@QueryParam(value="exclude") List<String> excludes) {
        InnerMethodName.set((String)"getById");
        Session ses = null;
        Item toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            Node node = ses.getNodeByIdentifier(this.id);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            toReturn = this.node2Item.getItem(node, excludes);
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemWrapper(toReturn);
            ses.logout();
            return new ItemWrapper(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error getting item", (Throwable)re)));
            return new ItemWrapper(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemWrapper(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemWrapper(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemWrapper(toReturn);
        ses.logout();
        return new ItemWrapper(toReturn);
    }

    @GET
    @jakarta.ws.rs.Path(value="{id}/path")
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getByRelativePath(@QueryParam(value="path") String path, @QueryParam(value="exclude") List<String> excludes) {
        InnerMethodName.set((String)"getByPath");
        Session ses = null;
        Item toReturn = null;
        try {
            String[] paths;
            String relativePath;
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            String string = relativePath = path.startsWith("/") ? path.substring(1) : path;
            if (path.endsWith("/")) {
                relativePath.substring(0, relativePath.lastIndexOf("/"));
            }
            if (relativePath.isEmpty()) {
                throw new InvalidCallParameters("empty path");
            }
            Item item = null;
            String nextId = this.id;
            String[] stringArray = paths = relativePath.split("/");
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String actualPath = stringArray[n2];
                item = this.getChildrenMatchingName(ses, nextId, actualPath, Excludes.ALL);
                if (item == null) {
                    throw new InvalidCallParameters("relative path " + actualPath + " not found under item with id " + nextId);
                }
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, item.getId());
                nextId = item.getId();
                ++n2;
            }
            if (excludes.containsAll(Excludes.ALL)) {
                ItemWrapper itemWrapper = new ItemWrapper(item);
                return itemWrapper;
            }
            ItemWrapper itemWrapper = new ItemWrapper(this.node2Item.getItem(ses.getNodeByIdentifier(item.getId()), excludes));
            return itemWrapper;
        }
        catch (RepositoryException re) {
            log.error("jcr error getting item  by path", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error getting item by path", (Throwable)re)));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemWrapper(toReturn);
    }

    private Item getChildrenMatchingName(Session ses, String id, String name, List<String> excludes) throws ItemNotFoundException, RepositoryException, StorageHubException {
        NodeIterator it = ses.getNodeByIdentifier(id).getNodes();
        while (it.hasNext()) {
            Node child = it.nextNode();
            String nodeName = child.getName();
            if (!child.hasProperty(NodeProperty.TITLE.toString())) continue;
            String title = child.getProperty(NodeProperty.TITLE.toString()).getString();
            if (!nodeName.equals(name) && !title.equals(name)) continue;
            return this.node2Item.getItem(child, excludes);
        }
        return null;
    }

    @Deprecated
    @GET
    @jakarta.ws.rs.Path(value="{id}/items/{name}")
    @Produces(value={"application/json"})
    public ItemList findChildrenByNamePatternInPath(@QueryParam(value="exclude") List<String> excludes, @PathParam(value="name") String name) {
        InnerMethodName.set((String)"findChildrenByNamePattern");
        return this._findChildrenByNamePattern(excludes, name);
    }

    @GET
    @jakarta.ws.rs.Path(value="{id}/items")
    @Produces(value={"application/json"})
    public ItemList findChildrenByNamePattern(@QueryParam(value="exclude") List<String> excludes, @QueryParam(value="name") String name) {
        InnerMethodName.set((String)"findChildrenByNamePattern");
        return this._findChildrenByNamePattern(excludes, name);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemList _findChildrenByNamePattern(List<String> excludes, String name) {
        Session ses = null;
        ArrayList<Item> toReturn = new ArrayList<Item>();
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            NodeIterator it = ses.getNodeByIdentifier(this.id).getNodes();
            while (it.hasNext()) {
                Node child = it.nextNode();
                String nodeName = child.getName();
                if (!child.hasProperty(NodeProperty.TITLE.toString())) continue;
                String title = child.getProperty(NodeProperty.TITLE.toString()).getString();
                String cleanedName = name;
                if (name.startsWith("*")) {
                    cleanedName = name.substring(1);
                }
                if (name.endsWith("*")) {
                    cleanedName = name.substring(0, name.length() - 1);
                }
                if ((!name.startsWith("*") || !nodeName.endsWith(cleanedName) && !title.endsWith(cleanedName)) && (!name.endsWith("*") || !nodeName.startsWith(cleanedName) && !title.startsWith(cleanedName)) && !nodeName.equals(cleanedName) && !title.equals(cleanedName)) continue;
                toReturn.add(this.node2Item.getItem(child, excludes));
            }
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(toReturn);
            ses.logout();
            return new ItemList(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error searching item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error searching item", (Throwable)re)));
            return new ItemList(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(toReturn);
        ses.logout();
        return new ItemList(toReturn);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @jakarta.ws.rs.Path(value="{id}/children/count")
    public Long countById(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="exclude") List<String> excludes, @QueryParam(value="onlyType") String nodeType) {
        InnerMethodName.set((String)"countById");
        Session ses = null;
        Long toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                IncludeTypePredicate itemPredicate = nodeType != null ? new IncludeTypePredicate(ClassHandler.instance().get(nodeType)) : null;
                Node node = ses.getNodeByIdentifier(this.id);
                toReturn = Utils.getItemCount((Node)node, (boolean)(showHidden == null ? false : showHidden), (ItemTypePredicate)itemPredicate);
                return toReturn;
            }
            catch (ItemNotFoundException e) {
                log.error("id {} not found", (Object)this.id, (Object)e);
                GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (RuntimeException | RepositoryException re) {
                log.error("jcr error counting item", re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError(re)));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @jakarta.ws.rs.Path(value="{id}/children")
    @Produces(value={"application/json"})
    public ItemList listById(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="exclude") List<String> excludes, @QueryParam(value="onlyType") String nodeType) {
        InnerMethodName.set((String)"listById");
        Session ses = null;
        List toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            IncludeTypePredicate itemPredicate = nodeType != null ? new IncludeTypePredicate(ClassHandler.instance().get(nodeType)) : null;
            Node node = ses.getNodeByIdentifier(this.id);
            toReturn = Utils.getItemList((Node)node, excludes, null, (boolean)(showHidden == null ? false : showHidden), (ItemTypePredicate)itemPredicate);
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(toReturn);
            ses.logout();
            return new ItemList(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting children", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
            return new ItemList(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(toReturn);
        ses.logout();
        return new ItemList(toReturn);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @jakarta.ws.rs.Path(value="{id}/search")
    @Produces(value={"application/json"})
    public ItemList searchItems(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="excludeTrashed") Boolean excludeTrashed, @QueryParam(value="exclude") List<String> excludes, @QueryParam(value="onlyType") String nodeType, @QueryParam(value="name") String name) {
        InnerMethodName.set((String)"search");
        Session ses = null;
        List toReturn = null;
        try {
            log.debug("search for node {}", (Object)name);
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            IncludeTypePredicate itemPredicate = nodeType != null ? new IncludeTypePredicate(ClassHandler.instance().get(nodeType)) : null;
            Node node = ses.getNodeByIdentifier(this.id);
            toReturn = Utils.searchByNameOnFolder((Session)ses, (String)this.currentUser, (AuthorizationChecker)this.authChecker, (Node)node, excludes, null, (boolean)(showHidden == null ? false : showHidden), (boolean)(excludeTrashed != false ? false : excludeTrashed), (ItemTypePredicate)itemPredicate, (String)name);
            log.debug("search retrieved {} elements", (Object)toReturn.size());
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(toReturn);
            ses.logout();
            return new ItemList(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting children", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
            return new ItemList(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(toReturn);
        ses.logout();
        return new ItemList(toReturn);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @jakarta.ws.rs.Path(value="{id}/children/paged")
    @Produces(value={"application/json"})
    public ItemList listByIdPaged(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit, @QueryParam(value="exclude") List<String> excludes, @QueryParam(value="onlyType") String nodeType) {
        InnerMethodName.set((String)"listByIdPaged");
        Session ses = null;
        List toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            IncludeTypePredicate itemPredicate = nodeType != null ? new IncludeTypePredicate(ClassHandler.instance().get(nodeType)) : null;
            Node node = ses.getNodeByIdentifier(this.id);
            toReturn = Utils.getItemList((Node)node, excludes, (Range)new Range(start.intValue(), limit.intValue()), (boolean)(showHidden == null ? false : showHidden), (ItemTypePredicate)itemPredicate);
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(toReturn);
            ses.logout();
            return new ItemList(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting paged children", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
            return new ItemList(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(toReturn);
        ses.logout();
        return new ItemList(toReturn);
    }

    /*
     * Exception decompiling
     */
    @GET
    @jakarta.ws.rs.Path(value="publiclink/{id}")
    @AuthorizationControl(allowedUsers={"URIResolver"})
    public Response resolvePublicLink() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Path(value="{id}/publiclink")
    public URL getPublicLink(@QueryParam(value="version") String version) {
        InnerMethodName.set((String)"getPubliclink");
        Session ses = null;
        URL toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                Node selectedNode = ses.getNodeByIdentifier(this.id);
                Item item = this.node2Item.getItem(selectedNode, Arrays.asList("hl:accounting", "hl:metadata"));
                if (!(item instanceof AbstractFileItem)) {
                    throw new InvalidCallParameters("the choosen item is not a File");
                }
                if (version != null) {
                    boolean versionFound = false;
                    VersionList versions = this.getVersions();
                    for (org.gcube.common.storagehub.model.service.Version v : versions.getItemlist()) {
                        if (!v.getName().equals(version)) continue;
                        versionFound = true;
                        break;
                    }
                    if (!versionFound) {
                        throw new InvalidCallParameters("the selected file has no version " + version);
                    }
                }
                String url = version != null ? this.publicLinkHandler.getForVersionedItem(this.id, version, this.context) : this.publicLinkHandler.getForItem(this.id, this.context);
                toReturn = new URL(url);
                return toReturn;
            }
            catch (MalformedURLException | RepositoryException re) {
                log.error("jcr error getting public link", re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError(re)));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @jakarta.ws.rs.Path(value="{id}/publish")
    @Produces(value={"application/json"})
    public String makeFolderPublic(@FormParam(value="publish") boolean publish) {
        InnerMethodName.set((String)("makeFolderPublic(" + publish + ")"));
        Session ses = null;
        Item folder = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node currentNode = ses.getNodeByIdentifier(this.id);
                log.trace("current node is {}", (Object)currentNode.getPath());
                folder = this.node2Item.getItem(currentNode, Excludes.ALL);
                if (!(folder instanceof FolderItem)) {
                    throw new InvalidCallParameters("item is not a folder");
                }
                currentNode.setProperty(NodeProperty.IS_PUBLIC.toString(), publish);
                ses.save();
                return this.id;
            }
            catch (RepositoryException re) {
                log.error("jcr error publishing folder", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses == null) return this.id;
                ses.logout();
                return this.id;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return this.id;
                ses.logout();
                return this.id;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @GET
    @jakarta.ws.rs.Path(value="{id}/rootSharedFolder")
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getRootSharedFolder(@QueryParam(value="exclude") List<String> excludes) {
        Item sharedParent;
        block10: {
            InnerMethodName.set((String)"getRootSharedFolder");
            Session ses = null;
            sharedParent = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                Node currentNode = ses.getNodeByIdentifier(this.id);
                log.trace("current node is {}", (Object)currentNode.getPath());
                Node sharedParentNode = this.getSharedParentNode(currentNode);
                if (sharedParentNode == null) {
                    throw new InvalidCallParameters("item is not shared");
                }
                sharedParent = this.node2Item.getItem(sharedParentNode, excludes);
            }
            catch (RepositoryException re) {
                log.error("jcr error getting rootSharedFolder", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block10;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block10;
            ses.logout();
        }
        return new ItemWrapper(sharedParent);
    }

    private Node getSharedParentNode(Node node) throws RepositoryException, BackendGenericError {
        Item currentItem = this.node2Item.getItem(node, Excludes.ALL);
        if (!currentItem.isShared()) {
            return null;
        }
        Node currentNode = node;
        while (!this.node2Item.checkNodeType(currentNode, SharedFolder.class)) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    @GET
    @jakarta.ws.rs.Path(value="{id}/versions")
    @Produces(value={"application/json"})
    public VersionList getVersions() {
        ArrayList<org.gcube.common.storagehub.model.service.Version> versions;
        block11: {
            InnerMethodName.set((String)"getVersions");
            Session ses = null;
            versions = new ArrayList<org.gcube.common.storagehub.model.service.Version>();
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                Node node = ses.getNodeByIdentifier(this.id);
                Item currentItem = this.node2Item.getItem(node, Excludes.GET_ONLY_CONTENT);
                if (!(currentItem instanceof AbstractFileItem)) {
                    throw new InvalidItemException("this item is not versioned");
                }
                List jcrVersions = this.versionHandler.getContentVersionHistory(node);
                for (Version version : jcrVersions) {
                    boolean currentVersion = ((AbstractFileItem)currentItem).getContent().getStorageId().equals(version.getFrozenNode().getProperty(NodeProperty.STORAGE_ID.toString()).getString());
                    versions.add(new org.gcube.common.storagehub.model.service.Version(version.getIdentifier(), version.getName(), version.getCreated(), currentVersion));
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error retrieving versions", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block11;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block11;
            ses.logout();
        }
        return new VersionList(versions);
    }

    @GET
    @jakarta.ws.rs.Path(value="{id}/versions/{version}/download")
    public Response downloadVersion(@PathParam(value="version") String versionName) {
        InnerMethodName.set((String)"downloadSpecificVersion");
        Session ses = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            Node node = ses.getNodeByIdentifier(this.id);
            Item currentItem = this.node2Item.getItem(node, Excludes.ALL);
            if (!(currentItem instanceof AbstractFileItem)) {
                throw new InvalidItemException("this item is not a file");
            }
            Response response = this.downloadHandler.downloadVersionedItem(ses, this.currentUser, (AbstractFileItem)currentItem, versionName, true);
            return response;
        }
        catch (RepositoryException re) {
            log.error("jcr error downloading version", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return Response.serverError().build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @jakarta.ws.rs.Path(value="{id}/versions/{version}")
    public void deleteVersion(@PathParam(value="version") String versionName) {
        InnerMethodName.set((String)"deleteVersion");
        Session ses = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node node = ses.getNodeByIdentifier(this.id);
                Item currentItem = this.node2Item.getItem(node, Excludes.GET_ONLY_CONTENT);
                if (!(currentItem instanceof AbstractFileItem)) {
                    throw new InvalidItemException("this item is not a file");
                }
                List versions = this.versionHandler.getContentVersionHistory(node);
                boolean found = false;
                for (Version version : versions) {
                    if (!version.getName().equals(versionName)) continue;
                    boolean currentVersion = ((AbstractFileItem)currentItem).getContent().getStorageId().equals(version.getFrozenNode().getProperty(NodeProperty.STORAGE_ID.toString()).getString());
                    if (currentVersion) {
                        throw new InvalidCallParameters("current version cannot be removed");
                    }
                    this.versionHandler.removeContentVersion(node, versionName);
                    this.accountingHandler.createVersionDeleted(currentItem.getTitle(), versionName, ses, node, this.currentUser, false);
                    ses.save();
                    found = true;
                    break;
                }
                if (found) return;
                throw new InvalidItemException("the version " + versionName + " is not valid or is current version for item " + currentItem.getTitle());
            }
            catch (RepositoryException re) {
                log.error("jcr error removing version", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses == null) return;
                ses.logout();
                return;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return;
                ses.logout();
                return;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @GET
    @jakarta.ws.rs.Path(value="{id}/anchestors")
    @Produces(value={"application/json"})
    public ItemList getAnchestors(@QueryParam(value="exclude") List<String> excludes) {
        LinkedList<Item> toReturn;
        block14: {
            InnerMethodName.set((String)"getAnchestors");
            Path absolutePath = this.pathUtil.getWorkspacePath(this.currentUser);
            Session ses = null;
            toReturn = new LinkedList<Item>();
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                Node currentNode = ses.getNodeByIdentifier(this.id);
                Item currentItem = this.node2Item.getItem(currentNode, excludes);
                log.trace("current node is {}", (Object)currentNode.getPath());
                while (!currentNode.getPath().matches("/Home/[^/]{1,}/Workspace")) {
                    if (currentItem instanceof SharedFolder) {
                        NodeIterator sharedSetIterator = currentNode.getSharedSet();
                        boolean found = false;
                        while (sharedSetIterator.hasNext()) {
                            Node sharedNode = sharedSetIterator.nextNode();
                            if (!sharedNode.getPath().startsWith(absolutePath.toPath())) continue;
                            currentNode = sharedNode.getParent();
                            found = true;
                            break;
                        }
                        if (!found) break;
                        currentItem = this.node2Item.getItem(currentNode, excludes);
                    } else {
                        currentNode = currentNode.getParent();
                        currentItem = this.node2Item.getItem(currentNode, excludes);
                    }
                    log.trace("current node is {}", (Object)currentNode.getPath());
                    toReturn.add(currentItem);
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error getting anchestors", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block14;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block14;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block14;
            ses.logout();
        }
        log.trace("item list to return is empty ? {}", (Object)toReturn.isEmpty());
        return new ItemList(toReturn);
    }

    @GET
    @jakarta.ws.rs.Path(value="{id}/download")
    public Response download(@QueryParam(value="exclude") List<String> excludes) {
        InnerMethodName.set((String)"downloadById");
        Session ses = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            Node node = ses.getNodeByIdentifier(this.id);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            Item item = this.node2Item.getItem(node, null);
            if (item instanceof AbstractFileItem) {
                Response response = this.downloadHandler.downloadFileItem(ses, (AbstractFileItem)item, this.currentUser, true);
                return response;
            }
            if (item instanceof FolderItem) {
                Response response = this.downloadHandler.downloadFolderItem(ses, this.currentUser, (FolderItem)item, true);
                return response;
            }
            try {
                throw new InvalidItemException("item type not supported for download: " + String.valueOf(item.getClass()));
            }
            catch (RepositoryException re) {
                log.error("jcr error download", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @jakarta.ws.rs.Path(value="{id}/move")
    public String move(@FormParam(value="destinationId") String destinationId) {
        InnerMethodName.set((String)"move");
        Session ses = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkMoveOpsForProtectedFolders(ses, this.id);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, destinationId, true);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node nodeToMove = ses.getNodeByIdentifier(this.id);
                Node destination = ses.getNodeByIdentifier(destinationId);
                Node originalParent = nodeToMove.getParent();
                Item destinationItem = this.node2Item.getItem(destination, null);
                Item item = this.node2Item.getItem(nodeToMove, null);
                if (item instanceof SharedFolder) {
                    throw new InvalidItemException("shared folder cannot be moved");
                }
                if (item instanceof FolderItem && Utils.hasSharedChildren((Node)nodeToMove)) {
                    throw new InvalidItemException("folder item with shared children cannot be moved");
                }
                if (Constants.FOLDERS_TO_EXLUDE.contains(item.getTitle()) || Constants.FOLDERS_TO_EXLUDE.contains(destinationItem.getTitle())) {
                    throw new InvalidItemException("protected folder cannot be moved");
                }
                if (!(destinationItem instanceof FolderItem)) {
                    throw new InvalidItemException("destination item is not a folder");
                }
                boolean movingSharedItemOutside = item.isShared() && (!destinationItem.isShared() || !this.getSharedParentNode(nodeToMove).getIdentifier().equals(this.getSharedParentNode(destination).getIdentifier()));
                try {
                    ses.getWorkspace().getLockManager().lock(destination.getPath(), false, true, 0L, this.currentUser);
                    ses.getWorkspace().getLockManager().lock(nodeToMove.getPath(), true, true, 0L, this.currentUser);
                }
                catch (LockException e) {
                    throw new ItemLockedException((Throwable)e);
                }
                try {
                    String mimeTypeForAccounting;
                    String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)destination, (String)nodeToMove.getName());
                    String newPath = String.format("%s/%s", destination.getPath(), uniqueName);
                    ses.move(nodeToMove.getPath(), newPath);
                    Utils.setPropertyOnChangeNode((Node)ses.getNode(newPath), (String)this.currentUser, (ItemAction)ItemAction.MOVED);
                    String string = mimeTypeForAccounting = item instanceof AbstractFileItem ? ((AbstractFileItem)item).getContent().getMimeType() : null;
                    if (movingSharedItemOutside) {
                        this.item2Node.updateOwnerOnSubTree(nodeToMove, this.currentUser);
                    }
                    this.accountingHandler.createFolderAddObj(uniqueName, item.getClass().getSimpleName(), mimeTypeForAccounting, ses, this.currentUser, destination, false);
                    this.accountingHandler.createFolderRemoveObj(item.getTitle(), item.getClass().getSimpleName(), mimeTypeForAccounting, ses, this.currentUser, originalParent, false);
                    ses.save();
                    return this.id;
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToMove.getPath());
                    ses.getWorkspace().getLockManager().unlock(destination.getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses == null) return this.id;
                ses.logout();
                return this.id;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return this.id;
                ses.logout();
                return this.id;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @jakarta.ws.rs.Path(value="{id}/copy")
    public String copy(@FormParam(value="destinationId") String destinationId, @FormParam(value="fileName") String newFileName) {
        InnerMethodName.set((String)"copy");
        Session ses = null;
        String newFileIdentifier = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, destinationId, true);
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
                Node nodeToCopy = ses.getNodeByIdentifier(this.id);
                Node destination = ses.getNodeByIdentifier(destinationId);
                FolderItem destinationItem = (FolderItem)this.node2Item.getItem(destination, null);
                Item item = this.node2Item.getItem(nodeToCopy, Arrays.asList("hl:accounting", "hl:metadata"));
                if (item instanceof FolderItem) {
                    throw new InvalidItemException("folder cannot be copied");
                }
                try {
                    ses.getWorkspace().getLockManager().lock(destination.getPath(), false, true, 0L, this.currentUser);
                    ses.getWorkspace().getLockManager().lock(nodeToCopy.getPath(), true, true, 0L, this.currentUser);
                }
                catch (LockException e) {
                    throw new ItemLockedException((Throwable)e);
                }
                try {
                    String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)destination, (String)newFileName);
                    String newPath = String.format("%s/%s", destination.getPath(), uniqueName);
                    ses.getWorkspace().copy(nodeToCopy.getPath(), newPath);
                    Node newNode = ses.getNode(newPath);
                    newFileIdentifier = newNode.getIdentifier();
                    Content contentToCopy = ((AbstractFileItem)item).getContent();
                    MetaInfo contentInfo = this.opMediator.copy(contentToCopy, destinationItem.getBackend(), destination.getPath(), uniqueName, this.currentUser);
                    this.item2Node.replaceContent(newNode, (AbstractFileItem)item, ItemAction.CLONED);
                    Utils.setContentFromMetaInfo((AbstractFileItem)((AbstractFileItem)item), (MetaInfo)contentInfo);
                    Utils.setPropertyOnChangeNode((Node)newNode, (String)this.currentUser, (ItemAction)ItemAction.CLONED);
                    newNode.setProperty(NodeProperty.PORTAL_LOGIN.toString(), this.currentUser);
                    newNode.setProperty(NodeProperty.IS_PUBLIC.toString(), false);
                    newNode.setProperty(NodeProperty.TITLE.toString(), uniqueName);
                    String mimeTypeForAccounting = ((AbstractFileItem)item).getContent().getMimeType();
                    this.accountingHandler.createFolderAddObj(uniqueName, item.getClass().getSimpleName(), mimeTypeForAccounting, ses, this.currentUser, destination, false);
                    ses.save();
                    return newFileIdentifier;
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToCopy.getPath());
                    ses.getWorkspace().getLockManager().unlock(destination.getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses == null) return newFileIdentifier;
                ses.logout();
                return newFileIdentifier;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return newFileIdentifier;
                ses.logout();
                return newFileIdentifier;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @PUT
    @jakarta.ws.rs.Path(value="{id}/rename")
    public Response rename(@FormParam(value="newName") String newName) {
        block16: {
            InnerMethodName.set((String)"rename");
            Session ses = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkMoveOpsForProtectedFolders(ses, this.id);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node nodeToMove = ses.getNodeByIdentifier(this.id);
                Item item = this.node2Item.getItem(nodeToMove, null);
                if (item instanceof SharedFolder && this.getSharedParentNode(nodeToMove).getIdentifier() == item.getId()) {
                    throw new InvalidItemException("root shared folder name cannot be modfied");
                }
                String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)nodeToMove.getParent(), (String)newName);
                try {
                    ses.getWorkspace().getLockManager().lock(nodeToMove.getPath(), true, true, 0L, this.currentUser);
                    ses.getWorkspace().getLockManager().lock(nodeToMove.getParent().getPath(), false, true, 0L, this.currentUser);
                }
                catch (LockException e) {
                    throw new ItemLockedException((Throwable)e);
                }
                try {
                    String newPath = String.format("%s/%s", nodeToMove.getParent().getPath(), uniqueName);
                    nodeToMove.setProperty(NodeProperty.TITLE.toString(), uniqueName);
                    Utils.setPropertyOnChangeNode((Node)nodeToMove, (String)this.currentUser, (ItemAction)ItemAction.RENAMED);
                    ses.move(nodeToMove.getPath(), newPath);
                    this.accountingHandler.createRename(item.getTitle(), uniqueName, ses.getNode(newPath), this.currentUser, ses, false);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToMove.getPath());
                    ses.getWorkspace().getLockManager().unlock(nodeToMove.getParent().getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block16;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block16;
            ses.logout();
        }
        return Response.ok((Object)this.id).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @jakarta.ws.rs.Path(value="/{id}/hidden")
    public Response setItemAsHidden(Boolean hidden) {
        block15: {
            InnerMethodName.set((String)"setHidden");
            Session ses = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node nodeToUpdate = ses.getNodeByIdentifier(this.id);
                try {
                    ses.getWorkspace().getLockManager().lock(nodeToUpdate.getPath(), false, true, 0L, this.currentUser);
                }
                catch (LockException e) {
                    throw new ItemLockedException((Throwable)e);
                }
                try {
                    this.item2Node.updateHidden(nodeToUpdate, hidden, this.currentUser);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToUpdate.getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block15;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block15;
            ses.logout();
        }
        return Response.ok((Object)this.id).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @jakarta.ws.rs.Path(value="/{id}/description")
    public Response setDescription(String description) {
        block15: {
            InnerMethodName.set((String)"setDescription");
            Session ses = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node nodeToUpdate = ses.getNodeByIdentifier(this.id);
                try {
                    ses.getWorkspace().getLockManager().lock(nodeToUpdate.getPath(), false, true, 0L, this.currentUser);
                }
                catch (LockException e) {
                    throw new ItemLockedException((Throwable)e);
                }
                try {
                    this.item2Node.updateDescription(nodeToUpdate, description, this.currentUser);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToUpdate.getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block15;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block15;
            ses.logout();
        }
        return Response.ok((Object)this.id).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @jakarta.ws.rs.Path(value="/{id}/metadata")
    public Response setMetadata(Metadata metadata) {
        block15: {
            InnerMethodName.set((String)"updateMetadata");
            Session ses = null;
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
                Node nodeToUpdate = ses.getNodeByIdentifier(this.id);
                try {
                    ses.getWorkspace().getLockManager().lock(nodeToUpdate.getPath(), false, true, 0L, this.currentUser);
                }
                catch (LockException e) {
                    throw new ItemLockedException((Throwable)e);
                }
                try {
                    this.item2Node.updateMetadataNode(nodeToUpdate, metadata.getMap(), this.currentUser);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToUpdate.getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block15;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block15;
            ses.logout();
        }
        return Response.ok((Object)this.id).build();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @jakarta.ws.rs.Path(value="{id}")
    public Response deleteItem(@QueryParam(value="force") boolean force) {
        InnerMethodName.set((String)("deleteItem(" + force + ")"));
        Session ses = null;
        try {
            log.info("removing node with id {}", (Object)this.id);
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, false);
            this.authChecker.checkMoveOpsForProtectedFolders(ses, this.id);
            Node nodeToDelete = ses.getNodeByIdentifier(this.id);
            Item itemToDelete = this.node2Item.getItem(nodeToDelete, Excludes.GET_ONLY_CONTENT);
            if (itemToDelete instanceof SharedFolder || itemToDelete instanceof VreFolder || itemToDelete instanceof FolderItem && Utils.hasSharedChildren((Node)nodeToDelete)) {
                throw new InvalidItemException("SharedFolder, VreFolder or folders with shared children cannot be deleted");
            }
            if (itemToDelete.isExternalManaged() && !force) {
                throw new InvalidItemException("External managed Items cannot be moved to Trash");
            }
            log.debug("item is trashed? {}", (Object)itemToDelete.isTrashed());
            if (!itemToDelete.isTrashed() && !force) {
                this.trashHandler.moveToTrash(ses, nodeToDelete, itemToDelete, this.currentUser);
            } else {
                this.trashHandler.removeNodes(ses, Collections.singletonList(itemToDelete));
            }
        }
        catch (LockException lockException) {
            if (ses == null) return Response.ok().build();
            ses.logout();
            return Response.ok().build();
        }
        catch (RepositoryException re) {
            log.error("jcr error moving item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
            return Response.ok().build();
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return Response.ok().build();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return Response.ok().build();
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return Response.ok().build();
        ses.logout();
        return Response.ok().build();
    }

    @jakarta.ws.rs.Path(value="{id}/info")
    @GET
    @Produces(value={"application/json"})
    public FolderInfoType getFolderInfo() {
        InnerMethodName.set((String)"getFolderInfo");
        Session ses = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            Node node = ses.getNodeByIdentifier(this.id);
            Item item = this.node2Item.getItem(node, Excludes.ALL);
            if (!(item instanceof FolderItem)) {
                throw new InvalidCallParameters("the item is not a folder");
            }
            FolderInfoType folderInfoType = Utils.getFolderInfo((Node)node);
            return folderInfoType;
        }
        catch (RepositoryException re) {
            log.error("error getting workspace total size", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new FolderInfoType(0L, 0L);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$access$storagehub$types$LinkType() {
        if ($SWITCH_TABLE$org$gcube$data$access$storagehub$types$LinkType != null) {
            return $SWITCH_TABLE$org$gcube$data$access$storagehub$types$LinkType;
        }
        int[] nArray = new int[LinkType.values().length];
        try {
            nArray[LinkType.STANDARD.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[LinkType.VERSIONED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[LinkType.VOLATILE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$data$access$storagehub$types$LinkType = nArray;
        return nArray;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ItemsManager.java", ItemsManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resolvePublicLink", "org.gcube.data.access.storagehub.services.ItemsManager", "", "", "", "jakarta.ws.rs.core.Response"), 405);
    }
}

