/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="api-docs")
public class DocsGenerator {
    private static Logger logger = LoggerFactory.getLogger(DocsGenerator.class);

    @GET
    @Path(value="/{any: .*}")
    public InputStream toDoc(@Context HttpServletRequest req) throws WebApplicationException {
        logger.info(DocsGenerator.class.getSimpleName() + " toDoc called");
        Object pathInfo = req.getPathInfo();
        logger.debug("pathInfo {}", pathInfo);
        try {
            if (((String)pathInfo).endsWith("/api-docs")) {
                pathInfo = (String)pathInfo + "index.html";
            }
            if (((String)pathInfo).endsWith("/api-docs/")) {
                pathInfo = (String)pathInfo + "index.html";
            }
            logger.info("going to {}", pathInfo);
            String realPath = req.getServletContext().getRealPath((String)pathInfo);
            return new FileInputStream(new File(realPath));
        }
        catch (Exception e) {
            logger.error("error getting the docs", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
    }
}

