/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.items.VreFolder;
import org.gcube.common.storagehub.model.types.ACLList;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.StorageHubApplicationManager;
import org.gcube.data.access.storagehub.handlers.ACLHandler;
import org.gcube.data.access.storagehub.handlers.UnshareHandler;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.repository.StoragehubRepository;
import org.gcube.data.access.storagehub.services.Impersonable;
import org.gcube.data.access.storagehub.services.interfaces.ACLManagerInterface;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
@ManagedBy(value=StorageHubApplicationManager.class)
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources")})
public class ACLManager
extends Impersonable {
    private static final Logger log = LoggerFactory.getLogger(ACLManager.class);
    StoragehubRepository repository = StoragehubRepository.repository;
    @Inject
    ACLHandler aclHandler;
    @RequestScoped
    @PathParam(value="id")
    String id;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    PathUtil pathUtil;
    @Context
    ServletContext context;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    UnshareHandler unshareHandler;
    @Inject
    ACLManagerInterface aclManagerDelegate;

    @GET
    @Path(value="{id}/acls")
    @Produces(value={"application/json"})
    public ACLList getACL() {
        InnerMethodName.set((String)"getACLById");
        Session ses = null;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            Item item = this.node2Item.getItem(ses.getNodeByIdentifier(this.id), Excludes.ALL);
            this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, this.id);
            ACLList aCLList = new ACLList(this.aclManagerDelegate.getByItem(item, ses));
            return aCLList;
        }
        catch (RepositoryException re) {
            log.error("jcr error getting acl", (Throwable)re);
            throw new WebApplicationException((Throwable)new BackendGenericError("jcr error getting acl", (Throwable)re));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            throw new WebApplicationException((Throwable)she, Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @PUT
    @Consumes(value={"multipart/form-data"})
    @Path(value="{id}/acls")
    public void updateACL(@FormDataParam(value="user") String user, @FormDataParam(value="access") AccessType accessType) {
        InnerMethodName.set((String)"setACLById");
        Session ses = null;
        try {
            try {
                if (user == this.currentUser) {
                    throw new InvalidCallParameters("own ACLs cannot be modified");
                }
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                Node node = ses.getNodeByIdentifier(this.id);
                Item item = this.node2Item.getItem(node, Excludes.ALL);
                if (!(item instanceof SharedFolder)) {
                    throw new InvalidItemException("the item is not a shared folder");
                }
                if (item.getOwner().equals(user)) {
                    throw new UserNotAuthorizedException("owner acl cannot be changed");
                }
                SharedFolder folder = (SharedFolder)item;
                this.authChecker.checkAdministratorControl(ses, this.currentUser, folder);
                if (item instanceof VreFolder || folder.isVreFolder()) {
                    throw new InvalidCallParameters("acls in vreFolder cannot be updated with this method");
                }
                NodeIterator sharedSet = node.getSharedSet();
                boolean found = false;
                while (sharedSet.hasNext() && !found) {
                    Node current = sharedSet.nextNode();
                    if (!current.getPath().startsWith(this.pathUtil.getWorkspacePath(user).toPath())) continue;
                    found = true;
                }
                if (!found) {
                    throw new InvalidCallParameters("shared folder with id " + folder.getId() + " is not shared with user " + user);
                }
                this.aclManagerDelegate.update(user, node, accessType, ses);
            }
            catch (RepositoryException re) {
                log.error("jcr error extracting archive", (Throwable)re);
                throw new WebApplicationException((Throwable)new BackendGenericError("jcr error setting acl", (Throwable)re));
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                throw new WebApplicationException((Throwable)she, Response.Status.fromStatusCode((int)she.getStatus()));
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @Consumes(value={"text/plain"})
    @Path(value="{id}/acls/{user}")
    public void removeACL(@PathParam(value="user") String user) {
        InnerMethodName.set((String)"removeACLById");
        Session ses = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
                Node node = ses.getNodeByIdentifier(this.id);
                Item item = this.node2Item.getItem(node, Excludes.ALL);
                if (!(item instanceof SharedFolder)) {
                    throw new InvalidItemException("the item is not a shared folder");
                }
                if (item instanceof VreFolder || ((SharedFolder)item).isVreFolder()) {
                    throw new InvalidCallParameters("acls in vreFolder cannot be removed with this method");
                }
                this.authChecker.checkAdministratorControl(ses, this.currentUser, (SharedFolder)item);
                this.unshareHandler.unshare(ses, Collections.singleton(user), node, this.currentUser);
                return;
            }
            catch (RepositoryException re) {
                log.error("jcr error extracting archive", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error removing acl", (Throwable)re)));
                if (ses == null) return;
                ses.logout();
                return;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return;
                ses.logout();
                return;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @GET
    @Path(value="{id}/acls/write")
    public Boolean canWriteInto() {
        InnerMethodName.set((String)"canWriteIntoFolder");
        Session ses = null;
        Boolean canWrite = false;
        try {
            ses = this.repository.getRepository().login((Credentials)Constants.JCR_CREDENTIALS);
            Node node = ses.getNodeByIdentifier(this.id);
            Item item = this.node2Item.getItem(node, Excludes.ALL);
            if (!(item instanceof FolderItem)) {
                throw new InvalidItemException("this method can be applied only to folder");
            }
            try {
                this.authChecker.checkWriteAuthorizationControl(ses, this.currentUser, this.id, true);
            }
            catch (UserNotAuthorizedException userNotAuthorizedException) {
                Boolean bl = false;
                if (ses != null) {
                    ses.logout();
                }
                return bl;
            }
            Boolean bl = true;
            return bl;
        }
        catch (RepositoryException re) {
            log.error("jcr error getting acl", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error getting acl", (Throwable)re)));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return canWrite;
    }
}

