/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.common.storagehub.model.annotations.RootNode;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.RootItem;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassHandler {
    private static Logger log = LoggerFactory.getLogger(ClassHandler.class);
    private static ClassHandler instance = null;
    private Reflections reflection = new Reflections(new Object[0]);
    private List<String> deprecatedNode = Arrays.asList("nthl:query", "nthl:aquamapsItem", "nthl:timeSeriesItem", "nthl:report", "nthl:reportTemplate", "nthl:workflowReport", "nthl:workflowTemplate", "nthl:gCubeMetadata", "nthl:gCubeDocument", "nthl:gCubeDocumentLink", "nthl:gCubeImageDocumentLink", "nthl:gCubePDFDocumentLink", "nthl:gCubeImageDocument", "nthl:gCubePDFDocument", "nthl:gCubeURLDocument", "nthl:gCubeAnnotation", "nthl:externalResourceLink", "nthl:tabularDataLink");
    private Map<String, Class<? extends RootItem>> classMap = new HashMap();
    private Map<Class<? extends RootItem>, String> typeMap = new HashMap();

    public static ClassHandler instance() {
        if (instance == null) {
            instance = new ClassHandler();
        }
        return instance;
    }

    private ClassHandler() {
        Set classesAnnotated = this.reflection.getTypesAnnotatedWith(RootNode.class);
        for (Class clazz : classesAnnotated) {
            if (!RootItem.class.isAssignableFrom(clazz) || !clazz.isAnnotationPresent(RootNode.class)) continue;
            String[] values = clazz.getAnnotation(RootNode.class).value();
            log.debug("loading class {} with values {} ", (Object)clazz, (Object)values);
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.classMap.put(value, clazz);
                ++n2;
            }
            this.typeMap.put(clazz, values[0]);
        }
    }

    public Class<? extends RootItem> get(String nodeType) {
        if (this.classMap.containsKey(nodeType)) {
            return (Class)this.classMap.get(nodeType);
        }
        if (this.deprecatedNode.contains(nodeType)) {
            return Item.class;
        }
        return null;
    }

    public String getNodeType(Class<? extends RootItem> clazz) {
        if (this.typeMap.containsKey(clazz)) {
            return (String)this.typeMap.get(clazz);
        }
        throw new RuntimeException("mapping not found for nodetype " + clazz.getSimpleName());
    }
}

