/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.query.Query;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.IdNotFoundException;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.ExternalLink;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.GCubeItem;
import org.gcube.common.storagehub.model.items.GenericFileItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.RootItem;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.types.FolderInfoType;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.NodeChildrenFilterIterator;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.items.builders.FolderCreationParameters;
import org.gcube.data.access.storagehub.handlers.plugins.StorageBackendHandler;
import org.gcube.data.access.storagehub.predicates.IncludeTypePredicate;
import org.gcube.data.access.storagehub.predicates.ItemTypePredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    public static final String SERVICE_NAME = "home-library";
    public static final String SERVICE_CLASS = "org.gcube.portlets.user";
    private static final String FOLDERS_TYPE = "nthl:workspaceItem";
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String getSecurePassword(String user) throws Exception {
        String digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(user.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder(2 * hash.length);
            byte[] byArray = hash;
            int n = hash.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                sb.append(String.format("%02x", b & 0xFF));
                ++n2;
            }
            digest = sb.toString();
        }
        catch (Exception e) {
            logger.error("error getting secure password", (Throwable)e);
        }
        return digest;
    }

    public static long getItemCount(Node parent, boolean showHidden, ItemTypePredicate itemTypePredicate) throws RepositoryException, BackendGenericError {
        return Utils.getItemList((Node)parent, (List)Excludes.ALL, null, (boolean)showHidden, (ItemTypePredicate)itemTypePredicate).size();
    }

    @Deprecated
    public static long countSubItems(Node parent) throws RepositoryException, BackendGenericError {
        long count = 0L;
        List items = Utils.getItemList((Node)parent, (List)Excludes.ALL, null, (boolean)false, null);
        for (Item item : items) {
            if (!(item instanceof FolderItem)) continue;
            count += Utils.countSubItems((Node)((Node)item.getRelatedNode()));
        }
        return count += (long)items.size();
    }

    @Deprecated
    public static long getSubItemsSize(Node parent) throws RepositoryException, BackendGenericError {
        long size = 0L;
        List items = Utils.getItemList((Node)parent, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)false, (ItemTypePredicate)new IncludeTypePredicate(Arrays.asList(GenericFileItem.class, FolderItem.class)));
        for (Item item : items) {
            if (item instanceof FolderItem) {
                size += Utils.getSubItemsSize((Node)((Node)item.getRelatedNode()));
                continue;
            }
            if (!(item instanceof AbstractFileItem)) continue;
            AbstractFileItem gfi = (AbstractFileItem)item;
            size += gfi.getContent().getSize().longValue();
        }
        return size;
    }

    public static FolderInfoType getFolderInfo(Node parent) throws RepositoryException, BackendGenericError {
        FolderInfoType info = new FolderInfoType(0L, 0L);
        List items = Utils.getItemList((Node)parent, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)false, null);
        for (Item item : items) {
            if (item instanceof FolderItem) {
                FolderInfoType fit = Utils.getFolderInfo((Node)((Node)item.getRelatedNode()));
                info.setCount(info.getCount() + fit.getCount());
                info.setSize(info.getSize() + fit.getSize());
                continue;
            }
            if (!(item instanceof AbstractFileItem)) continue;
            AbstractFileItem gfi = (AbstractFileItem)item;
            info.setSize(info.getSize() + gfi.getContent().getSize());
        }
        info.setCount(info.getCount() + (long)items.size());
        return info;
    }

    public static void acquireLockWithWait(Session ses, String nodePath, boolean isDeep, String login, int maxTries) throws RepositoryException, ItemLockedException {
        Lock lock = null;
        int tries = 0;
        while (lock == null && tries <= maxTries) {
            try {
                lock = ses.getWorkspace().getLockManager().lock(nodePath, isDeep, true, 0L, login);
                logger.info("lock acquired(try n. {})", (Object)tries);
            }
            catch (LockException lockException) {
                try {
                    if (maxTries >= tries) {
                        int waitTime = (int)(Math.random() * 5000.0);
                        logger.info("lock NOT acquired, waiting (try n. {}) for {}", (Object)tries, (Object)waitTime);
                        Thread.sleep(waitTime);
                    }
                }
                catch (InterruptedException interruptedException) {}
                ++tries;
            }
        }
        if (lock == null) {
            throw new ItemLockedException("the item is locked");
        }
    }

    public static <T extends Item> List<T> searchByNameOnFolder(Session ses, String user, AuthorizationChecker authChecker, Node parent, List<String> excludes, Range range, boolean showHidden, boolean excludeTrashed, ItemTypePredicate itemTypePredicate, String nameParam) throws RepositoryException, BackendGenericError {
        String xpath = String.format("/jcr:root%s//element(*,nthl:workspaceItem)[jcr:like(fn:lower-case(@jcr:title), '%s')]", ISO9075.encodePath((String)parent.getPath()), nameParam.toLowerCase());
        logger.trace("query for search is {}", (Object)xpath);
        long start = System.currentTimeMillis();
        Query jcrQuery = ses.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
        NodeChildrenFilterIterator iterator = new NodeChildrenFilterIterator(jcrQuery.execute().getNodes());
        logger.trace("[SEARCH] real search took {} millis", (Object)(System.currentTimeMillis() - start));
        1 checker = new /* Unavailable Anonymous Inner Class!! */;
        return Utils.getItemListFromNodeIterator((Predicate)checker, (NodeChildrenFilterIterator)iterator, excludes, (Range)range, (boolean)showHidden, (boolean)excludeTrashed, (ItemTypePredicate)itemTypePredicate);
    }

    public static <T extends Item> List<T> getItemList(Node parent, List<String> excludes, Range range, boolean showHidden, ItemTypePredicate itemTypePredicate) throws RepositoryException, BackendGenericError {
        return Utils.getItemList(null, (Node)parent, excludes, (Range)range, (boolean)showHidden, (ItemTypePredicate)itemTypePredicate);
    }

    public static <T extends Item> List<T> getItemList(Predicate<Node> checker, Node parent, List<String> excludes, Range range, boolean showHidden, ItemTypePredicate itemTypePredicate) throws RepositoryException, BackendGenericError {
        logger.trace("getting children of node {}", (Object)parent.getIdentifier());
        long start = System.currentTimeMillis();
        NodeChildrenFilterIterator iterator = new NodeChildrenFilterIterator(parent);
        logger.trace("time to get iterator {}", (Object)(System.currentTimeMillis() - start));
        return Utils.getItemListFromNodeIterator(checker, (NodeChildrenFilterIterator)iterator, excludes, (Range)range, (boolean)showHidden, (boolean)false, (ItemTypePredicate)itemTypePredicate);
    }

    private static <T extends Item> List<T> getItemListFromNodeIterator(Predicate<Node> checker, NodeChildrenFilterIterator iterator, List<String> excludes, Range range, boolean showHidden, boolean excludeTrashed, ItemTypePredicate itemTypePredicate) throws RepositoryException, BackendGenericError {
        ArrayList<Item> returnList = new ArrayList<Item>();
        int count = 0;
        logger.trace("selected range is {}", (Object)range);
        Node2ItemConverter node2Item = new Node2ItemConverter();
        HashSet<String> duplicateId = new HashSet<String>();
        while (iterator.hasNext()) {
            Node current = iterator.next();
            logger.trace("[SEARCH] evaluating node {} ", current.hasProperty(NodeProperty.TITLE.toString()) ? current.getProperty(NodeProperty.TITLE.toString()) : current.getName());
            if (duplicateId.contains(current.getIdentifier())) {
                logger.warn("duplicated node found");
                continue;
            }
            if (checker != null && !checker.test(current) || Utils.isToExclude((Node)current, (boolean)showHidden)) continue;
            logger.trace("[SEARCH] current node not excluded {} ", current.hasProperty(NodeProperty.TITLE.toString()) ? current.getProperty(NodeProperty.TITLE.toString()) : current.getName());
            if (range == null || count >= range.getStart() && returnList.size() < range.getLimit()) {
                Item item = node2Item.getFilteredItem(current, excludes, itemTypePredicate);
                if (item == null || item.isTrashed() && excludeTrashed) continue;
                returnList.add(item);
            }
            ++count;
            duplicateId.add(current.getIdentifier());
        }
        return returnList;
    }

    private static boolean isToExclude(Node node, boolean showHidden) throws RepositoryException {
        return node.getName().startsWith("rep:") || node.getName().startsWith("hl:") || !showHidden && node.hasProperty(NodeProperty.HIDDEN.toString()) && node.getProperty(NodeProperty.HIDDEN.toString()).getBoolean() || node.getPrimaryNodeType().getName().equals("nthl:workspaceItem") && Constants.FOLDERS_TO_EXLUDE.contains(node.getName());
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[2048];
        int readcount = 0;
        while ((readcount = in.read(buffer)) != -1) {
            out.write(buffer, 0, readcount);
        }
    }

    public static boolean hasSharedChildren(Node node) throws RepositoryException, BackendGenericError {
        Node2ItemConverter node2Item = new Node2ItemConverter();
        NodeChildrenFilterIterator children = new NodeChildrenFilterIterator(node);
        while (children.hasNext()) {
            Node child = children.next();
            if (node2Item.checkNodeType(child, SharedFolder.class)) {
                return true;
            }
            if (!node2Item.checkNodeType(child, FolderItem.class) || !Utils.hasSharedChildren((Node)child)) continue;
            return true;
        }
        return false;
    }

    public static String checkExistanceAndGetUniqueName(Session ses, Node destination, String name) throws BackendGenericError {
        String escapedName = Text.escapeIllegalJcrChars((String)name);
        try {
            destination.getNode(escapedName);
        }
        catch (PathNotFoundException pathNotFoundException) {
            return escapedName;
        }
        catch (Exception e) {
            throw new BackendGenericError((Throwable)e);
        }
        try {
            String filename = FilenameUtils.getBaseName((String)escapedName);
            String ext = FilenameUtils.getExtension((String)escapedName);
            String nameTocheck = ext.isEmpty() ? String.format("%s(*)", filename) : String.format("%s(*).%s", filename, ext);
            logger.trace("filename is {}, extension is {} , and name to check is {}", new Object[]{filename, ext, nameTocheck});
            NodeIterator ni = destination.getNodes(nameTocheck);
            int maxval = 0;
            while (ni.hasNext()) {
                Node n = ni.nextNode();
                int actual = Integer.parseInt(n.getName().replaceAll(String.format("%s\\((\\d*)\\).*", filename), "$1"));
                if (actual <= maxval) continue;
                maxval = actual;
            }
            String newName = ext.isEmpty() ? String.format("%s(%d)", filename, maxval + 1) : String.format("%s(%d).%s", filename, maxval + 1, ext);
            return newName;
        }
        catch (Exception e) {
            throw new BackendGenericError((Throwable)e);
        }
    }

    public static Node createFolderInternally(FolderCreationParameters params, AccountingHandler accountingHandler, boolean isInternalWSFolder) throws StorageHubException {
        FolderItem destinationItem;
        Node destinationNode;
        logger.debug("creating folder {} in {}", (Object)params.getName(), (Object)params.getParentId());
        try {
            destinationNode = params.getSession().getNodeByIdentifier(params.getParentId());
            destinationItem = (FolderItem)new Node2ItemConverter().getItem(destinationNode, Excludes.ALL);
        }
        catch (RepositoryException e) {
            logger.error("id not found", (Throwable)e);
            throw new IdNotFoundException(params.getParentId());
        }
        String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)params.getSession(), (Node)destinationNode, (String)params.getName());
        FolderItem item = new FolderItem();
        Calendar now = Calendar.getInstance();
        item.setName(uniqueName);
        item.setTitle(uniqueName);
        item.setDescription(params.getDescription());
        if (isInternalWSFolder) {
            item.setBackend(StorageBackendHandler.getDefaultPayloadForFolder());
        } else if (params.getBackend() != null) {
            item.setBackend(params.getBackend());
        } else if (destinationItem.getBackend() != null) {
            item.setBackend(destinationItem.getBackend());
        } else {
            item.setBackend(StorageBackendHandler.getDefaultPayloadForFolder());
        }
        boolean hiddenDestNode = false;
        try {
            hiddenDestNode = destinationNode.getProperty(NodeProperty.HIDDEN.toString()).getBoolean();
        }
        catch (Throwable throwable) {}
        item.setHidden(params.isHidden() || hiddenDestNode);
        item.setLastAction(ItemAction.CREATED);
        item.setLastModificationTime(now);
        item.setLastModifiedBy(params.getUser());
        item.setOwner(params.getUser());
        item.setPublicItem(false);
        Node newNode = new Item2NodeConverter().getNode(destinationNode, (RootItem)item);
        if (accountingHandler != null) {
            accountingHandler.createFolderAddObj(uniqueName, item.getClass().getSimpleName(), null, params.getSession(), params.getUser(), destinationNode, false);
            accountingHandler.createEntryCreate(item.getTitle(), params.getSession(), newNode, params.getUser(), false);
        }
        return newNode;
    }

    public static Node createURLInternally(Session ses, Node destinationNode, String name, URL value, String description, String login, AccountingHandler accountingHandler) throws BackendGenericError {
        String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)destinationNode, (String)name);
        ExternalLink item = new ExternalLink();
        Calendar now = Calendar.getInstance();
        item.setName(uniqueName);
        item.setTitle(uniqueName);
        item.setDescription(description);
        item.setLastAction(ItemAction.CREATED);
        item.setLastModificationTime(now);
        item.setLastModifiedBy(login);
        item.setOwner(login);
        item.setPublicItem(false);
        item.setValue(value);
        try {
            item.setHidden(destinationNode.getProperty(NodeProperty.HIDDEN.toString()).getBoolean());
        }
        catch (Throwable throwable) {
            item.setHidden(false);
        }
        Node newNode = new Item2NodeConverter().getNode(destinationNode, (RootItem)item);
        if (accountingHandler != null) {
            accountingHandler.createFolderAddObj(name, item.getClass().getSimpleName(), null, ses, login, destinationNode, false);
            accountingHandler.createEntryCreate(item.getTitle(), ses, newNode, login, false);
        }
        return newNode;
    }

    public static Node createGcubeItemInternally(Session ses, Node destinationNode, String name, String description, String login, GCubeItem gcubeItem, AccountingHandler accountingHandler) throws BackendGenericError {
        Calendar now = Calendar.getInstance();
        gcubeItem.setName(name);
        gcubeItem.setTitle(name);
        gcubeItem.setDescription(description);
        gcubeItem.setHidden(false);
        gcubeItem.setLastAction(ItemAction.CREATED);
        gcubeItem.setLastModificationTime(now);
        gcubeItem.setLastModifiedBy(login);
        gcubeItem.setOwner(login);
        Node newNode = new Item2NodeConverter().getNode(destinationNode, (RootItem)gcubeItem);
        return newNode;
    }

    public static void setPropertyOnChangeNode(Node node, String login, ItemAction action) throws RepositoryException {
        node.setProperty(NodeProperty.LAST_MODIFIED.toString(), Calendar.getInstance());
        node.setProperty(NodeProperty.LAST_MODIFIED_BY.toString(), login);
        node.setProperty(NodeProperty.LAST_ACTION.toString(), action.name());
    }

    public static void setContentFromMetaInfo(AbstractFileItem item, MetaInfo contentInfo) {
        item.getContent().setSize(Long.valueOf(contentInfo.getSize()));
        item.getContent().setRemotePath(contentInfo.getRemotePath());
        item.getContent().setSize(Long.valueOf(contentInfo.getSize()));
        item.getContent().setPayloadBackend(contentInfo.getPayloadBackend());
    }
}

