/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.storage.backend.impl;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.util.IOUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.gcube.common.storagehub.model.exceptions.StorageIdNotFoundException;
import org.gcube.common.storagehub.model.items.nodes.Content;
import org.gcube.common.storagehub.model.items.nodes.PayloadBackend;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Backend
extends StorageBackend {
    private static Logger log = LoggerFactory.getLogger(S3Backend.class);
    Function<Void, String> keyGenerator;
    String bucketName;
    AmazonS3 client;

    protected void setPayloadConfiguration(PayloadBackend payloadConfiguration) {
        super.setPayloadConfiguration(payloadConfiguration);
    }

    public S3Backend(PayloadBackend payloadConfiguration, Function<Void, String> keyGenerator) {
        super(payloadConfiguration);
        this.keyGenerator = keyGenerator;
        Map parameters = payloadConfiguration.getParameters();
        this.bucketName = (String)parameters.get("bucketName");
        String accessKey = (String)parameters.get("key");
        String secret = (String)parameters.get("secret");
        String url = (String)parameters.get("url");
        boolean createBucket = Boolean.valueOf((String)parameters.get("createBucket"));
        log.debug("parameters are: bucketName = {}, url = {}, createBucket = {}", new Object[]{this.bucketName, url, createBucket});
        try {
            BasicAWSCredentials credentials = new BasicAWSCredentials(accessKey, secret);
            ClientConfiguration clientConfig = new ClientConfiguration();
            clientConfig.setProtocol(Protocol.HTTPS);
            this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(url, "us-east-1"))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).enablePathStyleAccess()).withClientConfiguration(clientConfig)).build();
            if (createBucket && !this.client.doesBucketExistV2(this.bucketName)) {
                log.debug("creating {} bucket", (Object)this.bucketName);
                this.client.createBucket(this.bucketName);
                log.debug("bucket {} created", (Object)this.bucketName);
            } else {
                log.debug("bucket not created");
            }
        }
        catch (Exception e) {
            log.error("error initializing s3", (Throwable)e);
            throw new RuntimeException("error initializing s3", e);
        }
    }

    public boolean isAlive() {
        boolean toReturn = true;
        try {
            toReturn = this.client.doesBucketExistV2(this.bucketName);
        }
        catch (Exception e) {
            log.error("error checking aliveness", (Throwable)e);
            toReturn = false;
        }
        log.debug("the S3 backend is {} Alive", (Object)(toReturn ? "" : "not"));
        return toReturn;
    }

    public MetaInfo onCopy(Content content, String newParentPath, String newName) {
        String sourceKey = content.getStorageId();
        String destinationKey = (String)this.keyGenerator.apply(null);
        try {
            this.client.copyObject(this.bucketName, sourceKey, this.bucketName, destinationKey);
        }
        catch (Exception e) {
            throw new RuntimeException("error copying file on s3", e);
        }
        return new MetaInfo(content.getSize().longValue(), destinationKey, null, this.getPayloadConfiguration());
    }

    public MetaInfo onMove(Content content, String newParentPath) {
        return new MetaInfo(content.getSize().longValue(), content.getStorageId(), content.getRemotePath(), this.getPayloadConfiguration());
    }

    public void delete(String storageId) {
        try {
            this.client.deleteObject(this.bucketName, storageId);
        }
        catch (Exception e) {
            throw new RuntimeException("error deleting file on s3", e);
        }
    }

    public MetaInfo upload(InputStream stream, String relativePath, String name, String user) {
        return this.upload(stream, relativePath, name, null, user);
    }

    public MetaInfo upload(InputStream stream, String relativePath, String name, Long size, String user) {
        String storageId = (String)this.keyGenerator.apply(null);
        return this.upload(stream, relativePath, name, storageId, size, user);
    }

    public MetaInfo upload(InputStream stream, String relativePath, String name, String storageId, Long size, String user) {
        try {
            long start = System.currentTimeMillis();
            ObjectMetadata objMeta = new ObjectMetadata();
            objMeta.addUserMetadata("user", user);
            objMeta.addUserMetadata("title", name);
            if (size != null && size > 0L) {
                objMeta.setContentLength(size.longValue());
                log.info("content length set to {}", (Object)size);
            } else {
                log.info("content length not set");
            }
            log.info("uploading file {} with id {} in bucket {} ", new Object[]{name, storageId, this.bucketName});
            if (size == null || size < 100000000L) {
                this.client.putObject(this.bucketName, storageId, stream, objMeta);
            } else {
                TransferManager tm = TransferManagerBuilder.standard().withS3Client(this.client).build();
                Upload upload = tm.upload(this.bucketName, storageId, stream, objMeta);
                upload.waitForCompletion();
            }
            long fileSize = size != null && size > 0L ? size.longValue() : this.client.getObjectMetadata(this.bucketName, storageId).getContentLength();
            IOUtils.drainInputStream((InputStream)stream);
            log.info("uploading file {} in {} seconds", (Object)name, (Object)((System.currentTimeMillis() - start) / 1000L));
            return new MetaInfo(fileSize, storageId, null, this.getPayloadConfiguration());
        }
        catch (Exception e) {
            log.error("error uploading file on s3", (Throwable)e);
            throw new RuntimeException("error uploading file on s3", e);
        }
    }

    public InputStream download(String id) throws StorageIdNotFoundException {
        try {
            S3ObjectInputStream inputStream = this.client.getObject(this.bucketName, id).getObjectContent();
            return inputStream;
        }
        catch (Exception e) {
            log.error("error downloading file form s3");
            throw new RuntimeException("error downloading file from s3", e);
        }
    }

    public InputStream download(Content content) throws StorageIdNotFoundException {
        return this.download(content.getStorageId());
    }

    public Map<String, String> getFileMetadata(String id) {
        try {
            ObjectMetadata objMeta = this.client.getObjectMetadata(this.bucketName, id);
            Map userMetadata = objMeta.getUserMetadata();
            HashMap<String, String> toReturn = new HashMap<String, String>(userMetadata);
            toReturn.put("size", Long.toString(objMeta.getContentLength()));
            return toReturn;
        }
        catch (Exception e) {
            log.error("error getting metadata from s3");
            throw new RuntimeException("error downloading file from s3", e);
        }
    }

    public String getTotalSizeStored() {
        return null;
    }

    public String getTotalItemsCount() {
        return null;
    }
}

